/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.client.gui;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.controls.gui.custom.GuiStackSelectorAll;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.stack.InfoBlock;
import com.creativemd.creativecore.common.utils.stack.InfoFuel;
import com.creativemd.creativecore.common.utils.stack.InfoItem;
import com.creativemd.creativecore.common.utils.stack.InfoItemStack;
import com.creativemd.creativecore.common.utils.stack.InfoMaterial;
import com.creativemd.creativecore.common.utils.stack.InfoName;
import com.creativemd.creativecore.common.utils.stack.InfoOre;
import com.creativemd.creativecore.common.utils.stack.InfoStack;
import com.creativemd.igcm.client.gui.SubGuiFullItemDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@SideOnly(value=Side.CLIENT)
public abstract class GuiInfoHandler {
    private static LinkedHashMap<String, GuiInfoHandler> handlers = new LinkedHashMap();
    public static GuiInfoHandler defaultHandler = new GuiInfoHandler(){

        @Override
        public void createControls(SubGuiFullItemDialog gui, InfoStack info) {
            GuiStackSelectorAll selector = new GuiStackSelectorAll("inv", 0, 30, 122, gui.container.player, (GuiStackSelectorAll.StackCollector)new GuiStackSelectorAll.CreativeCollector((GuiStackSelectorAll.StackSelector)new GuiStackSelectorAll.SearchSelector()));
            gui.controls.add(selector);
            gui.controls.add(new GuiTextfield("search", "", 0, 57, 144, 14));
            gui.controls.add(new GuiLabel("guilabel1", 0, 80));
            gui.controls.add(new GuiLabel("guilabel2", 0, 90));
            GuiStateButton damage = new GuiStateButton("damage", 0, 0, 106, 70, 14, new String[]{"Damage: Off", "Damage: On"});
            gui.controls.add(damage);
            GuiStateButton nbt = new GuiStateButton("nbt", 0, 80, 106, 60, 14, new String[]{"NBT: Off", "NBT: On"});
            gui.controls.add(nbt);
            if (info instanceof InfoBlock || info instanceof InfoItem || info instanceof InfoItemStack) {
                selector.setSelectedForce(info.getItemStack().func_77946_l());
                if (info instanceof InfoItemStack) {
                    damage.nextState();
                    if (((InfoItemStack)info).needNBT) {
                        nbt.nextState();
                    }
                }
            }
            this.onChanged(gui, new GuiControlChangedEvent((GuiControl)selector));
        }

        @Override
        public boolean canHandle(InfoStack info) {
            return info instanceof InfoBlock || info instanceof InfoItem || info instanceof InfoItemStack;
        }

        @Override
        public InfoStack parseInfo(SubGuiFullItemDialog gui, int stackSize) {
            ItemStack stack = ((GuiStackSelectorAll)gui.get("inv")).getSelected();
            if (stack != null) {
                boolean nbt;
                boolean damage = ((GuiStateButton)gui.get("damage")).getState() == 1;
                boolean bl = nbt = ((GuiStateButton)gui.get("nbt")).getState() == 1;
                if (damage) {
                    return new InfoItemStack(stack.func_77946_l(), nbt, stackSize);
                }
                if (!(Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockAir)) {
                    return new InfoBlock(Block.func_149634_a((Item)stack.func_77973_b()), stackSize);
                }
                return new InfoItem(stack.func_77973_b(), stackSize);
            }
            return null;
        }

        @Override
        public void onChanged(SubGuiFullItemDialog gui, GuiControlChangedEvent event) {
            GuiStackSelectorAll selector;
            if (event.source.is(new String[]{"search"})) {
                GuiStackSelectorAll inv = (GuiStackSelectorAll)gui.get("inv");
                ((GuiStackSelectorAll.SearchSelector)inv.collector.selector).search = ((GuiTextfield)event.source).text.toLowerCase();
                inv.updateCollectedStacks();
                inv.closeBox();
            } else if (event.source.is(new String[]{"inv"}) && (selector = (GuiStackSelectorAll)gui.get("inv")) != null) {
                ItemStack stack = selector.getSelected();
                if (!stack.func_190926_b()) {
                    ((GuiLabel)gui.get((String)"guilabel1")).caption = "damage: " + stack.func_77952_i();
                    ((GuiLabel)gui.get((String)"guilabel2")).caption = "nbt: " + (stack.func_77942_o() ? stack.func_77978_p().toString() : "null");
                } else {
                    ((GuiLabel)gui.get((String)"guilabel1")).caption = "";
                    ((GuiLabel)gui.get((String)"guilabel2")).caption = "";
                }
            }
        }
    };
    private String name;

    public static void registerGuiInfoHandler(String name, GuiInfoHandler handler) {
        handler.name = name;
        handlers.put(name, handler);
    }

    public static Set<String> getNames() {
        return handlers.keySet();
    }

    public static GuiInfoHandler getHandler(InfoStack info) {
        if (info != null) {
            for (GuiInfoHandler handler : handlers.values()) {
                if (!handler.canHandle(info)) continue;
                return handler;
            }
        }
        return defaultHandler;
    }

    public static GuiInfoHandler getHandler(String name) {
        GuiInfoHandler handler = handlers.get(name);
        if (handler == null) {
            return defaultHandler;
        }
        return handler;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean canHandle(InfoStack var1);

    public abstract void createControls(SubGuiFullItemDialog var1, InfoStack var2);

    public abstract InfoStack parseInfo(SubGuiFullItemDialog var1, int var2);

    public void onChanged(SubGuiFullItemDialog gui, GuiControlChangedEvent event) {
    }

    static {
        GuiInfoHandler.registerGuiInfoHandler("Default", defaultHandler);
        GuiInfoHandler.registerGuiInfoHandler("Ore", new GuiInfoHandler(){

            @Override
            public InfoStack parseInfo(SubGuiFullItemDialog gui, int stackSize) {
                String ore = ((GuiComboBox)gui.get((String)"ore")).caption;
                if (!ore.equals("")) {
                    return new InfoOre(ore, stackSize);
                }
                return null;
            }

            @Override
            public void createControls(SubGuiFullItemDialog gui, InfoStack info) {
                ArrayList<String> ores = new ArrayList<String>(Arrays.asList(OreDictionary.getOreNames()));
                GuiComboBox ore = new GuiComboBox("ore", 0, 30, 144, ores);
                gui.controls.add(ore);
                gui.controls.add(new GuiTextfield("search", "", 0, 57, 144, 14));
                if (info instanceof InfoOre) {
                    ore.caption = ((InfoOre)info).ore;
                }
            }

            @Override
            public boolean canHandle(InfoStack info) {
                return info instanceof InfoOre;
            }

            @Override
            public void onChanged(SubGuiFullItemDialog gui, GuiControlChangedEvent event) {
                if (event.source.is(new String[]{"search"})) {
                    String search = ((GuiTextfield)event.source).text;
                    String[] oreNames = OreDictionary.getOreNames();
                    ArrayList<String> ores = new ArrayList<String>();
                    for (int i = 0; i < oreNames.length; ++i) {
                        if (!oreNames[i].toLowerCase().contains(search.toLowerCase())) continue;
                        ores.add(oreNames[i]);
                    }
                    GuiComboBox comboBox = (GuiComboBox)gui.get("ore");
                    if (comboBox != null) {
                        comboBox.lines = ores;
                        if (!ores.contains(comboBox.caption)) {
                            comboBox.caption = ores.size() > 0 ? (String)ores.get(0) : "";
                        }
                    }
                }
            }
        });
        GuiInfoHandler.registerGuiInfoHandler("Material", new GuiInfoHandler(){

            @Override
            public InfoStack parseInfo(SubGuiFullItemDialog gui, int stackSize) {
                Block block;
                ItemStack blockStack = ((GuiStackSelectorAll)gui.get("inv")).getSelected();
                if (blockStack != null && !((block = Block.func_149634_a((Item)blockStack.func_77973_b())) instanceof BlockAir)) {
                    return new InfoMaterial(block.func_149688_o(null), stackSize);
                }
                return null;
            }

            @Override
            public void createControls(SubGuiFullItemDialog gui, InfoStack info) {
                GuiStackSelectorAll selector = new GuiStackSelectorAll("inv", 0, 30, 122, gui.container.player, (GuiStackSelectorAll.StackCollector)new GuiStackSelectorAll.CreativeCollector((GuiStackSelectorAll.StackSelector)new GuiStackSelectorAll.BlockSelector()));
                gui.controls.add(selector);
                if (info instanceof InfoMaterial) {
                    selector.setSelectedForce(info.getItemStack());
                }
            }

            @Override
            public boolean canHandle(InfoStack info) {
                return info instanceof InfoMaterial;
            }
        });
        GuiInfoHandler.registerGuiInfoHandler("Fuel", new GuiInfoHandler(){

            @Override
            public InfoStack parseInfo(SubGuiFullItemDialog gui, int stackSize) {
                return new InfoFuel(stackSize);
            }

            @Override
            public void createControls(SubGuiFullItemDialog gui, InfoStack info) {
                gui.controls.add(new GuiLabel("Nothing to select", 5, 30));
            }

            @Override
            public boolean canHandle(InfoStack info) {
                return info instanceof InfoFuel;
            }
        });
        GuiInfoHandler.registerGuiInfoHandler("Name", new GuiInfoHandler(){

            @Override
            public InfoStack parseInfo(SubGuiFullItemDialog gui, int stackSize) {
                return new InfoName(((GuiTextfield)gui.get((String)"pattern")).text, stackSize);
            }

            @Override
            public void createControls(SubGuiFullItemDialog gui, InfoStack info) {
                gui.controls.add(new GuiTextfield("pattern", "", 0, 57, 144, 14));
            }

            @Override
            public boolean canHandle(InfoStack info) {
                return info instanceof InfoName;
            }
        });
    }
}

