/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.api.sorting;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.utils.stack.InfoStack;
import com.creativemd.creativecore.common.utils.type.SortingList;
import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigSegment;
import com.creativemd.igcm.api.segments.BooleanSegment;
import com.creativemd.igcm.api.segments.advanced.InfoSegment;
import com.creativemd.igcm.client.gui.SubGuiConfigSegement;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConfigBranchSorting
extends ConfigBranch {
    public SortingList defaultList;
    public SortingList sortingList;

    public ConfigBranchSorting(String title, ItemStack avatar, SortingList defaultList) {
        super(title, avatar);
        this.defaultList = new SortingList(defaultList);
        this.sortingList = defaultList;
    }

    @Override
    public void createChildren() {
        this.registerElement("whitelist", new BooleanSegment("Whiltelist", this.defaultList.isWhitelist()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiCreatesSegments(SubGuiConfigSegement gui, ArrayList<ConfigSegment> segments) {
        for (int i = 0; i < this.sortingList.size(); ++i) {
            segments.add(new InfoSegment("Info", this.sortingList.get(i)));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiLoadedAllSegments(SubGuiConfigSegement gui, final GuiScrollBox box, final ArrayList<ConfigSegment> segments) {
        box.addControl((GuiControl)new GuiButton("add filter", 5, gui.height){

            public void onClicked(int x, int y, int button) {
                box.controls.remove((Object)this);
                segments.add(new InfoSegment("Segment", null));
            }
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiLoadSegment(final SubGuiConfigSegement gui, GuiScrollBox box, ArrayList<ConfigSegment> segments, final ConfigSegment segment) {
        if (segment instanceof InfoSegment) {
            GuiButton button = new GuiButton("X", 200, gui.height, 14){

                public void onClicked(int x, int y, int button) {
                    gui.removeSegment(segment);
                }
            };
            segment.getGuiControls().add((GuiControl)button);
            box.addControl((GuiControl)button);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiSavesSegments(SubGuiConfigSegement gui, ArrayList<ConfigSegment> segments) {
        int i;
        for (i = 0; i < segments.size(); ++i) {
            segments.get(i).saveFromControls();
        }
        this.sortingList.clear();
        for (i = 0; i < segments.size(); ++i) {
            ConfigSegment segment = segments.get(i);
            if (!(segment instanceof InfoSegment) || ((InfoSegment)segment).value == null) continue;
            this.sortingList.add((InfoStack)((InfoSegment)segment).value);
        }
    }

    @Override
    public boolean requiresSynchronization() {
        return true;
    }

    @Override
    public void onRecieveFrom(Side side) {
        this.sortingList.setListType(((Boolean)this.getValue("whitelist")).booleanValue());
    }

    @Override
    public void loadExtra(NBTTagCompound nbt) {
        InfoStack info;
        int i;
        this.sortingList.clear();
        ArrayList<InfoStack> removed = new ArrayList<InfoStack>();
        NBTTagList list = nbt.func_150295_c(this.getKey() + "removed", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            info = InfoStack.parseNBT((NBTTagCompound)list.func_150305_b(i));
            if (info == null) continue;
            removed.add(info);
        }
        for (i = 0; i < this.defaultList.size(); ++i) {
            if (removed.contains(this.defaultList.get(i))) continue;
            this.sortingList.add(this.defaultList.get(i));
        }
        list = nbt.func_150295_c(this.getKey() + "added", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            info = InfoStack.parseNBT((NBTTagCompound)list.func_150305_b(i));
            if (info == null) continue;
            this.sortingList.add(info);
        }
    }

    @Override
    public void saveExtra(NBTTagCompound nbt) {
        NBTTagList removed = new NBTTagList();
        for (int i = 0; i < this.defaultList.size(); ++i) {
            if (this.sortingList.contains((Object)this.defaultList.get(i))) continue;
            removed.func_74742_a((NBTBase)this.defaultList.get(i).writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a(this.getKey() + "removed", (NBTBase)removed);
        NBTTagList added = new NBTTagList();
        for (int i = 0; i < this.sortingList.size(); ++i) {
            if (this.defaultList.contains((Object)this.sortingList.get(i))) continue;
            added.func_74742_a((NBTBase)this.sortingList.get(i).writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a(this.getKey() + "added", (NBTBase)added);
    }

    @Override
    public boolean doesInputSupportStackSize() {
        return false;
    }
}

