/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.api.segments.advanced;

import com.creativemd.creativecore.common.gui.ContainerControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.utils.stack.InfoBlock;
import com.creativemd.creativecore.common.utils.stack.InfoContainOre;
import com.creativemd.creativecore.common.utils.stack.InfoFuel;
import com.creativemd.creativecore.common.utils.stack.InfoItem;
import com.creativemd.creativecore.common.utils.stack.InfoItemStack;
import com.creativemd.creativecore.common.utils.stack.InfoMaterial;
import com.creativemd.creativecore.common.utils.stack.InfoName;
import com.creativemd.creativecore.common.utils.stack.InfoOre;
import com.creativemd.creativecore.common.utils.stack.InfoStack;
import com.creativemd.igcm.api.segments.ValueSegment;
import com.creativemd.igcm.container.controls.InfoSlotControl;
import com.creativemd.igcm.utils.SearchUtils;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InfoSegment
extends ValueSegment<InfoStack> {
    @SideOnly(value=Side.CLIENT)
    public GuiLabel label;

    public InfoSegment(String title, InfoStack defaultValue) {
        super(title, defaultValue);
    }

    public String getLabelText(InfoStack value) {
        if (value == null) {
            return "";
        }
        if (value instanceof InfoBlock) {
            return "Block: " + ChatFormatting.YELLOW + ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)((InfoBlock)value).block)).toString();
        }
        if (value instanceof InfoItem) {
            return "Item: " + ChatFormatting.YELLOW + ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)((InfoItem)value).item)).toString();
        }
        if (value instanceof InfoItemStack) {
            return "ItemStack";
        }
        if (value instanceof InfoMaterial) {
            String name = null;
            for (int i = 0; i < Material.class.getDeclaredFields().length; ++i) {
                try {
                    if (!Modifier.isStatic(Material.class.getDeclaredFields()[i].getModifiers()) || Material.class.getDeclaredFields()[i].get(null) != ((InfoMaterial)value).material) continue;
                    name = Material.class.getDeclaredFields()[i].getName();
                    break;
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                    e.printStackTrace();
                }
            }
            if (name != null) {
                return "Material: " + ChatFormatting.YELLOW + name;
            }
            return "Material: " + ChatFormatting.YELLOW + "unknown name";
        }
        if (value instanceof InfoOre) {
            return "Ore: " + ChatFormatting.YELLOW + ((InfoOre)value).ore;
        }
        if (value instanceof InfoContainOre) {
            return "Ore (Contains): " + ChatFormatting.YELLOW + ((InfoContainOre)value).ore;
        }
        if (value instanceof InfoName) {
            return "Name (Contains): " + ChatFormatting.YELLOW + ((InfoName)value).name;
        }
        if (value instanceof InfoFuel) {
            return "All fuels";
        }
        return "no description given.";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ArrayList<GuiControl> createGuiControls(SubGui gui, int x, int y, int maxWidth) {
        ArrayList<GuiControl> controls = super.createGuiControls(gui, x, y, maxWidth);
        this.label = new GuiLabel(this.getLabelText((InfoStack)this.value), 25, y + 5);
        controls.add((GuiControl)this.label);
        return controls;
    }

    @Override
    public ArrayList<ContainerControl> createContainerControls(SubContainer container, int x, int y, int maxWidth) {
        ArrayList<ContainerControl> slots = super.createContainerControls(container, x, y, maxWidth);
        InventoryBasic basic = new InventoryBasic(this.getKey(), false, 1);
        slots.add((ContainerControl)new InfoSlotControl((IInventory)basic, 0, x + 5, y + 5, (InfoStack)this.value){

            @Override
            public void putInfo(InfoStack info) {
                super.putInfo(info);
                InfoSegment.this.label.caption = InfoSegment.this.getLabelText(info);
                InfoSegment.this.label.width = GuiRenderHelper.instance.font.func_78256_a(InfoSegment.this.label.caption) + InfoSegment.this.label.getContentOffset() * 2;
            }
        });
        return slots;
    }

    @Override
    public void loadExtra(NBTTagCompound nbt) {
        this.value = InfoStack.parseNBT((NBTTagCompound)nbt);
    }

    @Override
    public void saveExtra(NBTTagCompound nbt) {
        if (this.value != null) {
            ((InfoStack)this.value).writeToNBT(nbt);
        }
    }

    @Override
    public boolean contains(String search) {
        if (!super.contains(search)) {
            if (this.value != null) {
                return SearchUtils.canInfoBeFound((InfoStack)this.value, search);
            }
            return false;
        }
        return true;
    }

    @Override
    public void saveFromControls() {
        super.saveFromControls();
        this.value = ((InfoSlotControl)this.getContainerControl((String)new StringBuilder().append((String)this.getKey()).append((int)0).toString())).info;
    }

    @Override
    public void set(InfoStack newValue) {
        this.value = newValue;
    }
}

