/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.api.segments.advanced;

import com.creativemd.creativecore.common.gui.ContainerControl;
import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.utils.stack.InfoStack;
import com.creativemd.igcm.api.machine.RecipeMachine;
import com.creativemd.igcm.api.segments.ValueSegment;
import com.creativemd.igcm.container.controls.InfoSlotControl;
import com.creativemd.igcm.utils.SearchUtils;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class InfoGridSegment
extends ValueSegment<InfoStack[]> {
    public RecipeMachine machine;

    public InfoGridSegment(String id, InfoStack[] defaultValue, RecipeMachine machine) {
        super(id, defaultValue);
        this.machine = machine;
    }

    public void empty() {
        for (int i = 0; i < ((InfoStack[])this.value).length; ++i) {
            InfoSlotControl slot = (InfoSlotControl)this.getContainerControl(this.getKey() + i);
            slot.slot.func_75215_d(ItemStack.field_190927_a);
            slot.info = null;
        }
    }

    @Override
    public ArrayList<ContainerControl> createContainerControls(SubContainer container, int x, int y, int maxWidth) {
        ArrayList<ContainerControl> slots = super.createContainerControls(container, x, y, maxWidth);
        if (this.value == null) {
            this.value = new InfoStack[this.machine.getWidth() * this.machine.getHeight()];
        }
        InventoryBasic basic = new InventoryBasic(this.getKey(), false, ((InfoStack[])this.value).length);
        for (int i = 0; i < ((InfoStack[])this.value).length; ++i) {
            slots.add((ContainerControl)new InfoSlotControl((IInventory)basic, i, 5 + x + i * 18 - i / this.machine.getWidth() * this.machine.getWidth() * 18, y + i / this.machine.getWidth() * 18, ((InfoStack[])this.value)[i]));
        }
        return slots;
    }

    @Override
    public void loadExtra(NBTTagCompound nbt) {
        if (this.value == null) {
            this.value = new InfoStack[this.machine.getWidth() * this.machine.getHeight()];
        }
        for (int i = 0; i < ((InfoStack[])this.value).length; ++i) {
            if (!nbt.func_74764_b(this.getKey() + i)) continue;
            ((InfoStack[])this.value)[i] = InfoStack.parseNBT((NBTTagCompound)nbt.func_74775_l(this.getKey() + i));
        }
    }

    @Override
    public void saveExtra(NBTTagCompound nbt) {
        for (int i = 0; i < ((InfoStack[])this.value).length; ++i) {
            if (((InfoStack[])this.value)[i] == null) continue;
            nbt.func_74782_a(this.getKey() + i, (NBTBase)((InfoStack[])this.value)[i].writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public boolean contains(String search) {
        if (!super.contains(search)) {
            for (int i = 0; i < ((InfoStack[])this.value).length; ++i) {
                if (!SearchUtils.canInfoBeFound(((InfoStack[])this.value)[i], search)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void saveFromControls() {
        super.saveFromControls();
        for (int i = 0; i < ((InfoStack[])this.value).length; ++i) {
            ((InfoStack[])this.value)[i] = ((InfoSlotControl)this.getContainerControl((String)new StringBuilder().append((String)this.getKey()).append((int)i).toString())).info;
        }
    }

    @Override
    public void set(InfoStack[] newValue) {
        this.value = newValue;
    }
}

