/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.api.segments.advanced;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.igcm.api.machine.RecipeMachine;
import com.creativemd.igcm.api.segments.advanced.GridSegment;
import com.creativemd.igcm.api.segments.advanced.RecipeSegment;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DisableRecipeSegment
extends RecipeSegment<Boolean> {
    public boolean showName = false;

    public DisableRecipeSegment(String title, Boolean defaultValue, RecipeMachine machine, Object recipe, boolean showName) {
        super(title, defaultValue, machine, recipe);
        this.showName = showName;
    }

    @Override
    public void addSubSegments() {
        ItemStack[] items = new ItemStack[this.machine.getWidth() * this.machine.getHeight()];
        this.machine.fillGrid(items, this.recipe);
        this.registerElement("grid", new GridSegment(this.getKey() + "grid", items, this.machine).setOffset(30, 0));
        this.registerElement("result", new GridSegment(this.getKey() + "result", this.machine.getOutput(this.recipe), this.machine).setOffset(130, 5 + this.machine.getHeight() / 2 * 18));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ArrayList<GuiControl> createGuiControls(SubGui gui, int x, int y, int maxWidth) {
        ArrayList<GuiControl> controls = super.createGuiControls(gui, x, y, maxWidth);
        controls.add((GuiControl)new GuiStateButton(this.getKey(), (Boolean)this.value != false ? 1 : 0, x + 150, y + 20, 50, 14, new String[]{"Enabled", "Disabled"}));
        if (this.showName) {
            controls.add((GuiControl)new GuiLabel(this.getKey(), x + 100, y));
        }
        return controls;
    }

    @Override
    public boolean contains(String search) {
        if (super.contains(search)) {
            return true;
        }
        if (!((Boolean)this.value).booleanValue()) {
            return "enabled".contains(search);
        }
        return "disabled".contains(search);
    }

    @Override
    public void loadExtra(NBTTagCompound nbt) {
        this.value = nbt.func_74767_n(this.getKey());
    }

    @Override
    public void saveExtra(NBTTagCompound nbt) {
        if (((Boolean)this.value).booleanValue()) {
            nbt.func_74757_a(this.getKey(), ((Boolean)this.value).booleanValue());
        } else if (nbt.func_74764_b(this.getKey())) {
            nbt.func_82580_o(this.getKey());
        }
    }

    @Override
    public void saveFromControls() {
        GuiControl button = this.getGuiControl(this.getKey());
        if (button instanceof GuiButton) {
            this.value = !((GuiButton)button).caption.equals("Enabled");
        }
    }

    @Override
    public void set(Boolean newValue) {
        this.value = newValue;
    }
}

