/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.api.segments.advanced;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.utils.stack.InfoStack;
import com.creativemd.igcm.api.machine.RecipeMachine;
import com.creativemd.igcm.api.segments.advanced.InfoGridSegment;
import com.creativemd.igcm.api.segments.advanced.OutputSegment;
import com.creativemd.igcm.api.segments.advanced.RecipeSegment;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AddRecipeSegment
extends RecipeSegment<Object> {
    public int width = 0;
    public int height = 0;

    public AddRecipeSegment(String id, RecipeMachine machine, Object recipe) {
        super(id, recipe, machine, recipe);
    }

    @Override
    public void addSubSegments() {
        InfoStack[] items = null;
        if (this.value != null) {
            items = new InfoStack[this.machine.getWidth() * this.machine.getHeight()];
            this.machine.fillGridInfo(items, this.recipe);
        }
        this.registerElement("grid", new InfoGridSegment("grid", items, this.machine));
        this.registerElement("output", new OutputSegment("output", this.value != null ? this.machine.getOutput(this.value) : null, this.machine).setOffset(114, this.machine.getHeight() * 18 / 2 - this.machine.getOutputCount() * 18 / 2));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ArrayList<GuiControl> createGuiControls(SubGui gui, int x, int y, int maxWidth) {
        return super.createGuiControls(gui, x, y, maxWidth);
    }

    public void onRemoveRecipe() {
        ((InfoGridSegment)this.getChildByKey("grid")).empty();
        ((OutputSegment)this.getChildByKey("output")).empty();
    }

    public InfoStack[] getInput(InfoStack[] input) {
        int startX = this.machine.getWidth();
        int endX = 0;
        int startY = this.machine.getHeight();
        int endY = 0;
        boolean found = false;
        for (int x = 0; x < this.machine.getWidth(); ++x) {
            for (int y = 0; y < this.machine.getHeight(); ++y) {
                if (input[x + y * this.machine.getWidth()] == null) continue;
                startX = Math.min(startX, x);
                endX = Math.max(endX, x);
                startY = Math.min(startY, y);
                endY = Math.max(endY, y);
                found = true;
            }
        }
        int width = endX - startX + 1;
        int height = endY - startY + 1;
        InfoStack[] result = new InfoStack[width * height];
        for (int i = 0; i < result.length; ++i) {
            int rows = i / width;
            result[i] = input[startX + (startY + rows) * this.machine.getWidth() + (i - rows * width)];
        }
        return result;
    }

    public void parseRecipe(NBTTagCompound nbt) {
        InfoStack[] input = (InfoStack[])((InfoStack[])((InfoGridSegment)this.getChildByKey((String)"grid")).value).clone();
        int startX = this.machine.getWidth();
        int endX = 0;
        int startY = this.machine.getHeight();
        int endY = 0;
        boolean found = false;
        for (int x = 0; x < this.machine.getWidth(); ++x) {
            for (int y = 0; y < this.machine.getHeight(); ++y) {
                if (input[x + y * this.machine.getWidth()] == null) continue;
                startX = Math.min(startX, x);
                endX = Math.max(endX, x);
                startY = Math.min(startY, y);
                endY = Math.max(endY, y);
                found = true;
            }
        }
        boolean hasOutput = false;
        OutputSegment output = (OutputSegment)this.getChildByKey("output");
        if (output.value != null) {
            for (int i = 0; i < ((ItemStack[])output.value).length; ++i) {
                if (((ItemStack[])output.value)[i] == null || ((ItemStack[])output.value)[i].func_190926_b()) continue;
                hasOutput = true;
                break;
            }
        }
        if (found && hasOutput) {
            int width = endX - startX + 1;
            int height = endY - startY + 1;
            InfoStack[] info = new InfoStack[width * height];
            for (int i = 0; i < info.length; ++i) {
                int rows = i / width;
                info[i] = input[startX + (startY + rows) * this.machine.getWidth() + (i - rows * width)];
            }
            this.width = width;
            this.height = height;
            this.value = this.machine.parseRecipe(info, (ItemStack[])output.value, nbt, width, height);
        } else {
            this.value = null;
        }
    }

    @Override
    public void loadExtra(NBTTagCompound nbt) {
        this.parseRecipe(nbt);
    }

    @Override
    public void saveExtra(NBTTagCompound nbt) {
        this.machine.writeExtraInfo(this.value, nbt);
    }

    @Override
    public void saveFromControls() {
        super.saveFromControls();
        NBTTagCompound nbt = new NBTTagCompound();
        this.machine.parseExtraInfo(nbt, this, this.getGuiControls(), this.getContainerControls());
        this.parseRecipe(nbt);
    }

    @Override
    public void set(Object newValue) {
        this.value = newValue;
    }
}

