/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.api.segments;

import com.creativemd.igcm.api.ConfigSegment;
import com.creativemd.igcm.api.segments.ICommandSupport;
import com.creativemd.igcm.command.CommandParser;
import net.minecraft.command.CommandException;

public abstract class ValueSegment<T>
extends ConfigSegment
implements ICommandSupport {
    public T defaultValue;
    public T value;

    public ValueSegment(String title, T defaultValue) {
        super(title);
        this.value = defaultValue;
        this.defaultValue = defaultValue;
    }

    @Override
    public void initDefault() {
        this.value = this.defaultValue;
        super.initDefault();
    }

    @Override
    public boolean contains(String search) {
        if (this.title != null && this.title.toLowerCase().contains(search)) {
            return true;
        }
        if (this.value != null && this.value.toString().toLowerCase().contains(search)) {
            return true;
        }
        return this.getKey().toLowerCase().contains(search);
    }

    public abstract void set(T var1);

    @Override
    public boolean hasCommandSupport() {
        return CommandParser.canParseObject(this.value.getClass());
    }

    @Override
    public void parseValue(String arg) throws CommandException {
        this.set(CommandParser.parseObject(arg, this.value.getClass()));
    }

    @Override
    public String printValue() {
        return CommandParser.printObject(this.value);
    }

    @Override
    public String printDefaultValue() {
        return CommandParser.printObject(this.defaultValue);
    }

    @Override
    public String[] getPossibleValues() {
        if (this.value instanceof Boolean) {
            return new String[]{"true", "false"};
        }
        return null;
    }
}

