/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.api.segments;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.igcm.api.segments.TitleSegment;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class SelectSegment
extends TitleSegment<String> {
    public String[] options;

    public SelectSegment(String title, String defaultValue, String ... options) {
        super(title, defaultValue);
        this.options = options;
    }

    public SelectSegment(String title, int index, String ... options) {
        this(title, options[index], options);
        this.options = options;
    }

    public int getIndex() {
        return ArrayUtils.indexOf((Object[])this.options, (Object)this.value);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ArrayList<GuiControl> createGuiControls(SubGui gui, int x, int y, int maxWidth) {
        ArrayList<GuiControl> controls = super.createGuiControls(gui, x, y, maxWidth);
        GuiComboBox box = new GuiComboBox(this.getKey(), x + maxWidth - 100, y, 90, new ArrayList<String>(Arrays.asList(this.options)));
        box.caption = (String)this.value;
        controls.add((GuiControl)box);
        return controls;
    }

    @Override
    public void loadExtra(NBTTagCompound nbt) {
        if (nbt.func_74764_b(this.getKey())) {
            this.value = nbt.func_74779_i(this.getKey());
        } else {
            this.initDefault();
        }
    }

    @Override
    public void saveExtra(NBTTagCompound nbt) {
        nbt.func_74778_a(this.getKey(), (String)this.value);
    }

    @Override
    public void saveFromControls() {
        this.set(((GuiComboBox)this.getGuiControl((String)this.getKey())).caption);
    }

    @Override
    public void set(String newValue) {
        if (ArrayUtils.contains((Object[])this.options, (Object)newValue)) {
            this.value = newValue;
        }
    }

    @Override
    public String[] getPossibleValues() {
        return this.options;
    }
}

