/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.api.segments;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.igcm.api.segments.TitleSegment;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IntegerSegment
extends TitleSegment<Integer> {
    public int min;
    public int max;

    public IntegerSegment(String title, Integer defaultValue) {
        this(title, defaultValue, 0, Integer.MAX_VALUE);
    }

    public IntegerSegment(String title, Integer defaultValue, int min, int max) {
        super(title, defaultValue);
        this.min = min;
        this.max = max;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ArrayList<GuiControl> createGuiControls(SubGui gui, int x, int y, int maxWidth) {
        ArrayList<GuiControl> controls = super.createGuiControls(gui, x, y, maxWidth);
        controls.add((GuiControl)new GuiTextfield(this.getKey(), "" + this.value, x + maxWidth - 50, y, 40, 14).setNumbersOnly());
        return controls;
    }

    @Override
    public void loadExtra(NBTTagCompound nbt) {
        if (nbt.func_74764_b(this.getKey())) {
            this.value = MathHelper.func_76125_a((int)nbt.func_74762_e(this.getKey()), (int)this.min, (int)this.max);
        } else {
            this.initDefault();
        }
    }

    @Override
    public void saveExtra(NBTTagCompound nbt) {
        nbt.func_74768_a(this.getKey(), ((Integer)this.value).intValue());
    }

    @Override
    public void saveFromControls() {
        int valueBefore = (Integer)this.value;
        try {
            this.set(Integer.parseInt(((GuiTextfield)this.getGuiControl((String)this.getKey())).text));
        }
        catch (Exception e) {
            this.value = valueBefore;
        }
    }

    @Override
    public void set(Integer newValue) {
        this.value = MathHelper.func_76125_a((int)newValue, (int)this.min, (int)this.max);
    }
}

