/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.api.segments;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.igcm.api.segments.TitleSegment;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FloatSegment
extends TitleSegment<Float> {
    public float min;
    public float max;

    public FloatSegment(String title, Float defaultValue) {
        this(title, defaultValue, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY);
    }

    public FloatSegment(String title, Float defaultValue, float min, float max) {
        super(title, defaultValue);
        this.min = min;
        this.max = max;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ArrayList<GuiControl> createGuiControls(SubGui gui, int x, int y, int maxWidth) {
        ArrayList<GuiControl> controls = super.createGuiControls(gui, x, y, maxWidth);
        controls.add((GuiControl)new GuiTextfield(this.getKey(), "" + this.value, x + maxWidth - 50, y, 40, 14).setFloatOnly());
        return controls;
    }

    @Override
    public void loadExtra(NBTTagCompound nbt) {
        if (nbt.func_74764_b(this.getKey())) {
            this.value = Float.valueOf(nbt.func_74760_g(this.getKey()));
        } else {
            this.initDefault();
        }
    }

    @Override
    public void saveExtra(NBTTagCompound nbt) {
        nbt.func_74776_a(this.getKey(), ((Float)this.value).floatValue());
    }

    @Override
    public void saveFromControls() {
        float valueBefore = ((Float)this.value).floatValue();
        try {
            this.set(Float.valueOf(Float.parseFloat(((GuiTextfield)this.getGuiControl((String)this.getKey())).text)));
        }
        catch (Exception e) {
            this.value = Float.valueOf(valueBefore);
        }
    }

    @Override
    public void set(Float newValue) {
        this.value = Float.valueOf(MathHelper.func_76131_a((float)newValue.floatValue(), (float)this.min, (float)this.max));
    }
}

