/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.api.segments;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.igcm.api.segments.TitleSegment;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BooleanSegment
extends TitleSegment<Boolean> {
    public BooleanSegment(String title, Boolean defaultValue) {
        super(title, defaultValue);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ArrayList<GuiControl> createGuiControls(SubGui gui, int x, int y, int maxWidth) {
        ArrayList<GuiControl> controls = super.createGuiControls(gui, x, y, maxWidth);
        controls.add((GuiControl)new GuiStateButton(this.getKey(), ((Boolean)this.value).toString().replace("f", "F").replace("t", "T"), x + maxWidth - 50, y, 40, 14, new String[]{"True", "False"}));
        return controls;
    }

    @Override
    public void loadExtra(NBTTagCompound nbt) {
        if (nbt.func_74764_b(this.getKey())) {
            this.value = nbt.func_74767_n(this.getKey());
        } else {
            this.initDefault();
        }
    }

    @Override
    public void saveExtra(NBTTagCompound nbt) {
        nbt.func_74757_a(this.getKey(), ((Boolean)this.value).booleanValue());
    }

    @Override
    public void saveFromControls() {
        this.set(Boolean.parseBoolean(((GuiButton)this.getGuiControl((String)this.getKey())).caption));
    }

    @Override
    public void set(Boolean newValue) {
        this.value = newValue;
    }

    @Override
    public String[] getPossibleValues() {
        return new String[]{"true", "false"};
    }
}

