/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.api.machine;

import com.creativemd.creativecore.common.gui.ContainerControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.utils.stack.InfoStack;
import com.creativemd.igcm.api.ConfigElement;
import com.creativemd.igcm.api.ConfigSegment;
import com.creativemd.igcm.api.ConfigTab;
import com.creativemd.igcm.api.machine.ConfigMachineAddBranch;
import com.creativemd.igcm.api.machine.ConfigMachineBranch;
import com.creativemd.igcm.api.machine.ConfigMachineDisableBranch;
import com.creativemd.igcm.api.segments.advanced.AddRecipeSegment;
import com.creativemd.igcm.jei.JEIHandler;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class RecipeMachine<T> {
    public boolean sendingUpdate;
    public String id;
    public ConfigMachineDisableBranch disableBranch;
    public ConfigMachineAddBranch addBranch;
    public ConfigMachineBranch mainBranch;
    public ItemStack avatar;

    public RecipeMachine(String id, String title, ItemStack avatar) {
        this(ConfigTab.root, id, title, avatar);
    }

    public RecipeMachine(ConfigElement parent, String id, String title, ItemStack avatar) {
        this.id = id;
        this.avatar = avatar;
        this.mainBranch = new ConfigMachineBranch(title, avatar, this);
        parent.registerElement(id, this.mainBranch);
    }

    public String recipeToString(T recipe) {
        ItemStack[] input = new ItemStack[this.getHeight() * this.getWidth()];
        this.fillGrid(input, recipe);
        boolean emptyRecipe = true;
        StringBuilder builder = new StringBuilder("{");
        for (int i = 0; i < input.length; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            if (input[i] == null || input[i].func_190926_b()) continue;
            try {
                if (input[i].func_77973_b() instanceof ItemBlock) {
                    builder.append(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Block.func_149634_a((Item)input[i].func_77973_b()))).toString());
                } else {
                    builder.append(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)input[i].func_77973_b())).toString());
                }
                builder.append(":" + input[i].func_77952_i());
                emptyRecipe = false;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        builder.append("}{");
        ItemStack[] output = this.getOutput(recipe);
        for (int i = 0; i < output.length; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            if (output[i] == null || output[i].func_190926_b()) continue;
            try {
                if (output[i].func_77973_b() instanceof ItemBlock) {
                    builder.append(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Block.func_149634_a((Item)output[i].func_77973_b()))).toString());
                } else {
                    builder.append(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)output[i].func_77973_b())).toString());
                }
                builder.append(":" + output[i].func_77952_i());
                emptyRecipe = false;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        builder.append("}");
        if (emptyRecipe) {
            return recipe.getClass().getName();
        }
        return builder.toString();
    }

    public boolean hasDisableBranch() {
        return true;
    }

    public boolean hasAddedBranch() {
        return true;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract int getOutputCount();

    public abstract void addRecipeToList(Side var1, T var2);

    public abstract void clearRecipeList(Side var1);

    public abstract ItemStack[] getOutput(T var1);

    @SideOnly(value=Side.CLIENT)
    public void onControlCreated(T recipe, boolean isAdded, int x, int y, int maxWidth, ArrayList<GuiControl> guiControls, ArrayList<ContainerControl> containerControls) {
    }

    public ArrayList<ConfigSegment> getCustomSegments() {
        return new ArrayList<ConfigSegment>();
    }

    public void createExtraSegments() {
    }

    public void onReceiveFrom(Side side) {
    }

    public void onUpdateSendToClient(EntityPlayer player) {
    }

    public abstract List<T> getAllExitingRecipes();

    public abstract void fillGrid(ItemStack[] var1, T var2);

    public void onRecipeParsed(List<AddRecipeSegment> segments) {
    }

    public abstract boolean doesSupportStackSize();

    public abstract void fillGridInfo(InfoStack[] var1, T var2);

    public void writeExtraInfo(T recipe, NBTTagCompound nbt) {
    }

    public abstract T parseRecipe(InfoStack[] var1, ItemStack[] var2, NBTTagCompound var3, int var4, int var5);

    @SideOnly(value=Side.CLIENT)
    public void parseExtraInfo(NBTTagCompound nbt, AddRecipeSegment segment, ArrayList<GuiControl> guiControls, ArrayList<ContainerControl> containerControls) {
    }

    public abstract boolean hasJEISupport();

    public abstract String getJEICategory();

    @Optional.Method(modid="jei")
    public abstract List getJEIRecipes();

    @Optional.Method(modid="jei")
    public void updateJEI() {
        if (this.hasJEISupport() && JEIHandler.isActive && JEIHandler.recipeRegistry != null) {
            IRecipeCategory category = ((IRecipeRegistry)JEIHandler.recipeRegistry).getRecipeCategory(this.getJEICategory());
            JEIHandler.clearCategory(category.getUid());
            List recipes = this.getJEIRecipes();
            for (Object recipe : recipes) {
                IRecipeWrapper wrapper = ((IRecipeRegistry)JEIHandler.recipeRegistry).getRecipeWrapper(recipe, category.getUid());
                if (wrapper == null) continue;
                ((IRecipeRegistry)JEIHandler.recipeRegistry).addRecipe(wrapper, category.getUid());
            }
        }
    }
}

