/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.api.machine;

import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.machine.RecipeMachine;
import com.creativemd.igcm.api.segments.advanced.DisableRecipeSegment;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;

public class ConfigMachineDisableBranch
extends ConfigBranch {
    public RecipeMachine machine;
    public ArrayList allRecipes;

    public ConfigMachineDisableBranch(String title, RecipeMachine machine) {
        super(title, machine.avatar);
        this.machine = machine;
    }

    @Override
    public void initCore() {
        this.allRecipes = new ArrayList(this.machine.getAllExitingRecipes());
        super.initCore();
    }

    @Override
    public void createChildren() {
        for (int i = 0; i < this.allRecipes.size(); ++i) {
            String recipeName = this.recipeToString(this.allRecipes.get(i));
            this.registerElement(recipeName, new DisableRecipeSegment("recipe", false, this.machine, this.allRecipes.get(i), !recipeName.startsWith("{")));
        }
    }

    @Override
    public boolean requiresSynchronization() {
        return true;
    }

    public String recipeToString(Object recipe) {
        return this.machine.recipeToString(recipe);
    }

    @Override
    public void updateJEI() {
        this.machine.mainBranch.updateJEI();
    }

    @Override
    public void onRecieveFrom(Side side) {
        this.machine.mainBranch.onRecieveFrom(side);
    }

    @Override
    public void loadExtra(NBTTagCompound nbt) {
    }

    @Override
    public void saveExtra(NBTTagCompound nbt) {
    }

    @Override
    public void onUpdateSendToClient(EntityPlayer player) {
        this.machine.mainBranch.onUpdateSendToClient(player);
    }
}

