/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.api.machine;

import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigSegment;
import com.creativemd.igcm.api.machine.ConfigMachineAddBranch;
import com.creativemd.igcm.api.machine.ConfigMachineDisableBranch;
import com.creativemd.igcm.api.machine.RecipeMachine;
import com.creativemd.igcm.api.segments.SelectSegment;
import com.creativemd.igcm.api.segments.advanced.AddRecipeSegment;
import com.creativemd.igcm.api.segments.advanced.DisableRecipeSegment;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;

public class ConfigMachineBranch<T>
extends ConfigBranch {
    public static String[] states = new String[]{"all", "addedonly", "noadded", "none"};
    public RecipeMachine<T> machine;
    public int state = 0;

    public ConfigMachineBranch(String title, ItemStack avatar, RecipeMachine<T> machine) {
        super(title, avatar);
        this.machine = machine;
    }

    @Override
    public void createChildren() {
        if (this.machine.hasDisableBranch()) {
            this.machine.disableBranch = new ConfigMachineDisableBranch(this.title + " Disable", this.machine);
            this.registerElement(this.getKey() + "_disable", this.machine.disableBranch);
        }
        if (this.machine.hasAddedBranch()) {
            this.machine.addBranch = new ConfigMachineAddBranch(this.title + " Add", this.machine);
            this.registerElement(this.getKey() + "_add", this.machine.addBranch);
        }
        this.registerElement("state", new SelectSegment("General", this.state, states));
        this.machine.createExtraSegments();
    }

    @Override
    public boolean requiresSynchronization() {
        return true;
    }

    @Override
    public void onRecieveFrom(Side side) {
        this.machine.clearRecipeList(side);
        SelectSegment select = (SelectSegment)this.getChildByKey("state");
        int mode = select.getIndex();
        if (this.machine.hasDisableBranch() && (mode == 0 || mode == 2)) {
            Collection segments = this.machine.disableBranch.getChilds();
            for (ConfigSegment segment : segments) {
                if (!(segment instanceof DisableRecipeSegment) || ((Boolean)((DisableRecipeSegment)segment).value).booleanValue()) continue;
                this.machine.addRecipeToList(side, ((DisableRecipeSegment)segment).recipe);
            }
        }
        if (this.machine.hasAddedBranch() && (mode == 0 || mode == 1)) {
            for (ConfigSegment configSegment : this.machine.addBranch.recipes) {
                if (!(configSegment instanceof AddRecipeSegment) || ((AddRecipeSegment)configSegment).value == null) continue;
                this.machine.addRecipeToList(side, ((AddRecipeSegment)configSegment).value);
            }
        }
        this.machine.onReceiveFrom(side);
    }

    @Override
    @Optional.Method(modid="jei")
    public void updateJEI() {
        Minecraft.func_71410_x().func_152344_a(new Runnable(){

            @Override
            public void run() {
                ConfigMachineBranch.this.machine.updateJEI();
            }
        });
    }

    @Override
    public boolean doesInputSupportStackSize() {
        return this.machine.doesSupportStackSize();
    }

    @Override
    public void loadExtra(NBTTagCompound nbt) {
        this.state = nbt.func_74762_e("state");
    }

    @Override
    public void saveExtra(NBTTagCompound nbt) {
        nbt.func_74768_a("state", this.state);
    }

    @Override
    public void onUpdateSendToClient(EntityPlayer player) {
        this.machine.onUpdateSendToClient(player);
    }
}

