/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.api.machine;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigSegment;
import com.creativemd.igcm.api.machine.RecipeMachine;
import com.creativemd.igcm.api.segments.advanced.AddRecipeSegment;
import com.creativemd.igcm.client.gui.SubGuiConfigSegement;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConfigMachineAddBranch
extends ConfigBranch {
    public RecipeMachine machine;
    public ArrayList<AddRecipeSegment> recipes = new ArrayList();

    public ConfigMachineAddBranch(String title, RecipeMachine machine) {
        super(title, machine.avatar);
        this.machine = machine;
    }

    @Override
    public void createChildren() {
    }

    @Override
    public boolean requiresSynchronization() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiCreatesSegments(SubGuiConfigSegement gui, ArrayList<ConfigSegment> segments) {
        segments.addAll(this.recipes);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiLoadedAllSegments(SubGuiConfigSegement gui, final GuiScrollBox box, final ArrayList<ConfigSegment> segments) {
        box.addControl((GuiControl)new GuiButton("add recipe", 5, gui.height){

            public void onClicked(int x, int y, int button) {
                box.controls.remove((Object)this);
                segments.add(new AddRecipeSegment("", ConfigMachineAddBranch.this.machine, null));
            }
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiLoadSegment(final SubGuiConfigSegement gui, GuiScrollBox box, ArrayList<ConfigSegment> segments, final ConfigSegment segment) {
        GuiButton button = new GuiButton("X", 200, gui.height, 14){

            public void onClicked(int x, int y, int button) {
                gui.removeSegment(segment);
            }
        };
        segment.getGuiControls().add((GuiControl)button);
        box.addControl((GuiControl)button);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiSavesSegments(SubGuiConfigSegement gui, ArrayList<ConfigSegment> segments) {
        int i;
        for (i = 0; i < segments.size(); ++i) {
            segments.get(i).saveFromControls();
        }
        this.recipes.clear();
        for (i = 0; i < segments.size(); ++i) {
            ConfigSegment segment = segments.get(i);
            if (!(segment instanceof AddRecipeSegment) || ((AddRecipeSegment)segment).value == null) continue;
            this.recipes.add((AddRecipeSegment)segment);
        }
        this.machine.onRecipeParsed(this.recipes);
    }

    @Override
    public boolean doesInputSupportStackSize() {
        return this.machine.doesSupportStackSize();
    }

    @Override
    public void updateJEI() {
        this.machine.mainBranch.updateJEI();
    }

    @Override
    public void onRecieveFrom(Side side) {
        this.machine.mainBranch.onRecieveFrom(side);
    }

    @Override
    public void loadExtra(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("added", 10);
        this.recipes = new ArrayList();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            AddRecipeSegment recipe = new AddRecipeSegment("", this.machine, null);
            recipe.load(list.func_150305_b(i));
            if (recipe.value == null) continue;
            this.recipes.add(recipe);
        }
    }

    @Override
    public void saveExtra(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.recipes.size(); ++i) {
            NBTTagCompound recipeNBT = new NBTTagCompound();
            this.recipes.get(i).save(recipeNBT);
            list.func_74742_a((NBTBase)recipeNBT);
        }
        nbt.func_74782_a("added", (NBTBase)list);
    }

    @Override
    public void onUpdateSendToClient(EntityPlayer player) {
        this.machine.mainBranch.onUpdateSendToClient(player);
    }
}

