/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.api;

import com.creativemd.creativecore.common.gui.ContainerControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ConfigSegment
extends ConfigElement<ConfigSegment> {
    public int offsetX;
    public int offsetY;
    private ArrayList<ContainerControl> containerControls;
    @SideOnly(value=Side.CLIENT)
    private ArrayList<GuiControl> guiControls;
    public int lastX;
    public int lastY;

    public ConfigSegment(String title) {
        super(title);
    }

    public ConfigSegment setOffset(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
        return this;
    }

    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("childs_" + this.getKey())) {
            ConfigSegment.loadElements(this.childs, nbt.func_74775_l("childs_" + this.getKey()));
        } else {
            ConfigSegment.loadElements(this.childs, new NBTTagCompound());
        }
        this.loadExtra(nbt);
    }

    public abstract void loadExtra(NBTTagCompound var1);

    public abstract void saveExtra(NBTTagCompound var1);

    public void save(NBTTagCompound nbt) {
        if (!this.childs.isEmpty()) {
            NBTTagCompound childData = ConfigSegment.saveElements(this.childs, new NBTTagCompound());
            if (!childData.func_82582_d()) {
                nbt.func_74782_a("childs_" + this.getKey(), (NBTBase)childData);
            }
        } else if (nbt.func_74764_b("childs_" + this.getKey())) {
            nbt.func_82580_o("childs_" + this.getKey());
        }
        this.saveExtra(nbt);
    }

    public ArrayList<ContainerControl> getContainerControls() {
        return this.containerControls;
    }

    public void setContainerControls(ArrayList<ContainerControl> controls) {
        this.containerControls = controls;
    }

    public ContainerControl getContainerControl(String id) {
        ArrayList<ContainerControl> controls = this.getContainerControls();
        for (int i = 0; i < controls.size(); ++i) {
            if (!controls.get(i).is(new String[]{id})) continue;
            return controls.get(i);
        }
        return null;
    }

    public ArrayList<ContainerControl> createContainerControls(SubContainer container, int x, int y, int maxWidth) {
        ArrayList<ContainerControl> controls = new ArrayList<ContainerControl>();
        for (Map.Entry type : this.childs.entrySet()) {
            ArrayList<ContainerControl> subControls = ((ConfigSegment)type.getValue()).createContainerControls(container, x + ((ConfigSegment)type.getValue()).offsetX, y + ((ConfigSegment)type.getValue()).offsetY, maxWidth);
            ((ConfigSegment)type.getValue()).containerControls = subControls;
            controls.addAll(subControls);
        }
        return controls;
    }

    @SideOnly(value=Side.CLIENT)
    public ArrayList<GuiControl> createGuiControls(SubGui gui, int x, int y, int maxWidth) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        for (Map.Entry type : this.childs.entrySet()) {
            ArrayList<GuiControl> subControls = ((ConfigSegment)type.getValue()).createGuiControls(gui, x + ((ConfigSegment)type.getValue()).offsetX, y + ((ConfigSegment)type.getValue()).offsetY, maxWidth);
            ((ConfigSegment)type.getValue()).guiControls = subControls;
            controls.addAll(subControls);
        }
        return controls;
    }

    @SideOnly(value=Side.CLIENT)
    public ArrayList<GuiControl> getGuiControls() {
        return this.guiControls;
    }

    @SideOnly(value=Side.CLIENT)
    public void setGuiControls(ArrayList<GuiControl> controls) {
        this.guiControls = controls;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiControl getGuiControl(String id) {
        ArrayList<GuiControl> controls = this.getGuiControls();
        if (controls == null) {
            return null;
        }
        for (int i = 0; i < controls.size(); ++i) {
            if (!controls.get(i).is(new String[]{id})) continue;
            return controls.get(i);
        }
        return null;
    }

    public void onSegmentLoaded(int x, int y, int maxWidth) {
        this.lastX = x;
        this.lastY = y;
    }

    @SideOnly(value=Side.CLIENT)
    public int getHeight() {
        int maxHeight = 0;
        for (int i = 0; i < this.guiControls.size(); ++i) {
            maxHeight = Math.max(maxHeight, this.guiControls.get((int)i).height + this.guiControls.get((int)i).posY - this.lastY);
        }
        return maxHeight;
    }

    public ArrayList<ConfigSegment> getAllSegments() {
        ArrayList<ConfigSegment> segments = new ArrayList<ConfigSegment>();
        segments.add(this);
        for (ConfigSegment type : this.childs.values()) {
            segments.addAll(type.getAllSegments());
        }
        return segments;
    }

    public static void loadElements(HashMap<String, ConfigSegment> segments, NBTTagCompound nbt) {
        for (Map.Entry<String, ConfigSegment> type : segments.entrySet()) {
            type.getValue().load(nbt);
        }
    }

    public static NBTTagCompound saveElements(HashMap<String, ConfigSegment> segments, NBTTagCompound nbt) {
        for (Map.Entry<String, ConfigSegment> type : segments.entrySet()) {
            type.getValue().save(nbt);
        }
        return nbt;
    }

    protected abstract boolean contains(String var1);

    public boolean canBeFound(String search) {
        if (this.contains(search)) {
            return true;
        }
        for (ConfigSegment type : this.childs.values()) {
            if (!type.canBeFound(search)) continue;
            return true;
        }
        return false;
    }

    public void saveFromControls() {
        for (ConfigSegment type : this.childs.values()) {
            type.saveFromControls();
        }
    }

    public ConfigBranch getParentBranch() {
        if (this instanceof ConfigBranch) {
            return (ConfigBranch)this;
        }
        if (this.parent instanceof ConfigSegment) {
            return ((ConfigSegment)this.parent).getParentBranch();
        }
        return null;
    }
}

