/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.api;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class ConfigElement<T extends ConfigElement> {
    public String title;
    public ConfigElement parent;
    String key;
    protected LinkedHashMap<String, T> childs = new LinkedHashMap();

    public ConfigElement(String title) {
        this.title = title;
        this.key = title;
    }

    public T registerElement(String key, T element) {
        int index = 1;
        String tempKey = key;
        while (this.childs.containsKey(tempKey)) {
            tempKey = key + ++index;
        }
        this.childs.put(tempKey, element);
        ((ConfigElement)element).parent = this;
        ((ConfigElement)element).key = tempKey;
        return element;
    }

    public void initDefault() {
        Iterator<T> iterator = this.childs.values().iterator();
        while (iterator.hasNext()) {
            ((ConfigElement)iterator.next()).initDefault();
        }
    }

    public void initCore() {
        Iterator<T> iterator = this.childs.values().iterator();
        while (iterator.hasNext()) {
            ((ConfigElement)iterator.next()).initCore();
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getPath() {
        if (this.parent == null) {
            return this.title;
        }
        return this.parent.getPath() + "." + this.key;
    }

    public Collection<T> getChilds() {
        return this.childs.values();
    }

    public Set<String> getChildKeys() {
        return this.childs.keySet();
    }

    public T getChildByKey(String key) {
        return (T)((ConfigElement)this.childs.get(key));
    }

    public void clearChilds() {
        this.childs.clear();
    }
}

