/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm;

import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigSegment;
import com.creativemd.igcm.api.ConfigTab;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;

public class IGCMConfig {
    public static Configuration coreConfig;
    public static File currentFile;
    public static File ModConfigurationDirectory;
    public static String profileName;
    public static ArrayList<String> profiles;

    public static void initConfig(FMLPreInitializationEvent event) {
        coreConfig = new Configuration(event.getSuggestedConfigurationFile());
        coreConfig.load();
        String[] profile = coreConfig.get("General", "profiles", new String[0]).getStringList();
        profileName = coreConfig.get("General", "profileName", "new1").getString();
        if (profileName.equals("")) {
            profileName = "new1";
        }
        if (!(profiles = new ArrayList<String>(Arrays.asList(profile))).contains(profileName)) {
            profiles.add(profileName);
        }
        coreConfig.save();
        ModConfigurationDirectory = event.getModConfigurationDirectory();
    }

    public static void loadConfig() {
        currentFile = new File(ModConfigurationDirectory, "IGCM" + File.separator + profileName + ".nbt");
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74797_a((File)currentFile);
            if (nbt == null) {
                ConfigTab.root.initDefault();
            } else {
                ConfigTab.root.load(nbt);
            }
            ArrayList<ConfigSegment> allSegments = ConfigTab.root.getAllSegments();
            for (int i = 0; i < allSegments.size(); ++i) {
                if (!(allSegments.get(i) instanceof ConfigBranch)) continue;
                ConfigBranch branch = (ConfigBranch)allSegments.get(i);
                branch.onRecieveFromPre(Side.SERVER);
                branch.onRecieveFrom(Side.SERVER);
                branch.onRecieveFromPost(Side.SERVER);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveConfig() {
        NBTTagCompound nbt = new NBTTagCompound();
        ConfigTab.root.save(nbt);
        try {
            currentFile.getParentFile().mkdirs();
            CompressedStreamTools.func_74795_b((NBTTagCompound)nbt, (File)currentFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveProfiles() {
        coreConfig.load();
        coreConfig.get("General", "profileName", "new1").set(profileName);
        coreConfig.get("General", "profiles", new String[0]).set(profiles.toArray(new String[0]));
        coreConfig.save();
    }
}

