/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm;

import com.creativemd.creativecore.common.gui.opener.CustomGuiHandler;
import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.igcm.IGCMConfig;
import com.creativemd.igcm.IGCMGuiManager;
import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigElement;
import com.creativemd.igcm.api.ConfigTab;
import com.creativemd.igcm.block.BlockAdvancedWorkbench;
import com.creativemd.igcm.client.IGCMClient;
import com.creativemd.igcm.command.CommandGUI;
import com.creativemd.igcm.command.CommandSET;
import com.creativemd.igcm.event.ConfigEventHandler;
import com.creativemd.igcm.machines.AdvancedWorkbench;
import com.creativemd.igcm.machines.BrewingStandMachine;
import com.creativemd.igcm.machines.FurnaceMachine;
import com.creativemd.igcm.machines.WorkbenchMachine;
import com.creativemd.igcm.packets.BranchInformationPacket;
import com.creativemd.igcm.packets.CraftResultPacket;
import com.creativemd.igcm.packets.OpenGUIPacket;
import com.creativemd.igcm.packets.RequestInformationPacket;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="igcm", version="1.2.2", name="InGameConfigManager", acceptedMinecraftVersions="", dependencies="required-before:creativecore")
public class IGCM {
    public static Logger logger = LogManager.getLogger((String)"igcm");
    public static final String modid = "igcm";
    public static final String version = "1.2.2";
    public static ConfigEventHandler eventHandler = new ConfigEventHandler();
    public static boolean overrideWorkbench = false;
    public static Block advancedWorkbenchBlock = null;
    public static Item advancedWorkbenchItem = null;
    public static boolean enableWorkbench;
    public static boolean enableFurnace;
    public static boolean enableBrewing;
    public static boolean enableSwitchButton;
    public static final String guiID = "IGCM";
    public static WorkbenchMachine workbench;
    public static FurnaceMachine furnace;
    public static AdvancedWorkbench advancedWorkbench;
    public static BrewingStandMachine brewingStand;
    public static CommandBase gui;
    public static CommandBase set;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        enableWorkbench = config.getBoolean("enableWorkbench", "Module", true, "If false you will not be able to modify crafting recipes. Needs to be equal on client & server (otherwise it will crash)");
        enableFurnace = config.getBoolean("enableFurnace", "Module", true, "If false you will not be able to modify furnace recipes. Needs to be equal on client & server (otherwise it will crash)");
        enableBrewing = config.getBoolean("enableBrewing", "Module", true, "If false you will not be able to modify brewing recipes. Needs to be equal on client & server (otherwise it will crash)");
        enableSwitchButton = config.getBoolean("enableSwitchButton", "Module", true, "Whether a switch button in the workbench should be displayed or not");
        config.save();
        event.getModMetadata().version = version;
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        CreativeCorePacket.registerPacket(BranchInformationPacket.class, (String)"IGCMBranch");
        CreativeCorePacket.registerPacket(RequestInformationPacket.class, (String)"IGCMRequest");
        CreativeCorePacket.registerPacket(CraftResultPacket.class, (String)"IGCMCraftResult");
        CreativeCorePacket.registerPacket(OpenGUIPacket.class, (String)"IGCMGUI");
        IGCMConfig.initConfig(event);
        MinecraftForge.EVENT_BUS.register(IGCM.class);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        advancedWorkbenchBlock = ((Block)new BlockAdvancedWorkbench().func_149663_c("advancedWorkbench").setRegistryName(modid, "advancedworkbench")).func_149647_a(CreativeTabs.field_78031_c);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{advancedWorkbenchBlock});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        advancedWorkbenchItem = ((Item)new ItemBlock(advancedWorkbenchBlock).setRegistryName(advancedWorkbenchBlock.getRegistryName())).func_77637_a(CreativeTabs.field_78031_c);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{advancedWorkbenchItem});
        if (FMLCommonHandler.instance().getSide().isClient()) {
            IGCM.initClientPre();
        }
    }

    @Mod.EventHandler
    public static void Init(FMLInitializationEvent event) {
        GuiHandler.registerGuiHandler((String)guiID, (CustomGuiHandler)new IGCMGuiManager());
        if (FMLCommonHandler.instance().getSide().isClient()) {
            IGCM.initClient();
        }
        if (enableWorkbench) {
            workbench = new WorkbenchMachine("workbench", "Crafting Table", new ItemStack(Blocks.field_150462_ai));
        }
        if (enableFurnace) {
            furnace = new FurnaceMachine("furnace", "Furnace", new ItemStack(Blocks.field_150460_al));
        }
        advancedWorkbench = new AdvancedWorkbench("advWorkbench", "Advanced Workbench", new ItemStack(advancedWorkbenchBlock));
        if (enableBrewing) {
            brewingStand = new BrewingStandMachine("brewing", "Brewing Stand", new ItemStack(Items.field_151067_bt));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClientPre() {
        IGCMClient.initClientPre();
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        IGCMClient.initClient();
    }

    @Mod.EventHandler
    public static void postLoading(FMLLoadCompleteEvent event) {
        ConfigTab.root.initCore();
    }

    @Mod.EventHandler
    public static void serverStarting(FMLServerStartingEvent event) {
        gui = new CommandGUI();
        set = new CommandSET();
        event.registerServerCommand((ICommand)gui);
        event.registerServerCommand((ICommand)set);
        IGCMConfig.loadConfig();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean needsSynchronization() {
        return !Minecraft.func_71410_x().func_71356_B();
    }

    public static void sendAllUpdatePackets(EntityPlayer player) {
        ArrayList elements = new ArrayList(ConfigTab.root.getChilds());
        while (elements.size() > 0) {
            if (elements.get(0) instanceof ConfigBranch) {
                IGCM.sendUpdatePacket((ConfigBranch)elements.get(0), player);
            } else {
                elements.addAll(((ConfigElement)elements.get(0)).getChilds());
            }
            elements.remove(0);
        }
    }

    public static void sendUpdatePacket(ConfigBranch branch, EntityPlayer player) {
        if (!branch.requiresSynchronization()) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            PacketHandler.sendPacketToServer((CreativeCorePacket)new BranchInformationPacket(branch));
        } else {
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new BranchInformationPacket(branch), (EntityPlayerMP)((EntityPlayerMP)player));
        }
    }

    public static void sendAllUpdatePackets() {
        ArrayList elements = new ArrayList(ConfigTab.root.getChilds());
        while (elements.size() > 0) {
            if (elements.get(0) instanceof ConfigBranch) {
                IGCM.sendUpdatePacket((ConfigBranch)elements.get(0));
            } else {
                elements.addAll(((ConfigElement)elements.get(0)).getChilds());
            }
            elements.remove(0);
        }
    }

    public static void sendUpdatePacket(ConfigBranch branch) {
        if (!branch.requiresSynchronization()) {
            return;
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            PacketHandler.sendPacketToServer((CreativeCorePacket)new BranchInformationPacket(branch));
        } else {
            PacketHandler.sendPacketToAllPlayers((CreativeCorePacket)new BranchInformationPacket(branch));
        }
    }
}

