/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.parsers.machine;

import cofh.thermalexpansion.util.managers.machine.ChargerManager;
import cofh.thermalexpansion.util.parsers.BaseParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class ChargerParser
extends BaseParser {
    int defaultEnergy = 8000;
    Set<ItemStack> removeQueue = new ObjectOpenHashSet();

    @Override
    public void parseArray(JsonArray contentArray) {
        for (JsonElement recipe : contentArray) {
            JsonObject content = recipe.getAsJsonObject();
            if (content.has("//")) continue;
            int energy = this.defaultEnergy;
            ItemStack input = ChargerParser.parseItemStack(content.get("input"));
            if (content.has("remove") && content.get("remove").getAsBoolean()) {
                this.removeQueue.add(input);
                continue;
            }
            ItemStack output = ChargerParser.parseItemStack(content.get("output"));
            if (content.has("energy")) {
                energy = content.get("energy").getAsInt();
            } else if (content.has("energy_mod")) {
                energy = content.get("energy_mod").getAsInt() * this.defaultEnergy / 100;
            }
            if (ChargerManager.addRecipe(energy, input, output) != null) {
                ++this.parseCount;
                continue;
            }
            ++this.errorCount;
        }
    }

    @Override
    public void postProcess() {
        for (ItemStack stack : this.removeQueue) {
            ChargerManager.removeRecipe(stack);
        }
    }
}

