/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import cofh.api.item.IUpgradeItem;
import cofh.api.tileentity.ITileInfo;
import cofh.core.block.TileAugmentableSecure;
import cofh.core.fluid.FluidTankCore;
import cofh.core.gui.container.ContainerTileAugmentable;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.storage.BlockTank;
import cofh.thermalexpansion.gui.client.storage.GuiTank;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileTank
extends TileAugmentableSecure
implements ITickable,
ITileInfo {
    public static final int CAPACITY_BASE = 20000;
    public static final int[] CAPACITY = new int[]{1, 4, 9, 16, 25};
    public static final int RENDER_LEVELS = 100;
    private int compareTracker;
    private int lastDisplayLevel;
    public short enchantHolding;
    boolean lock = false;
    boolean renderFlag = true;
    boolean cached = false;
    boolean[] adjacentTanks = new boolean[2];
    private FluidTankCore tank = new FluidTankCore(TileTank.getMaxCapacity(0, 0));

    public static void initialize() {
        GameRegistry.registerTileEntity(TileTank.class, (String)"thermalexpansion:storage_tank");
        TileTank.config();
    }

    public static void config() {
        String category = "Storage.Tank";
        String comment = "If TRUE, Tanks are enabled.";
        BlockTank.enable = ThermalExpansion.CONFIG.get(category, "Enable", BlockTank.enable, comment);
        comment = "If TRUE, Tanks may be turned into Creative versions using a Creative Conversion Kit.";
        BlockTank.enableCreative = ThermalExpansion.CONFIG.get(category, "Creative", BlockTank.enableCreative, comment);
        comment = "If TRUE, Tanks are securable.";
        BlockTank.enableSecurity = ThermalExpansion.CONFIG.get(category, "Securable", BlockTank.enableSecurity, comment);
        comment = "If TRUE, 'Classic' Crafting is enabled - Non-Creative Upgrade Kits WILL NOT WORK in a Crafting Grid.";
        BlockTank.enableClassicRecipes = ThermalExpansion.CONFIG.get(category, "ClassicCrafting", BlockTank.enableClassicRecipes, comment);
        comment = "If TRUE, Tanks can be upgraded in a Crafting Grid using Kits. If Classic Crafting is enabled, only the Creative Conversion Kit may be used in this fashion.";
        BlockTank.enableUpgradeKitCrafting = ThermalExpansion.CONFIG.get(category, "UpgradeKitCrafting", BlockTank.enableUpgradeKitCrafting, comment);
        int capacity = 20000;
        comment = "Adjust this value to change the amount of Fluid (in mB) stored by a Basic Tank. This base value will scale with block level.";
        capacity = ThermalExpansion.CONFIG.getConfiguration().getInt("BaseCapacity", category, capacity, 2000, 1000000, comment);
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i++;
            CAPACITY[n] = CAPACITY[n] * capacity;
        }
    }

    protected Object getMod() {
        return ThermalExpansion.instance;
    }

    protected String getModVersion() {
        return "5.5.4";
    }

    protected String getTileName() {
        return "tile.thermalexpansion.storage.tank.name";
    }

    public void blockPlaced() {
        super.blockPlaced();
        this.sendTilePacket(Side.CLIENT);
    }

    public int getComparatorInputOverride() {
        return this.compareTracker;
    }

    public boolean enableSecurity() {
        return BlockTank.enableSecurity;
    }

    public boolean onWrench(EntityPlayer player, EnumFacing side) {
        this.enableAutoOutput = !this.enableAutoOutput;
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public int getLightValue() {
        return this.tank.getFluid() == null ? 0 : this.tank.getFluid().getFluid().getLuminosity();
    }

    public void func_145843_s() {
        this.cached = false;
        super.func_145843_s();
    }

    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentHandlers(true);
    }

    public void onNeighborTileChange(BlockPos pos) {
        super.onNeighborTileChange(pos);
        this.updateAdjacentHandlers(true);
    }

    public void func_73660_a() {
        if (this.redstoneControlOrDisable()) {
            this.transferFluid();
        }
        if (this.timeCheck()) {
            int curScale;
            int n = curScale = this.getTankFluidAmount() > 0 ? 1 + this.getScaledFluidStored(14) : 0;
            if (curScale != this.compareTracker) {
                this.compareTracker = curScale;
                this.callNeighborTileChange();
            }
            if (!this.cached) {
                this.updateLighting();
                this.updateAdjacentHandlers(false);
                this.sendTilePacket(Side.CLIENT);
            }
        }
        if (this.renderFlag && this.timeCheckEighth()) {
            this.updateRender();
        }
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public boolean canUpgrade(ItemStack upgrade) {
        if (!AugmentHelper.isUpgradeItem((ItemStack)upgrade)) {
            return false;
        }
        IUpgradeItem.UpgradeType uType = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeType(upgrade);
        byte uLevel = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeLevel(upgrade);
        switch (uType) {
            case INCREMENTAL: {
                if (uLevel != this.level + 1) break;
                return !BlockTank.enableClassicRecipes;
            }
            case FULL: {
                if (uLevel <= this.level) break;
                return !BlockTank.enableClassicRecipes;
            }
            case CREATIVE: {
                return !this.isCreative && BlockTank.enableCreative;
            }
        }
        return false;
    }

    protected boolean setLevel(int level) {
        if (super.setLevel(level)) {
            this.tank.setCapacity(TileTank.getMaxCapacity(level, this.enchantHolding));
            if (this.isCreative && this.getTankFluidAmount() > 0) {
                this.tank.getFluid().amount = this.tank.getCapacity();
            }
            return true;
        }
        return false;
    }

    protected int getNumAugmentSlots(int level) {
        return 0;
    }

    public static int getMaxCapacity(int level, int enchant) {
        return (int)Math.max((double)CAPACITY[MathHelper.clamp((int)level, (int)0, (int)4)] + (double)CAPACITY[MathHelper.clamp((int)level, (int)0, (int)4)] * (double)enchant / 2.0, 0.0);
    }

    protected void transferFluid() {
        if (!this.getTransferOut() || this.tank.getFluidAmount() <= 0) {
            return;
        }
        int toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.DOWN, (FluidStack)new FluidStack(this.tank.getFluid(), Math.min(this.getFluidTransfer(this.level), this.tank.getFluidAmount())), (boolean)true);
        if (toDrain > 0) {
            this.renderFlag = !this.isCreative;
            this.tank.drain(toDrain, !this.isCreative);
        }
    }

    protected void updateAdjacentHandlers(boolean packet) {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        boolean curAutoOutput = this.enableAutoOutput;
        this.adjacentTanks[0] = BlockHelper.getAdjacentTileEntity((TileEntity)this, (EnumFacing)EnumFacing.DOWN) instanceof TileTank;
        this.adjacentTanks[1] = BlockHelper.getAdjacentTileEntity((TileEntity)this, (EnumFacing)EnumFacing.UP) instanceof TileTank;
        if (!this.lock && this.getTankFluid() == null) {
            this.enableAutoOutput |= this.adjacentTanks[0];
        }
        if (packet && curAutoOutput != this.enableAutoOutput) {
            this.sendTilePacket(Side.CLIENT);
        }
        this.cached = true;
    }

    public void setLocked(boolean lock) {
        if (this.getTankFluid() == null) {
            lock = false;
        }
        this.lock = lock;
        this.tank.setLocked(lock);
        this.sendTilePacket(Side.CLIENT);
    }

    public boolean isLocked() {
        return this.lock;
    }

    public int getScaledFluidStored(int scale) {
        return this.tank.getFluid() == null ? 0 : this.tank.getFluid().amount * scale / this.tank.getCapacity();
    }

    public int getTankFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public void updateRender() {
        this.renderFlag = false;
        boolean sendUpdate = false;
        if (this.tank.getFluidAmount() > 0) {
            int curDisplayLevel = (int)Math.max(1.0f, (float)this.tank.getFluidAmount() / (float)TileTank.getMaxCapacity(this.level, this.enchantHolding) * 99.0f);
            if (this.lastDisplayLevel != curDisplayLevel) {
                this.lastDisplayLevel = curDisplayLevel;
                sendUpdate = true;
            }
        } else {
            this.lastDisplayLevel = 0;
            sendUpdate = true;
        }
        if (sendUpdate) {
            this.updateLighting();
            this.sendTilePacket(Side.CLIENT);
        }
    }

    public Object getConfigGuiClient(InventoryPlayer inventory) {
        return new GuiTank(inventory, (TileEntity)this);
    }

    public Object getConfigGuiServer(InventoryPlayer inventory) {
        return new ContainerTileAugmentable(inventory, (TileEntity)this);
    }

    public boolean hasConfigGui() {
        return true;
    }

    public void toggleLock() {
        this.lock = !this.lock;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.enchantHolding = nbt.func_74765_d("EncHolding");
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt);
        this.lock = this.tank.isLocked();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74777_a("EncHolding", this.enchantHolding);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public PacketBase getModePacket() {
        PacketBase payload = super.getModePacket();
        payload.addBool(this.lock);
        return payload;
    }

    protected void handleModePacket(PacketBase payload) {
        super.handleModePacket(payload);
        this.setLocked(payload.getBool());
    }

    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.lock);
        payload.addInt(this.tank.getCapacity());
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addShort(this.enchantHolding);
        payload.addBool(this.lock);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.lock = payload.getBool();
        this.tank.setCapacity(payload.getInt());
        this.tank.setFluid(payload.getFluidStack());
    }

    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.enchantHolding = payload.getShort();
        this.lock = payload.getBool();
        this.tank.setFluid(payload.getFluidStack());
        this.callBlockUpdate();
    }

    public void getTileInfo(List<ITextComponent> info, EnumFacing side, EntityPlayer player, boolean debug) {
        if (debug) {
            return;
        }
        if (this.tank.getFluid() != null) {
            info.add(new TextComponentTranslation("info.cofh.fluid", new Object[0]).func_150258_a(": " + StringHelper.getFluidName((FluidStack)this.tank.getFluid())));
            info.add(new TextComponentTranslation("info.cofh.amount", new Object[0]).func_150258_a(": " + StringHelper.formatNumber((long)this.tank.getFluidAmount()) + "/" + StringHelper.formatNumber((long)this.tank.getCapacity()) + " mB"));
            info.add((ITextComponent)new TextComponentTranslation(this.lock ? "info.cofh.locked" : "info.cofh.unlocked", new Object[0]));
        } else {
            info.add(new TextComponentTranslation("info.cofh.fluid", new Object[0]).func_150258_a(": ").func_150257_a((ITextComponent)new TextComponentTranslation("info.cofh.empty", new Object[0])));
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileTank.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (TileTank.this.isCreative) {
                        if (resource == null || from == EnumFacing.DOWN && !TileTank.this.adjacentTanks[0] && TileTank.this.getTransferOut()) {
                            return 0;
                        }
                        if (resource.isFluidEqual(TileTank.this.tank.getFluid())) {
                            return 0;
                        }
                        TileTank.this.tank.setFluid(new FluidStack(resource, TileTank.getMaxCapacity(TileTank.this.level, TileTank.this.enchantHolding)));
                        TileTank.this.sendTilePacket(Side.CLIENT);
                        TileTank.this.updateRender();
                        return 0;
                    }
                    if (resource == null || from == EnumFacing.DOWN && !TileTank.this.adjacentTanks[0] && TileTank.this.getTransferOut()) {
                        return 0;
                    }
                    TileTank.this.renderFlag = true;
                    int amount = TileTank.this.tank.fill(resource, doFill);
                    if (TileTank.this.adjacentTanks[1] && from != EnumFacing.UP && amount != resource.amount) {
                        FluidStack remaining = resource.copy();
                        remaining.amount -= amount;
                        return amount + FluidHelper.insertFluidIntoAdjacentFluidHandler((World)TileTank.this.field_145850_b, (BlockPos)TileTank.this.field_174879_c, (EnumFacing)EnumFacing.UP, (FluidStack)remaining, (boolean)doFill);
                    }
                    return amount;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (TileTank.this.isCreative) {
                        if (!FluidHelper.isFluidEqual((FluidStack)resource, (FluidStack)TileTank.this.tank.getFluid())) {
                            return null;
                        }
                        return resource.copy();
                    }
                    FluidStack retStack = TileTank.this.tank.drain(resource, doDrain);
                    if (retStack != null) {
                        TileTank.this.renderFlag = true;
                    }
                    return retStack;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (TileTank.this.isCreative) {
                        if (TileTank.this.tank.getFluid() == null) {
                            return null;
                        }
                        return new FluidStack(TileTank.this.tank.getFluid(), maxDrain);
                    }
                    FluidStack retStack = TileTank.this.tank.drain(maxDrain, doDrain);
                    if (retStack != null) {
                        TileTank.this.renderFlag = true;
                    }
                    return retStack;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

