/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio;

import com.mia.craftstudio.CSExceptions;
import com.mia.craftstudio.libgdx.Quaternion;
import com.mia.craftstudio.libgdx.Vector3;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CSModelAnim {
    private final byte asset_type;
    private final short format_version;
    private final short animation_duration;
    private final boolean hold_last_keyframe;
    private final short node_count;
    private final HashMap<String, ModelNodeAnimation> nodes = new HashMap();
    private HashSet<String> affectedNodes = null;

    public CSModelAnim(ByteBuffer buffer) throws CSExceptions.TypeMismatchException, CSExceptions.UnsupportedVersionException {
        this.asset_type = buffer.get();
        if (this.asset_type != 6) {
            throw new CSExceptions.TypeMismatchException((byte)6, this.asset_type);
        }
        this.format_version = buffer.getShort();
        if (this.format_version != 3) {
            throw new CSExceptions.UnsupportedVersionException(this.format_version);
        }
        this.animation_duration = buffer.getShort();
        this.hold_last_keyframe = buffer.get() != 0;
        this.node_count = buffer.getShort();
        for (int i = 0; i < this.node_count; ++i) {
            ModelNodeAnimation node = new ModelNodeAnimation(buffer);
            this.nodes.put(node.getName(), node);
        }
    }

    public short getNode_count() {
        return this.node_count;
    }

    public HashMap<String, ModelNodeAnimation> getNodes() {
        return this.nodes;
    }

    public ModelNodeAnimation getNodeAffectingModel(String modelName) {
        return this.nodes.get(modelName);
    }

    public Set<String> getModelNamesAffected() {
        return this.nodes.keySet();
    }

    public short getAnimationDuration() {
        return this.animation_duration;
    }

    public boolean isHoldingLastKeyframe() {
        return this.hold_last_keyframe;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(String.format("-=-=-=-=-\nCSModelAnimation: Duration[%d] HoldLastKeyframe[%b] NodeCount[%d] :\n", this.animation_duration, this.hold_last_keyframe, this.node_count));
        for (Map.Entry<String, ModelNodeAnimation> entry : this.nodes.entrySet()) {
            ret.append(entry.getValue() + "\n");
        }
        return ret.toString();
    }

    public static enum KeyFrameType {
        Position,
        Orientation,
        BlockSize,
        PivotOffset,
        Scale;

    }

    public static class ModelNodeKeyFrame {
        private final KeyFrameType type;
        private final short key_time_index;
        private final byte interpolation_mode;
        private final Vector3 vector;
        private final Quaternion quaternion;
        public final FloatBuffer quatbuffer;

        public ModelNodeKeyFrame(KeyFrameType frameType, ByteBuffer buffer) {
            this.type = frameType;
            this.key_time_index = buffer.getShort();
            this.interpolation_mode = buffer.get();
            switch (frameType) {
                case Orientation: {
                    this.vector = null;
                    this.quaternion = new Quaternion(buffer);
                    float[] quatmatrix = new float[16];
                    this.quaternion.y *= -1.0f;
                    this.quaternion.z *= -1.0f;
                    this.quaternion.toMatrix(quatmatrix);
                    this.quatbuffer = FloatBuffer.allocate(16);
                    this.quatbuffer.put(quatmatrix);
                    this.quatbuffer.flip();
                    break;
                }
                case BlockSize: {
                    this.vector = new Vector3(buffer.getInt(), buffer.getInt(), buffer.getInt());
                    this.quaternion = null;
                    this.quatbuffer = null;
                    break;
                }
                default: {
                    this.vector = new Vector3(buffer);
                    this.quaternion = null;
                    this.quatbuffer = null;
                }
            }
        }

        public byte getInterpolationMode() {
            return this.interpolation_mode;
        }

        public short getKeyTimeIndex() {
            return this.key_time_index;
        }

        public KeyFrameType getType() {
            return this.type;
        }

        public Vector3 getVector() {
            return this.vector;
        }

        public Quaternion getQuaternion() {
            return this.quaternion.cpy();
        }

        public String toString() {
            return String.format("Keyframe: Type[%s] Index[%s] Mode[%s] Vector[%s] Quaternion[%s]", this.type.name(), this.key_time_index, this.interpolation_mode, this.vector, this.quaternion);
        }
    }

    public static class ModelNodeAnimation {
        private final String name;
        private final short position_keyframe_count;
        private final ArrayList<ModelNodeKeyFrame> position_keyframes = new ArrayList();
        private final short orientation_keyframe_count;
        private final ArrayList<ModelNodeKeyFrame> orientation_keyframes = new ArrayList();
        private final short block_size_keyframe_count;
        private final ArrayList<ModelNodeKeyFrame> block_size_keyframes = new ArrayList();
        private final short pivot_offset_keyframe_count;
        private final ArrayList<ModelNodeKeyFrame> pivot_offset_keyframes = new ArrayList();
        private final short scale_keyframe_count;
        private final ArrayList<ModelNodeKeyFrame> scale_keyframes = new ArrayList();

        public String getName() {
            return this.name;
        }

        public ArrayList<ModelNodeKeyFrame> getOrientationKeyframes() {
            return this.orientation_keyframes;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder(String.format("ModelNodeAnimation for ModelNode[%s]:\n", this.name));
            if (this.position_keyframe_count > 0) {
                ret.append(String.format("\tPosition Keyframe count: %s\n", this.position_keyframe_count));
                for (ModelNodeKeyFrame keyframe : this.position_keyframes) {
                    ret.append("\t\t" + keyframe + "\n");
                }
            }
            if (this.orientation_keyframe_count > 0) {
                ret.append(String.format("\tOrientation Keyframe count: %s\n", this.orientation_keyframe_count));
                for (ModelNodeKeyFrame keyframe : this.orientation_keyframes) {
                    ret.append("\t\t" + keyframe + "\n");
                }
            }
            if (this.block_size_keyframe_count > 0) {
                ret.append(String.format("\tBlock Size Keyframe count: %s\n", this.block_size_keyframe_count));
                for (ModelNodeKeyFrame keyframe : this.block_size_keyframes) {
                    ret.append("\t\t" + keyframe + "\n");
                }
            }
            if (this.pivot_offset_keyframe_count > 0) {
                ret.append(String.format("\tPivot Offset Keyframe count: %s\n", this.pivot_offset_keyframe_count));
                for (ModelNodeKeyFrame keyframe : this.pivot_offset_keyframes) {
                    ret.append("\t\t" + keyframe + "\n");
                }
            }
            if (this.scale_keyframe_count > 0) {
                ret.append(String.format("\tScale Keyframe count: %s\n", this.scale_keyframe_count));
                for (ModelNodeKeyFrame keyframe : this.scale_keyframes) {
                    ret.append("\t\t" + keyframe + "\n");
                }
            }
            return ret.toString();
        }

        public ModelNodeAnimation(ByteBuffer buffer) {
            int i;
            byte[] tmpName = new byte[buffer.get()];
            buffer.get(tmpName);
            this.name = new String(tmpName);
            this.position_keyframe_count = buffer.getShort();
            for (i = 0; i < this.position_keyframe_count; ++i) {
                this.position_keyframes.add(new ModelNodeKeyFrame(KeyFrameType.Position, buffer));
            }
            this.orientation_keyframe_count = buffer.getShort();
            for (i = 0; i < this.orientation_keyframe_count; ++i) {
                this.orientation_keyframes.add(new ModelNodeKeyFrame(KeyFrameType.Orientation, buffer));
            }
            this.block_size_keyframe_count = buffer.getShort();
            for (i = 0; i < this.block_size_keyframe_count; ++i) {
                this.block_size_keyframes.add(new ModelNodeKeyFrame(KeyFrameType.BlockSize, buffer));
            }
            this.pivot_offset_keyframe_count = buffer.getShort();
            for (i = 0; i < this.pivot_offset_keyframe_count; ++i) {
                this.pivot_offset_keyframes.add(new ModelNodeKeyFrame(KeyFrameType.PivotOffset, buffer));
            }
            this.scale_keyframe_count = buffer.getShort();
            for (i = 0; i < this.scale_keyframe_count; ++i) {
                this.scale_keyframes.add(new ModelNodeKeyFrame(KeyFrameType.Scale, buffer));
            }
        }
    }
}

