/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.potion.Potion;
import net.minecraft.util.WeightedRandom;
import org.apache.commons.lang3.tuple.Pair;
import shadows.plants2.util.ColorToPotionUtil;

public class ColorToPotionWeightedMap {
    final ImmutableMap<EnumDyeColor, List<WeightedPotion>> internal;
    private static List<Pair<EnumDyeColor, Potion>> defaultColors = ImmutableList.of((Object)Pair.of((Object)EnumDyeColor.WHITE, (Object)MobEffects.field_188423_x), (Object)Pair.of((Object)EnumDyeColor.ORANGE, (Object)MobEffects.field_76426_n), (Object)Pair.of((Object)EnumDyeColor.MAGENTA, (Object)MobEffects.field_76421_d), (Object)Pair.of((Object)EnumDyeColor.LIGHT_BLUE, (Object)MobEffects.field_76430_j), (Object)Pair.of((Object)EnumDyeColor.YELLOW, (Object)MobEffects.field_76431_k), (Object)Pair.of((Object)EnumDyeColor.LIME, (Object)MobEffects.field_76419_f), (Object)Pair.of((Object)EnumDyeColor.PINK, (Object)MobEffects.field_76428_l), (Object)Pair.of((Object)EnumDyeColor.GRAY, (Object)MobEffects.field_76424_c), (Object)Pair.of((Object)EnumDyeColor.SILVER, (Object)MobEffects.field_76429_m), (Object)Pair.of((Object)EnumDyeColor.CYAN, (Object)MobEffects.field_76420_g), (Object)Pair.of((Object)EnumDyeColor.PURPLE, (Object)MobEffects.field_76439_r), (Object)Pair.of((Object)EnumDyeColor.BLUE, (Object)MobEffects.field_76427_o), (Object[])new Pair[]{Pair.of((Object)EnumDyeColor.BROWN, (Object)MobEffects.field_76443_y), Pair.of((Object)EnumDyeColor.GREEN, (Object)MobEffects.field_188425_z), Pair.of((Object)EnumDyeColor.RED, (Object)MobEffects.field_76432_h), Pair.of((Object)EnumDyeColor.BLACK, (Object)MobEffects.field_76433_i)});

    public ColorToPotionWeightedMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Pair<EnumDyeColor, Potion> pair : defaultColors) {
            ArrayList<WeightedPotion> list = new ArrayList<WeightedPotion>();
            list.add(new WeightedPotion((Potion)pair.getRight(), 10));
            builder.put(pair.getKey(), list);
        }
        this.internal = Maps.immutableEnumMap((Map)builder.build());
    }

    public Potion getRandomPotion(EnumDyeColor color) {
        return ((WeightedPotion)WeightedRandom.func_76271_a((Random)ColorToPotionUtil.RAND, (List)((List)this.internal.get((Object)color)))).getPotion();
    }

    public List<WeightedPotion> getPotionList(EnumDyeColor color) {
        return (List)this.internal.get((Object)color);
    }

    public ImmutableSet<Map.Entry<EnumDyeColor, List<WeightedPotion>>> entrySet() {
        return this.internal.entrySet();
    }

    public static class WeightedPotion
    extends WeightedRandom.Item {
        final Potion potion;

        public WeightedPotion(Potion potion, int weight) {
            super(weight);
            this.potion = potion;
        }

        public Potion getPotion() {
            return this.potion;
        }
    }
}

