/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.gen;

import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.BlockRotationProcessor;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.common.BiomeDictionary;
import shadows.placebo.interfaces.ITreeEnum;
import shadows.plants2.data.PlantConfig;
import shadows.plants2.gen.EnumTreeGen;
import shadows.plants2.gen.TreeTemplate;

public class StructureGen
extends EnumTreeGen<ITreeEnum> {
    protected TreeTemplate structure = null;
    protected final ResourceLocation structurePath;
    protected BlockPos offset;
    protected BiomeDictionary.Type[] allowedBiomes;
    private final PlacementSettings settings = new PlacementSettings();

    public StructureGen(ResourceLocation structurePath, BlockPos offset, ITreeEnum assign, BiomeDictionary.Type ... allowedBiomes) {
        super(assign);
        this.structurePath = structurePath;
        this.offset = offset;
        this.allowedBiomes = allowedBiomes;
    }

    public StructureGen(BlockPos offset, ITreeEnum assign, BiomeDictionary.Type ... allowedBiomes) {
        this(new ResourceLocation("plants2", assign.func_176610_l() + "_tree"), offset, assign, allowedBiomes);
    }

    public StructureGen(BlockPos offset, String name, ITreeEnum assign, BiomeDictionary.Type ... allowedBiomes) {
        this(new ResourceLocation("plants2", name), offset, assign, allowedBiomes);
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (!world.field_72995_K) {
            if (this.structure == null) {
                this.structure = new TreeTemplate(((WorldServer)world).func_184163_y().func_189942_b(null, this.structurePath));
            }
            return this.structure.addBlocksToWorld(world, pos.func_177971_a((Vec3i)this.offset), (ITemplateProcessor)new BlockRotationProcessor(pos, this.settings), this.settings, 3, false);
        }
        return false;
    }

    @Override
    public boolean canGen(World world, BlockPos pos) {
        if (super.canGen(world, pos)) {
            Biome b = world.func_180494_b(pos);
            if (PlantConfig.COMPUTED_BIOME_BL.contains((Object)b)) {
                return false;
            }
            for (BiomeDictionary.Type t : this.allowedBiomes) {
                if (!BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)t)) continue;
                return true;
            }
            return this.allowedBiomes.length == 0;
        }
        return false;
    }
}

