/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.gen;

import java.util.Random;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeBeach;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import shadows.plants2.block.BlockCustomVine;
import shadows.plants2.data.PlantConfig;
import shadows.plants2.util.PlantUtil;

public class Decorator {
    public static final Biome FLOWER_FOREST = Biome.func_150568_d((int)132);

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void recieveGenEvent(DecorateBiomeEvent.Decorate event) {
        if (!PlantConfig.gen) {
            return;
        }
        if (PlantConfig.DIM_BL.contains((Object)event.getWorld().field_73011_w.getDimension())) {
            return;
        }
        if (PlantConfig.COMPUTED_BIOME_BL.contains((Object)event.getWorld().func_180494_b(event.getChunkPos().func_180331_a(0, 0, 0)))) {
            return;
        }
        Decorator.genFlowers(event);
        Decorator.genDesertFlowers(event);
        Decorator.flowerForestDeco(event);
        Decorator.genVines(event);
    }

    public static void genFlowers(DecorateBiomeEvent.Decorate event) {
        if (PlantConfig.flowerGen && !event.getWorld().field_72995_K && event.getType() == DecorateBiomeEvent.Decorate.EventType.FLOWERS) {
            BlockPos pos = event.getChunkPos().func_180331_a(8, 0, 8);
            for (int ih = PlantConfig.numTries; ih > 0; --ih) {
                IBlockState state;
                if (event.getRand().nextInt(PlantConfig.patchChance) != 0 || (state = PlantUtil.getFlowerState(event.getRand())) == null) continue;
                int chance = event.getRand().nextInt(100);
                if (chance > 10) {
                    PlantUtil.genFlowerPatch(event.getWorld(), pos, event.getRand(), state);
                    continue;
                }
                if (chance <= 10 && chance >= 0) {
                    PlantUtil.genSmallFlowerPatchNearby(event.getWorld(), pos, event.getRand(), state);
                    continue;
                }
                if (chance != 0) continue;
                PlantUtil.genMegaPatch(event.getWorld(), pos, event.getRand(), state);
            }
        }
    }

    public static void genDesertFlowers(DecorateBiomeEvent.Decorate event) {
        if (event.getWorld().func_180494_b(event.getChunkPos().func_180331_a(8, 0, 8)) instanceof BiomeBeach) {
            return;
        }
        if (PlantConfig.desertGen && !event.getWorld().field_72995_K && (event.getType() == DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH || event.getType() == DecorateBiomeEvent.Decorate.EventType.CACTUS)) {
            BlockPos pos = event.getChunkPos().func_180331_a(8, 0, 8);
            for (int ih = PlantConfig.numTries; ih > 0; --ih) {
                IBlockState state;
                if (event.getRand().nextInt(PlantConfig.patchChance * 4) != 0 || (state = PlantUtil.getDesertFlowerState(event.getRand())) == null) continue;
                int chance = event.getRand().nextInt(100);
                if (chance > 10) {
                    PlantUtil.genFlowerPatch(event.getWorld(), pos, event.getRand(), state);
                    continue;
                }
                if (chance <= 10 && chance >= 0) {
                    PlantUtil.genSmallFlowerPatchNearby(event.getWorld(), pos, event.getRand(), state);
                    continue;
                }
                if (chance != 0) continue;
                PlantUtil.genMegaPatch(event.getWorld(), pos, event.getRand(), state);
            }
        }
    }

    public static void flowerForestDeco(DecorateBiomeEvent.Decorate event) {
        if (PlantConfig.flowerGen && PlantConfig.literallyTakeoverFlowerForests && !event.getWorld().field_72995_K && event.getType() == DecorateBiomeEvent.Decorate.EventType.FLOWERS && event.getWorld().func_180494_b(event.getChunkPos().func_180331_a(0, 0, 0)) == FLOWER_FOREST) {
            for (int ih = 8; ih > 0; --ih) {
                IBlockState state = PlantUtil.getFlowerState(event.getRand());
                PlantUtil.genFlowerPatch(event.getWorld(), event.getChunkPos().func_180331_a(8, 0, 8), event.getRand(), state);
            }
        }
    }

    public static void genVines(DecorateBiomeEvent.Decorate event) {
        if (PlantConfig.vineGen && !event.getWorld().field_72995_K && event.getRand().nextInt(30) == 0 && event.getType() == DecorateBiomeEvent.Decorate.EventType.FLOWERS) {
            EnumFacing facing = EnumFacing.field_176754_o[event.getRand().nextInt(4)];
            World world = event.getWorld();
            BlockCustomVine vine = PlantUtil.getRandomVine(world.field_73012_v);
            BlockPos pos = world.func_175672_r(event.getChunkPos().func_180331_a(8, 0, 8).func_177982_a(MathHelper.func_76136_a((Random)event.getRand(), (int)-4, (int)4), 0, MathHelper.func_76136_a((Random)event.getRand(), (int)-4, (int)4)));
            if (!(world.func_180495_p(pos).func_177230_c() instanceof BlockGrass)) {
                return;
            }
            for (int i = 0; i < 3; ++i) {
                world.func_180501_a(pos.func_177981_b(i), Blocks.field_150341_Y.func_176223_P(), 2);
                if (!vine.func_176196_c(world, pos.func_177972_a(facing).func_177981_b(i))) continue;
                world.func_180501_a(pos.func_177972_a(facing).func_177981_b(i), vine.func_180642_a(world, pos.func_177972_a(facing).func_177981_b(i), facing, 0.0f, 0.0f, 0.0f, 0, null), 2);
            }
        }
    }
}

