/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.teleporter.SimpleDialerItemBlock;
import mcjty.rftools.blocks.teleporter.SimpleDialerTileEntity;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class SimpleDialerBlock
extends LogicSlabBlock<SimpleDialerTileEntity, EmptyContainer> {
    public SimpleDialerBlock() {
        super((ModBase)RFTools.instance, Material.field_151573_f, SimpleDialerTileEntity.class, EmptyContainer::new, SimpleDialerItemBlock::new, "simple_dialer", false);
    }

    public boolean hasRedstoneOutput() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            if (tagCompound.func_74764_b("transX")) {
                int transX = tagCompound.func_74762_e("transX");
                int transY = tagCompound.func_74762_e("transY");
                int transZ = tagCompound.func_74762_e("transZ");
                int dim = tagCompound.func_74762_e("transDim");
                list.add(TextFormatting.GREEN + "Transmitter at: " + transX + "," + transY + "," + transZ + " (dim " + dim + ")");
            }
            if (tagCompound.func_74764_b("receiver")) {
                int receiver = tagCompound.func_74762_e("receiver");
                list.add(TextFormatting.GREEN + "Receiver: " + receiver);
            }
            if (tagCompound.func_74767_n("once")) {
                list.add(TextFormatting.GREEN + "Dial Once mode enabled");
            }
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "When this block gets a redstone signal it");
            list.add(TextFormatting.WHITE + "dials or interrupts a transmitter.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof SimpleDialerTileEntity) {
            Integer receiver;
            SimpleDialerTileEntity simpleDialerTileEntity = (SimpleDialerTileEntity)te;
            GlobalCoordinate trans = simpleDialerTileEntity.getTransmitter();
            if (trans != null) {
                probeInfo.text(TextFormatting.GREEN + "Transmitter at: " + BlockPosTools.toString((BlockPos)trans.getCoordinate()) + " (dim " + trans.getDimension() + ")");
            }
            if ((receiver = simpleDialerTileEntity.getReceiver()) != null) {
                probeInfo.text(TextFormatting.GREEN + "Receiver: " + receiver);
            }
            if (simpleDialerTileEntity.isOnceMode()) {
                probeInfo.text(TextFormatting.GREEN + "Dial Once mode enabled");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tagCompound = accessor.getNBTData();
        if (tagCompound != null) {
            if (tagCompound.func_74764_b("transX")) {
                int transX = tagCompound.func_74762_e("transX");
                int transY = tagCompound.func_74762_e("transY");
                int transZ = tagCompound.func_74762_e("transZ");
                int dim = tagCompound.func_74762_e("transDim");
                currenttip.add(TextFormatting.GREEN + "Transmitter at: " + transX + "," + transY + "," + transZ + " (dim " + dim + ")");
            }
            if (tagCompound.func_74764_b("receiver")) {
                int receiver = tagCompound.func_74762_e("receiver");
                currenttip.add(TextFormatting.GREEN + "Receiver: " + receiver);
            }
            if (tagCompound.func_74767_n("once")) {
                currenttip.add(TextFormatting.GREEN + "Dial Once mode enabled");
            }
        }
        return currenttip;
    }

    protected boolean wrenchUse(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        if (!world.field_72995_K) {
            SimpleDialerTileEntity simpleDialerTileEntity = (SimpleDialerTileEntity)world.func_175625_s(pos);
            boolean onceMode = !simpleDialerTileEntity.isOnceMode();
            simpleDialerTileEntity.setOnceMode(onceMode);
            if (onceMode) {
                Logging.message((EntityPlayer)player, (String)"Enabled 'dial once' mode");
            } else {
                Logging.message((EntityPlayer)player, (String)"Disabled 'dial once' mode");
            }
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof SimpleDialerTileEntity) {
            SimpleDialerTileEntity simpleDialerTileEntity = (SimpleDialerTileEntity)te;
            simpleDialerTileEntity.update();
        }
    }

    public int getGuiID() {
        return -1;
    }
}

