/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.core;

import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.item.ChamMultiItemBlock;
import com.jaquadro.minecraft.chameleon.resources.ModelRegistry;
import com.jaquadro.minecraft.gardenstuff.block.BlockBloomeryFurnace;
import com.jaquadro.minecraft.gardenstuff.block.BlockCandelabra;
import com.jaquadro.minecraft.gardenstuff.block.BlockCandelilla;
import com.jaquadro.minecraft.gardenstuff.block.BlockFence;
import com.jaquadro.minecraft.gardenstuff.block.BlockLattice;
import com.jaquadro.minecraft.gardenstuff.block.BlockMetalMaterial;
import com.jaquadro.minecraft.gardenstuff.block.BlockStoneMaterial;
import com.jaquadro.minecraft.gardenstuff.block.tile.TileBloomeryFurnace;
import com.jaquadro.minecraft.gardenstuff.block.tile.TileCandelabra;
import com.jaquadro.minecraft.gardenstuff.block.tile.TileLattice;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="gardenstuff")
public class ModBlocks {
    @GameRegistry.ObjectHolder(value="stone_block")
    public static BlockStoneMaterial stoneMaterial;
    @GameRegistry.ObjectHolder(value="metal_block")
    public static BlockMetalMaterial metalMaterial;
    @GameRegistry.ObjectHolder(value="bloomery_furnace")
    public static BlockBloomeryFurnace bloomeryFurnace;
    @GameRegistry.ObjectHolder(value="metal_fence")
    public static BlockFence metalFence;
    @GameRegistry.ObjectHolder(value="metal_lattice")
    public static BlockLattice metalLattice;
    @GameRegistry.ObjectHolder(value="candelabra")
    public static BlockCandelabra candelabra;
    @GameRegistry.ObjectHolder(value="candelilla")
    public static BlockCandelilla candelilla;

    public static String makeName(String name) {
        return "gardenstuff." + name;
    }

    @Mod.EventBusSubscriber(modid="gardenstuff")
    public static class Registration {
        private static final ResourceLocation EMPTY_GROUP = new ResourceLocation("", "");

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.registerAll((IForgeRegistryEntry[])new Block[]{new BlockStoneMaterial("stone_block", ModBlocks.makeName("stone_block")), new BlockMetalMaterial("metal_block", ModBlocks.makeName("metal_block")), new BlockBloomeryFurnace("bloomery_furnace", ModBlocks.makeName("bloomery_furnace")), new BlockFence("metal_fence", ModBlocks.makeName("metal_fence")), new BlockLattice("metal_lattice", ModBlocks.makeName("metal_lattice")), new BlockCandelabra("candelabra", ModBlocks.makeName("candelabra")), new BlockCandelilla("candelilla", ModBlocks.makeName("candelilla"))});
            GameRegistry.registerTileEntity(TileBloomeryFurnace.class, (String)ModBlocks.makeName("bloomery_furnace"));
            GameRegistry.registerTileEntity(TileCandelabra.class, (String)ModBlocks.makeName("candelabra"));
            GameRegistry.registerTileEntity(TileLattice.class, (String)ModBlocks.makeName("metal_lattice"));
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.registerAll((IForgeRegistryEntry[])new Item[]{new ChamMultiItemBlock((Block)stoneMaterial, BlockStoneMaterial.VARIANT, BlockStoneMaterial.StoneType.class, BlockStoneMaterial.StoneType::byMetadata), new ChamMultiItemBlock((Block)metalMaterial, BlockMetalMaterial.VARIANT, BlockMetalMaterial.MetalType.class, BlockMetalMaterial.MetalType::byMetadata), (Item)new ItemBlock((Block)bloomeryFurnace).setRegistryName(bloomeryFurnace.getRegistryName()), new ChamMultiItemBlock((Block)metalFence, BlockFence.VARIANT, BlockFence.Variant.class, BlockFence.Variant::byMetadata), new ChamMultiItemBlock((Block)metalLattice, BlockLattice.VARIANT, BlockLattice.Variant.class, BlockLattice.Variant::byMetadata), new ChamMultiItemBlock((Block)candelabra, BlockCandelabra.VARIANT, BlockCandelabra.Variant.class, BlockCandelabra.Variant::byMetadata)});
            OreDictionary.registerOre((String)"blockCharcoal", (ItemStack)new ItemStack((Block)stoneMaterial, 1, BlockStoneMaterial.StoneType.CHARCOAL_BLOCK.getMetadata()));
            OreDictionary.registerOre((String)"blockWroughtIron", (ItemStack)new ItemStack((Block)metalMaterial, 1, BlockMetalMaterial.MetalType.WROUGHT_IRON_BLOCK.getMetadata()));
        }

        @SubscribeEvent
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            IForgeRegistry registry = event.getRegistry();
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public static void registerModels(ModelRegistryEvent event) {
            ModelRegistry modelRegistry = Chameleon.instance.modelRegistry;
            modelRegistry.registerItemVariants((Block)stoneMaterial);
            modelRegistry.registerItemVariants((Block)metalMaterial);
            modelRegistry.registerItemVariants((Block)bloomeryFurnace);
            modelRegistry.registerItemVariants((Block)metalFence);
            modelRegistry.registerItemVariants((Block)candelabra);
            modelRegistry.registerItemVariants((Block)candelilla);
            ModelLoader.setCustomStateMapper((Block)metalFence, (IStateMapper)new StateMap.Builder().func_178440_a(BlockFence.VARIANT).func_178439_a("_wrought_iron_fence").func_178441_a());
            ModelLoader.setCustomStateMapper((Block)metalLattice, (IStateMapper)new StateMap.Builder().func_178440_a(BlockLattice.VARIANT).func_178439_a("_lattice").func_178441_a());
            ModelLoader.setCustomStateMapper((Block)candelabra, (IStateMapper)new StateMap.Builder().func_178440_a(BlockCandelabra.VARIANT).func_178439_a("_candelabra").func_178441_a());
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)metalFence), (int)0, (ModelResourceLocation)new ModelResourceLocation("gardenstuff:metal_fence_0", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)metalFence), (int)1, (ModelResourceLocation)new ModelResourceLocation("gardenstuff:metal_fence_1", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)metalFence), (int)2, (ModelResourceLocation)new ModelResourceLocation("gardenstuff:metal_fence_2", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)metalFence), (int)3, (ModelResourceLocation)new ModelResourceLocation("gardenstuff:metal_fence_3", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)metalLattice), (int)0, (ModelResourceLocation)new ModelResourceLocation("gardenstuff:lattice_iron", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)metalLattice), (int)1, (ModelResourceLocation)new ModelResourceLocation("gardenstuff:lattice_wrought_iron", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)metalLattice), (int)2, (ModelResourceLocation)new ModelResourceLocation("gardenstuff:lattice_rust", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)metalLattice), (int)3, (ModelResourceLocation)new ModelResourceLocation("gardenstuff:lattice_aged", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)metalLattice), (int)4, (ModelResourceLocation)new ModelResourceLocation("gardenstuff:lattice_moss", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)candelabra), (int)0, (ModelResourceLocation)new ModelResourceLocation("gardenstuff:candelabra_level0", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)candelabra), (int)1, (ModelResourceLocation)new ModelResourceLocation("gardenstuff:candelabra_level1", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)candelabra), (int)2, (ModelResourceLocation)new ModelResourceLocation("gardenstuff:candelabra_level2", "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)candelabra), (int)3, (ModelResourceLocation)new ModelResourceLocation("gardenstuff:candelabra_level3", "inventory"));
        }
    }
}

