/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.block.tile;

import com.jaquadro.minecraft.chameleon.block.ChamLockableTileEntity;
import com.jaquadro.minecraft.chameleon.block.tiledata.CustomNameData;
import com.jaquadro.minecraft.chameleon.block.tiledata.LockableData;
import com.jaquadro.minecraft.chameleon.block.tiledata.TileDataShim;
import com.jaquadro.minecraft.gardenstuff.block.BlockBloomeryFurnace;
import com.jaquadro.minecraft.gardenstuff.block.BlockStoneMaterial;
import com.jaquadro.minecraft.gardenstuff.core.ModBlocks;
import com.jaquadro.minecraft.gardenstuff.core.ModItems;
import com.jaquadro.minecraft.gardenstuff.inventory.ContainerBloomeryFurnace;
import com.jaquadro.minecraft.gardenstuff.item.EnumMaterial;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileBloomeryFurnace
extends ChamLockableTileEntity
implements ITickable,
ISidedInventory {
    public static final int FIELD_FURNACE_BURN_TIME = 0;
    public static final int FIELD_CURRENT_ITEM_BURN_TIME = 1;
    public static final int FIELD_COOK_TIME = 2;
    public static final int FIELD_TOTAL_COOK_TIME = 3;
    private static final int SLOT_PRIMARY = 0;
    private static final int SLOT_SECONDARY = 1;
    private static final int SLOT_FUEL = 2;
    private static final int SLOT_OUTPUT = 3;
    private static final int[] slots = new int[]{0, 1, 2, 3};
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = null;
    IItemHandler itemHandler = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);

    public TileBloomeryFurnace() {
        this.injectData((TileDataShim)new LockableData());
        this.injectPortableData((TileDataShim)new CustomNameData("container.gardenstuff.bloomery_furnace"));
    }

    public static boolean isItemFuel(@Nonnull ItemStack stack) {
        return TileBloomeryFurnace.getItemBurnTime(stack) > 0;
    }

    public static int getItemBurnTime(@Nonnull ItemStack stack) {
        Block block;
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && (block = Block.func_149634_a((Item)item)) == ModBlocks.stoneMaterial && BlockStoneMaterial.StoneType.byMetadata(stack.func_77952_i()) == BlockStoneMaterial.StoneType.CHARCOAL_BLOCK) {
            return ModBlocks.stoneMaterial.getBurnTime(stack);
        }
        if (item == Items.field_151044_h && stack.func_77952_i() == 1) {
            return 1600;
        }
        return 0;
    }

    public static boolean isItemPrimaryInput(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() == Items.field_151042_j) {
            return true;
        }
        return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150366_p);
    }

    public static boolean isItemSecondaryInput(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public int getCookTime(@Nonnull ItemStack stack) {
        return 200;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        ItemStack itemOutput = new ItemStack(ModItems.material, 1, EnumMaterial.WROUGHT_IRON_INGOT.getMetadata());
        if (((ItemStack)this.furnaceItemStacks.get(3)).func_190926_b()) {
            this.furnaceItemStacks.set(3, (Object)itemOutput.func_77946_l());
        } else if (((ItemStack)this.furnaceItemStacks.get(3)).func_77973_b() == itemOutput.func_77973_b()) {
            ((ItemStack)this.furnaceItemStacks.get(3)).func_190917_f(1);
        }
        ((ItemStack)this.furnaceItemStacks.get(0)).func_190918_g(1);
        ((ItemStack)this.furnaceItemStacks.get(1)).func_190918_g(1);
        if (((ItemStack)this.furnaceItemStacks.get(0)).func_190916_E() <= 0) {
            this.furnaceItemStacks.set(0, (Object)ItemStack.field_190927_a);
        }
        if (((ItemStack)this.furnaceItemStacks.get(1)).func_190916_E() <= 0) {
            this.furnaceItemStacks.set(1, (Object)ItemStack.field_190927_a);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerBloomeryFurnace(playerInventory, (IInventory)this);
    }

    public String func_174875_k() {
        return "gardenstuff:bloomery_furnace";
    }

    public int[] func_180463_a(EnumFacing side) {
        return slots;
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, EnumFacing direction) {
        return index == 3;
    }

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.furnaceItemStacks) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.furnaceItemStacks.get(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.furnaceItemStacks, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.furnaceItemStacks, (int)index);
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        boolean stackEqual = !stack.func_190926_b() && stack.func_77969_a((ItemStack)this.furnaceItemStacks.get(index)) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)this.furnaceItemStacks.get(index)));
        this.furnaceItemStacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !stackEqual) {
            this.totalCookTime = this.getCookTime(stack);
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        if (index == 3) {
            return false;
        }
        if (index == 2) {
            return TileBloomeryFurnace.isItemFuel(stack);
        }
        if (index == 0) {
            return TileBloomeryFurnace.isItemPrimaryInput(stack);
        }
        if (index == 1) {
            return TileBloomeryFurnace.isItemSecondaryInput(stack);
        }
        return false;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            this.furnaceItemStacks.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public void func_73660_a() {
        boolean prevBurning = this.isBurning();
        boolean isDirty = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.func_145831_w().field_72995_K) {
            ItemStack fuelItem = (ItemStack)this.furnaceItemStacks.get(2);
            if (this.isBurning() || !fuelItem.func_190926_b() && !((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b() && !((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b()) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileBloomeryFurnace.getItemBurnTime(fuelItem);
                    if (this.isBurning()) {
                        isDirty = true;
                        if (!fuelItem.func_190926_b()) {
                            fuelItem.func_190918_g(1);
                            if (fuelItem.func_190926_b()) {
                                this.furnaceItemStacks.set(2, (Object)fuelItem.func_77973_b().getContainerItem((ItemStack)this.furnaceItemStacks.get(2)));
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime((ItemStack)this.furnaceItemStacks.get(0));
                        this.smeltItem();
                        isDirty = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (prevBurning != this.isBurning()) {
                isDirty = true;
                BlockBloomeryFurnace.setState(this.isBurning(), this.func_145831_w(), this.field_174879_c);
            }
        }
        if (isDirty) {
            this.func_70296_d();
        }
    }

    protected void readFromFixedNBT(NBTTagCompound tag) {
        super.readFromFixedNBT(tag);
        this.furnaceItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)tag, this.furnaceItemStacks);
        this.furnaceBurnTime = tag.func_74765_d("BurnTime");
        this.cookTime = tag.func_74765_d("CookTime");
        this.totalCookTime = tag.func_74765_d("CookTimeTotal");
        this.currentItemBurnTime = TileBloomeryFurnace.getItemBurnTime((ItemStack)this.furnaceItemStacks.get(2));
    }

    protected NBTTagCompound writeToFixedNBT(NBTTagCompound tag) {
        tag = super.writeToFixedNBT(tag);
        tag.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        tag.func_74777_a("CookTime", (short)this.cookTime);
        tag.func_74777_a("CookTimeTotal", (short)this.totalCookTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)tag, this.furnaceItemStacks);
        return tag;
    }

    private boolean canSmelt() {
        if (((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b() || ((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b()) {
            return false;
        }
        if (!TileBloomeryFurnace.isItemPrimaryInput((ItemStack)this.furnaceItemStacks.get(0))) {
            return false;
        }
        if (!TileBloomeryFurnace.isItemSecondaryInput((ItemStack)this.furnaceItemStacks.get(1))) {
            return false;
        }
        ItemStack itemOutput = new ItemStack(ModItems.material, 1, EnumMaterial.WROUGHT_IRON_INGOT.getMetadata());
        if (((ItemStack)this.furnaceItemStacks.get(3)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.furnaceItemStacks.get(3)).func_77969_a(itemOutput)) {
            return false;
        }
        int result = ((ItemStack)this.furnaceItemStacks.get(3)).func_190916_E() + itemOutput.func_190916_E();
        return result <= this.func_70297_j_() && result <= ((ItemStack)this.furnaceItemStacks.get(3)).func_77976_d();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }
}

