/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.block;

import com.jaquadro.minecraft.chameleon.resources.IItemEnum;
import com.jaquadro.minecraft.gardenstuff.block.BlockFence;
import com.jaquadro.minecraft.gardenstuff.block.tile.TileLattice;
import com.jaquadro.minecraft.gardenstuff.core.ModCreativeTabs;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLattice
extends Block {
    public static final PropertyEnum<Connection> NORTH = PropertyEnum.func_177709_a((String)"north", Connection.class);
    public static final PropertyEnum<Connection> EAST = PropertyEnum.func_177709_a((String)"east", Connection.class);
    public static final PropertyEnum<Connection> SOUTH = PropertyEnum.func_177709_a((String)"south", Connection.class);
    public static final PropertyEnum<Connection> WEST = PropertyEnum.func_177709_a((String)"west", Connection.class);
    public static final PropertyEnum<Connection> UP = PropertyEnum.func_177709_a((String)"up", Connection.class);
    public static final PropertyEnum<Connection> DOWN = PropertyEnum.func_177709_a((String)"down", Connection.class);
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    private static final AxisAlignedBB CENTER_AABB = new AxisAlignedBB(0.4375, 0.4375, 0.4375, 0.5625, 0.5625, 0.5625);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.4375, 0.4375, 0.0, 0.5625, 0.5625, 0.5625);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.4375, 0.4375, 0.4375, 1.0, 0.5625, 0.5625);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.4375, 0.4375, 0.4375, 0.5625, 0.5625, 1.0);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.4375, 0.4375, 0.5625, 0.5625, 0.5625);
    private static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.4375, 0.4375, 0.4375, 0.5625, 1.0, 0.5625);
    private static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 0.5625, 0.5625);

    public BlockLattice(String registryName, String unlocalizedName) {
        super(Material.field_151573_f);
        this.setRegistryName(registryName);
        this.func_149663_c(unlocalizedName);
        this.func_149647_a(ModCreativeTabs.tabGardenStuff);
        this.func_149711_c(2.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(NORTH, (Comparable)((Object)Connection.NONE)).func_177226_a(EAST, (Comparable)((Object)Connection.NONE)).func_177226_a(SOUTH, (Comparable)((Object)Connection.NONE)).func_177226_a(WEST, (Comparable)((Object)Connection.NONE)).func_177226_a(UP, (Comparable)((Object)Connection.NONE)).func_177226_a(DOWN, (Comparable)((Object)Connection.NONE)).func_177226_a(VARIANT, (Comparable)((Object)Variant.IRON)));
    }

    public int func_180651_a(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).getColor();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (Variant type : Variant.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (!p_185477_7_) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CENTER_AABB);
        if (state.func_177229_b(NORTH) != Connection.NONE) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
        }
        if (state.func_177229_b(EAST) != Connection.NONE) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        }
        if (state.func_177229_b(SOUTH) != Connection.NONE) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        }
        if (state.func_177229_b(WEST) != Connection.NONE) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        }
        if (state.func_177229_b(UP) != Connection.NONE) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)UP_AABB);
        }
        if (state.func_177229_b(DOWN) != Connection.NONE) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)DOWN_AABB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        float xMin = BlockLattice.boundingBoxExtant((Connection)((Object)state.func_177229_b(WEST)));
        float xMax = 1.0f - BlockLattice.boundingBoxExtant((Connection)((Object)state.func_177229_b(EAST)));
        float yMin = BlockLattice.boundingBoxExtant((Connection)((Object)state.func_177229_b(DOWN)));
        float yMax = 1.0f - BlockLattice.boundingBoxExtant((Connection)((Object)state.func_177229_b(UP)));
        float zMin = BlockLattice.boundingBoxExtant((Connection)((Object)state.func_177229_b(NORTH)));
        float zMax = 1.0f - BlockLattice.boundingBoxExtant((Connection)((Object)state.func_177229_b(SOUTH)));
        return new AxisAlignedBB((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax);
    }

    private static float boundingBoxExtant(Connection con) {
        switch (con) {
            case NONE: {
                return 0.4375f;
            }
        }
        return 0.0f;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    private boolean isNeighborHardConnection(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block;
        if (state.func_185904_a().func_76218_k() && state.func_185917_h()) {
            return true;
        }
        if (state.isSideSolid(world, pos, facing.func_176734_d())) {
            return true;
        }
        return facing == EnumFacing.DOWN && ((block = state.func_177230_c()) instanceof BlockFence || block instanceof net.minecraft.block.BlockFence);
    }

    private boolean isNeighborExtConnection(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return false;
    }

    private boolean isNeighborSelfConnection(IBlockState state) {
        return state.func_177230_c() instanceof BlockLattice;
    }

    private Connection getNeighborConnection(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos = pos.func_177972_a(facing));
        if (this.isNeighborSelfConnection(state)) {
            return Connection.LATTICE;
        }
        if (this.isNeighborHardConnection(state, world, pos, facing)) {
            return Connection.SIDE;
        }
        if (this.isNeighborExtConnection(state, world, pos, facing)) {
            return Connection.EXT;
        }
        return Connection.NONE;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a(NORTH, (Comparable)((Object)this.getNeighborConnection(world, pos, EnumFacing.NORTH))).func_177226_a(EAST, (Comparable)((Object)this.getNeighborConnection(world, pos, EnumFacing.EAST))).func_177226_a(SOUTH, (Comparable)((Object)this.getNeighborConnection(world, pos, EnumFacing.SOUTH))).func_177226_a(WEST, (Comparable)((Object)this.getNeighborConnection(world, pos, EnumFacing.WEST))).func_177226_a(UP, (Comparable)((Object)this.getNeighborConnection(world, pos, EnumFacing.UP))).func_177226_a(DOWN, (Comparable)((Object)this.getNeighborConnection(world, pos, EnumFacing.DOWN)));
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileLattice();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.byMetadata(meta)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH, UP, DOWN, VARIANT});
    }

    public static enum Variant implements IItemEnum
    {
        IRON(0, "iron", "iron", MapColor.field_151670_w),
        WROUGHT_IRON(1, "wrought_iron", "wrought_iron", MapColor.field_151646_E),
        RUST(2, "rust", "rust", MapColor.field_193562_N),
        AGED(3, "aged", "aged", MapColor.field_151650_B),
        MOSS(4, "moss", "moss", MapColor.field_193574_Z);

        private static final Variant[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;
        private final MapColor color;

        private Variant(int meta, String name, String unlocalizedName, MapColor color) {
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = unlocalizedName;
            this.color = color;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public int getMetadata() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public MapColor getColor() {
            return this.color;
        }

        public static Variant byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new Variant[Variant.values().length];
            Variant[] variantArray = Variant.values();
            int n = variantArray.length;
            for (int i = 0; i < n; ++i) {
                Variant upgrade;
                Variant.META_LOOKUP[upgrade.getMetadata()] = upgrade = variantArray[i];
            }
        }
    }

    public static enum Connection implements IStringSerializable
    {
        NONE("none"),
        SIDE("side"),
        EXT("ext"),
        LATTICE("lattice");

        private final String name;

        private Connection(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

