/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.block;

import com.jaquadro.minecraft.chameleon.resources.IItemEnum;
import com.jaquadro.minecraft.gardenstuff.core.ModCreativeTabs;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFence
extends Block {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    protected static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.375, 0.625, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.0, 0.625, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.375, 1.0, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.0, 1.0, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public static final AxisAlignedBB PILLAR_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.5, 0.625);
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.375, 0.0, 0.625, 0.625, 1.5, 1.0);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 0.375, 1.5, 0.625);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.5, 0.375);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.625, 0.0, 0.375, 1.0, 1.5, 0.625);

    public BlockFence(String registryName, String unlocalizedName) {
        super(Material.field_151573_f);
        this.setRegistryName(registryName);
        this.func_149663_c(unlocalizedName);
        this.func_149647_a(ModCreativeTabs.tabGardenStuff);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a(VARIANT, (Comparable)((Object)Variant.TYPE0)));
    }

    public int func_180651_a(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (Variant type : Variant.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).getColor();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        state = state.func_185899_b((IBlockAccess)worldIn, pos);
        BlockFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PILLAR_AABB);
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            BlockFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            BlockFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            BlockFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            BlockFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        return BOUNDING_BOXES[BlockFence.getBoundBoxIndex(state)];
    }

    private static int getBoundBoxIndex(IBlockState state) {
        int index = 0;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            index |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            index |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            index |= 1 << EnumFacing.WEST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            index |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        return index;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean canConnectTo(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockFence) {
            return true;
        }
        if (block == Blocks.field_180401_cv) {
            return false;
        }
        Material material = block.func_149688_o(state);
        if (!material.func_76218_k()) {
            return false;
        }
        if (!state.func_185917_h()) {
            return false;
        }
        return material != Material.field_151572_C;
    }

    public boolean canConnectToDown(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block instanceof BlockFence;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.byMetadata(meta)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(world, pos.func_177978_c()))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(world, pos.func_177974_f()))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(world, pos.func_177968_d()))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(world, pos.func_177976_e()))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.canConnectTo(world, pos.func_177984_a()))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.canConnectToDown(world, pos.func_177977_b())));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
        }
        return super.func_185471_a(state, mirror);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH, UP, DOWN, VARIANT});
    }

    public static enum Variant implements IItemEnum
    {
        TYPE0(0, "0", "0", MapColor.field_151646_E),
        TYPE1(1, "1", "1", MapColor.field_151646_E),
        TYPE2(2, "2", "2", MapColor.field_151646_E),
        TYPE3(3, "3", "3", MapColor.field_151646_E);

        private static final Variant[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;
        private final MapColor color;

        private Variant(int meta, String name, String unlocalizedName, MapColor color) {
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = unlocalizedName;
            this.color = color;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public MapColor getColor() {
            return this.color;
        }

        public static Variant byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String toString() {
            return this.unlocalizedName;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new Variant[Variant.values().length];
            Variant[] variantArray = Variant.values();
            int n = variantArray.length;
            for (int i = 0; i < n; ++i) {
                Variant upgrade;
                Variant.META_LOOKUP[upgrade.getMetadata()] = upgrade = variantArray[i];
            }
        }
    }
}

