/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.box;

import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.BoxPlane;
import com.creativemd.creativecore.common.utils.math.box.BoxUtils;
import com.creativemd.creativecore.common.utils.math.box.CreativeAxisAlignedBB;
import com.creativemd.creativecore.common.utils.math.collision.CollidingPlane;
import com.creativemd.creativecore.common.utils.math.vec.IVecOrigin;
import com.creativemd.creativecore.common.utils.math.vec.Ray2d;
import javax.annotation.Nullable;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class OrientatedBoundingBox
extends CreativeAxisAlignedBB {
    public IVecOrigin origin;
    public CollidingPlane.PlaneCache cache;
    public static final float EPSILON = 0.001f;

    public void buildCache() {
        this.cache = new CollidingPlane.PlaneCache(this);
    }

    public OrientatedBoundingBox(IVecOrigin origin, double x1, double y1, double z1, double x2, double y2, double z2) {
        super(x1, y1, z1, x2, y2, z2);
        this.origin = origin;
    }

    public OrientatedBoundingBox(IVecOrigin origin, AxisAlignedBB bb) {
        super(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
        this.origin = origin;
    }

    public OrientatedBoundingBox setMaxY(double y2) {
        return new OrientatedBoundingBox(this.origin, this.field_72340_a, this.field_72338_b, this.field_72339_c, this.field_72336_d, y2, this.field_72334_f);
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof OrientatedBoundingBox)) {
            return false;
        }
        OrientatedBoundingBox axisalignedbb = (OrientatedBoundingBox)((Object)p_equals_1_);
        if (axisalignedbb.origin != this.origin) {
            return false;
        }
        if (Double.compare(axisalignedbb.field_72340_a, this.field_72340_a) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.field_72338_b, this.field_72338_b) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.field_72339_c, this.field_72339_c) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.field_72336_d, this.field_72336_d) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.field_72337_e, this.field_72337_e) != 0) {
            return false;
        }
        return Double.compare(axisalignedbb.field_72334_f, this.field_72334_f) == 0;
    }

    public OrientatedBoundingBox contract(double x, double y, double z) {
        double d0 = this.field_72340_a;
        double d1 = this.field_72338_b;
        double d2 = this.field_72339_c;
        double d3 = this.field_72336_d;
        double d4 = this.field_72337_e;
        double d5 = this.field_72334_f;
        if (x < 0.0) {
            d0 -= x;
        } else if (x > 0.0) {
            d3 -= x;
        }
        if (y < 0.0) {
            d1 -= y;
        } else if (y > 0.0) {
            d4 -= y;
        }
        if (z < 0.0) {
            d2 -= z;
        } else if (z > 0.0) {
            d5 -= z;
        }
        return new OrientatedBoundingBox(this.origin, d0, d1, d2, d3, d4, d5);
    }

    public OrientatedBoundingBox expand(double x, double y, double z) {
        double d0 = this.field_72340_a;
        double d1 = this.field_72338_b;
        double d2 = this.field_72339_c;
        double d3 = this.field_72336_d;
        double d4 = this.field_72337_e;
        double d5 = this.field_72334_f;
        if (x < 0.0) {
            d0 += x;
        } else if (x > 0.0) {
            d3 += x;
        }
        if (y < 0.0) {
            d1 += y;
        } else if (y > 0.0) {
            d4 += y;
        }
        if (z < 0.0) {
            d2 += z;
        } else if (z > 0.0) {
            d5 += z;
        }
        return new OrientatedBoundingBox(this.origin, d0, d1, d2, d3, d4, d5);
    }

    public OrientatedBoundingBox grow(double x, double y, double z) {
        double d0 = this.field_72340_a - x;
        double d1 = this.field_72338_b - y;
        double d2 = this.field_72339_c - z;
        double d3 = this.field_72336_d + x;
        double d4 = this.field_72337_e + y;
        double d5 = this.field_72334_f + z;
        return new OrientatedBoundingBox(this.origin, d0, d1, d2, d3, d4, d5);
    }

    public OrientatedBoundingBox grow(double value) {
        return this.grow(value, value, value);
    }

    public AxisAlignedBB func_191500_a(AxisAlignedBB other) {
        if (other instanceof OrientatedBoundingBox) {
            OrientatedBoundingBox otherBB = (OrientatedBoundingBox)other;
            if (otherBB.origin == this.origin) {
                double d0 = Math.max(this.field_72340_a, other.field_72340_a);
                double d1 = Math.max(this.field_72338_b, other.field_72338_b);
                double d2 = Math.max(this.field_72339_c, other.field_72339_c);
                double d3 = Math.min(this.field_72336_d, other.field_72336_d);
                double d4 = Math.min(this.field_72337_e, other.field_72337_e);
                double d5 = Math.min(this.field_72334_f, other.field_72334_f);
                return new OrientatedBoundingBox(this.origin, d0, d1, d2, d3, d4, d5);
            }
            OrientatedBoundingBox converted = otherBB.origin.getOrientatedBox(this.origin.getAxisAlignedBox(this));
            double d0 = Math.max(converted.field_72340_a, other.field_72340_a);
            double d1 = Math.max(converted.field_72338_b, other.field_72338_b);
            double d2 = Math.max(converted.field_72339_c, other.field_72339_c);
            double d3 = Math.min(converted.field_72336_d, other.field_72336_d);
            double d4 = Math.min(converted.field_72337_e, other.field_72337_e);
            double d5 = Math.min(converted.field_72334_f, other.field_72334_f);
            return new OrientatedBoundingBox(otherBB.origin, d0, d1, d2, d3, d4, d5);
        }
        AxisAlignedBB box = this.origin.getAxisAlignedBox(this);
        double d0 = Math.max(box.field_72340_a, other.field_72340_a);
        double d1 = Math.max(box.field_72338_b, other.field_72338_b);
        double d2 = Math.max(box.field_72339_c, other.field_72339_c);
        double d3 = Math.min(box.field_72336_d, other.field_72336_d);
        double d4 = Math.min(box.field_72337_e, other.field_72337_e);
        double d5 = Math.min(box.field_72334_f, other.field_72334_f);
        return new AxisAlignedBB(d0, d1, d2, d3, d4, d5);
    }

    public AxisAlignedBB func_111270_a(AxisAlignedBB other) {
        if (other instanceof OrientatedBoundingBox) {
            OrientatedBoundingBox otherBB = (OrientatedBoundingBox)other;
            if (otherBB.origin == this.origin) {
                double d0 = Math.min(this.field_72340_a, other.field_72340_a);
                double d1 = Math.min(this.field_72338_b, other.field_72338_b);
                double d2 = Math.min(this.field_72339_c, other.field_72339_c);
                double d3 = Math.max(this.field_72336_d, other.field_72336_d);
                double d4 = Math.max(this.field_72337_e, other.field_72337_e);
                double d5 = Math.max(this.field_72334_f, other.field_72334_f);
                return new OrientatedBoundingBox(this.origin, d0, d1, d2, d3, d4, d5);
            }
            OrientatedBoundingBox converted = otherBB.origin.getOrientatedBox(this.origin.getAxisAlignedBox(this));
            double d0 = Math.min(converted.field_72340_a, other.field_72340_a);
            double d1 = Math.min(converted.field_72338_b, other.field_72338_b);
            double d2 = Math.min(converted.field_72339_c, other.field_72339_c);
            double d3 = Math.max(converted.field_72336_d, other.field_72336_d);
            double d4 = Math.max(converted.field_72337_e, other.field_72337_e);
            double d5 = Math.max(converted.field_72334_f, other.field_72334_f);
            return new OrientatedBoundingBox(otherBB.origin, d0, d1, d2, d3, d4, d5);
        }
        AxisAlignedBB box = this.origin.getAxisAlignedBox(this);
        double d0 = Math.min(box.field_72340_a, other.field_72340_a);
        double d1 = Math.min(box.field_72338_b, other.field_72338_b);
        double d2 = Math.min(box.field_72339_c, other.field_72339_c);
        double d3 = Math.max(box.field_72336_d, other.field_72336_d);
        double d4 = Math.max(box.field_72337_e, other.field_72337_e);
        double d5 = Math.max(box.field_72334_f, other.field_72334_f);
        return new AxisAlignedBB(d0, d1, d2, d3, d4, d5);
    }

    public OrientatedBoundingBox offset(double x, double y, double z) {
        return new OrientatedBoundingBox(this.origin, this.field_72340_a + x, this.field_72338_b + y, this.field_72339_c + z, this.field_72336_d + x, this.field_72337_e + y, this.field_72334_f + z);
    }

    public OrientatedBoundingBox offset(BlockPos pos) {
        return new OrientatedBoundingBox(this.origin, this.field_72340_a + (double)pos.func_177958_n(), this.field_72338_b + (double)pos.func_177956_o(), this.field_72339_c + (double)pos.func_177952_p(), this.field_72336_d + (double)pos.func_177958_n(), this.field_72337_e + (double)pos.func_177956_o(), this.field_72334_f + (double)pos.func_177952_p());
    }

    public OrientatedBoundingBox offset(Vec3d vec) {
        return this.offset(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    private static int getCornerOffset(double value, double min, double max) {
        if (value <= min) {
            return -1;
        }
        if (value >= max) {
            return 1;
        }
        return 0;
    }

    public static boolean isFurtherOrEqualThan(double value, double toCheck) {
        if (value < 0.0) {
            return toCheck <= value;
        }
        return toCheck >= value;
    }

    public double calculateDistanceRotated(AxisAlignedBB other, EnumFacing.Axis axis, double offset) {
        boolean maxTwoOffset;
        boolean positive = offset > 0.0;
        EnumFacing facing = EnumFacing.func_181076_a((EnumFacing.AxisDirection)(!positive ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)axis);
        double closestValue = OrientatedBoundingBox.getValueOfFacing(other, facing.func_176734_d());
        Vector3d[] corners = BoxUtils.getOuterCorner(facing, this.origin, this);
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst(axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond(axis);
        double minOne = OrientatedBoundingBox.getMin(other, one);
        double minTwo = OrientatedBoundingBox.getMin(other, two);
        double maxOne = OrientatedBoundingBox.getMax(other, one);
        double maxTwo = OrientatedBoundingBox.getMax(other, two);
        Vector3d outerCorner = corners[0];
        double outerCornerOne = RotationUtils.get(one, (Tuple3d)outerCorner);
        double outerCornerTwo = RotationUtils.get(two, (Tuple3d)outerCorner);
        double outerCornerAxis = RotationUtils.get(axis, (Tuple3d)outerCorner);
        int outerCornerOffsetOne = OrientatedBoundingBox.getCornerOffset(outerCornerOne, minOne, maxOne);
        int outerCornerOffsetTwo = OrientatedBoundingBox.getCornerOffset(outerCornerTwo, minTwo, maxTwo);
        if (outerCornerOffsetOne == 0 && outerCornerOffsetTwo == 0) {
            if (positive) {
                return RotationUtils.get(axis, (Tuple3d)outerCorner) - closestValue;
            }
            return closestValue - RotationUtils.get(axis, (Tuple3d)outerCorner);
        }
        double minDistance = Double.MAX_VALUE;
        Vector2d[] directions = new Vector2d[3];
        for (int i = 1; i <= 3; ++i) {
            double coordinateOne;
            double distance;
            double valueAxis;
            double coordinateTwo;
            Vector3d corner = corners[i];
            Ray2d line = new Ray2d(one, two, outerCorner, RotationUtils.get(one, (Tuple3d)corner) - outerCornerOne, RotationUtils.get(two, (Tuple3d)corner) - outerCornerTwo);
            directions[i - 1] = new Vector2d(line.directionOne, line.directionTwo);
            int cornerOffsetOne = OrientatedBoundingBox.getCornerOffset(RotationUtils.get(one, (Tuple3d)corner), minOne, maxOne);
            if (outerCornerOffsetOne != 0 && outerCornerOffsetOne == cornerOffsetOne) continue;
            int cornerOffsetTwo = OrientatedBoundingBox.getCornerOffset(RotationUtils.get(two, (Tuple3d)corner), minTwo, maxTwo);
            if (outerCornerOffsetTwo != 0 && outerCornerOffsetTwo == cornerOffsetTwo) continue;
            double axisStart = RotationUtils.get(axis, (Tuple3d)outerCorner);
            double axisDirection = RotationUtils.get(axis, (Tuple3d)corner) - axisStart;
            if (outerCornerOffsetOne == -1) {
                coordinateTwo = line.get(one, minOne);
                if (coordinateTwo > minTwo && coordinateTwo < maxTwo) {
                    valueAxis = axisStart + (minOne - line.originOne) / line.directionOne * axisDirection;
                    double d = distance = positive ? valueAxis - closestValue : closestValue - valueAxis;
                    if (distance < 0.0) {
                        return distance;
                    }
                    minDistance = Math.min(distance, minDistance);
                }
            } else if (outerCornerOffsetOne == 1 && (coordinateTwo = line.get(one, maxOne)) > minTwo && coordinateTwo < maxTwo) {
                valueAxis = axisStart + (maxOne - line.originOne) / line.directionOne * axisDirection;
                double d = distance = positive ? valueAxis - closestValue : closestValue - valueAxis;
                if (distance < 0.0) {
                    return distance;
                }
                minDistance = Math.min(distance, minDistance);
            }
            if (outerCornerOffsetTwo == -1) {
                coordinateOne = line.get(two, minTwo);
                if (!(coordinateOne > minOne) || !(coordinateOne < maxOne)) continue;
                valueAxis = axisStart + (minTwo - line.originTwo) / line.directionTwo * axisDirection;
                double d = distance = positive ? valueAxis - closestValue : closestValue - valueAxis;
                if (distance < 0.0) {
                    return distance;
                }
                minDistance = Math.min(distance, minDistance);
                continue;
            }
            if (outerCornerOffsetTwo != 1 || !((coordinateOne = line.get(two, maxTwo)) > minOne) || !(coordinateOne < maxOne)) continue;
            valueAxis = axisStart + (maxTwo - line.originTwo) / line.directionTwo * axisDirection;
            double d = distance = positive ? valueAxis - closestValue : closestValue - valueAxis;
            if (distance < 0.0) {
                return distance;
            }
            minDistance = Math.min(distance, minDistance);
        }
        boolean minOneOffset = outerCornerOne > minOne;
        boolean minTwoOffset = outerCornerTwo > minTwo;
        boolean maxOneOffset = outerCornerOne > maxOne;
        boolean bl = maxTwoOffset = outerCornerTwo > maxTwo;
        Vector2d[] vectors = minOneOffset == maxOneOffset && minTwoOffset == maxTwoOffset ? new Vector2d[]{new Vector2d((minOneOffset ? maxOne : minOne) - outerCornerOne, (minTwoOffset ? maxTwo : minTwo) - outerCornerTwo)} : (minOneOffset == maxOneOffset ? new Vector2d[]{new Vector2d((minOneOffset ? maxOne : minOne) - outerCornerOne, minTwo - outerCornerTwo), new Vector2d((minOneOffset ? maxOne : minOne) - outerCornerOne, maxTwo - outerCornerTwo)} : (minTwoOffset == maxTwoOffset ? new Vector2d[]{new Vector2d(minOne - outerCornerOne, (minTwoOffset ? maxTwo : minTwo) - outerCornerTwo), new Vector2d(maxOne - outerCornerOne, (minTwoOffset ? maxTwo : minTwo) - outerCornerTwo)} : new Vector2d[]{}));
        for (int i = 0; i < 3; ++i) {
            int indexFirst = i;
            int indexSecond = i == 2 ? 0 : i + 1;
            Vector2d first = directions[indexFirst];
            Vector2d second = directions[indexSecond];
            if (first.x == 0.0 || second.y == 0.0) {
                int temp = indexFirst;
                indexFirst = indexSecond;
                indexSecond = temp;
                first = directions[indexFirst];
                second = directions[indexSecond];
            }
            for (int j = 0; j < vectors.length; ++j) {
                double s;
                double t;
                Vector2d vector = vectors[j];
                if (!OrientatedBoundingBox.isFurtherOrEqualThan(vector.x, first.x) && !OrientatedBoundingBox.isFurtherOrEqualThan(vector.x, second.x) && !OrientatedBoundingBox.isFurtherOrEqualThan(vector.x, first.x + second.x) || !OrientatedBoundingBox.isFurtherOrEqualThan(vector.y, first.y) && !OrientatedBoundingBox.isFurtherOrEqualThan(vector.y, second.y) && !OrientatedBoundingBox.isFurtherOrEqualThan(vector.y, first.y + second.y) || (t = (vector.x * second.y - vector.y * second.x) / (first.x * second.y - first.y * second.x)) <= 0.0 || t >= 1.0 || Double.isNaN(t) || (s = (vector.y - t * first.y) / second.y) <= 0.0 || s >= 1.0 || Double.isNaN(s)) continue;
                double valueAxis = outerCornerAxis + (RotationUtils.get(axis, (Tuple3d)corners[indexFirst + 1]) - outerCornerAxis) * t + (RotationUtils.get(axis, (Tuple3d)corners[indexSecond + 1]) - outerCornerAxis) * s;
                double distance = positive ? valueAxis - closestValue : closestValue - valueAxis;
                minDistance = Math.min(distance, minDistance);
            }
        }
        if (minDistance == Double.MAX_VALUE) {
            return -1.0;
        }
        return minDistance;
    }

    public double calculateOffsetRotated(AxisAlignedBB other, EnumFacing.Axis axis, double offset) {
        if (offset == 0.0) {
            return offset;
        }
        double distance = this.calculateDistanceRotated(other, axis, offset);
        if (distance < 0.0 && !OrientatedBoundingBox.equals(distance, 0.0)) {
            return offset;
        }
        if (offset > 0.0) {
            if (distance < offset) {
                return distance;
            }
            return offset;
        }
        if (offset < 0.0) {
            if (-distance > offset) {
                return -distance;
            }
            return offset;
        }
        return offset;
    }

    public static boolean smallerThanAndEquals(double a, double b) {
        return a < b || OrientatedBoundingBox.equals(a, b);
    }

    public static boolean greaterThanAndEquals(double a, double b) {
        return a > b || OrientatedBoundingBox.equals(a, b);
    }

    public static boolean equals(double a, double b) {
        return a == b ? true : Math.abs(a - b) < (double)0.001f;
    }

    @Override
    public double calculateYOffsetStepUp(AxisAlignedBB other, AxisAlignedBB otherY, double offset) {
        double newOffset = this.func_72323_b(otherY, offset);
        if (offset > 0.0 ? newOffset < offset : newOffset > offset) {
            return newOffset / 2.0;
        }
        return newOffset;
    }

    public double getMaxTranslated(EnumFacing.Axis axis) {
        return this.getMax(axis) + RotationUtils.get(axis, (Tuple3d)this.origin.translation());
    }

    public double getMinTranslated(EnumFacing.Axis axis) {
        return this.getMin(axis) + RotationUtils.get(axis, (Tuple3d)this.origin.translation());
    }

    public double calculateOffset(AxisAlignedBB other, EnumFacing.Axis axis, double offset) {
        if (other instanceof OrientatedBoundingBox) {
            if (((OrientatedBoundingBox)other).origin == this.origin) {
                switch (axis) {
                    case X: {
                        return super.func_72316_a(other, offset);
                    }
                    case Y: {
                        return super.func_72323_b(other, offset);
                    }
                    case Z: {
                        return super.func_72322_c(other, offset);
                    }
                }
            }
            other = ((OrientatedBoundingBox)other).origin.getAxisAlignedBox(other);
        }
        if (this.origin.isRotated()) {
            return this.calculateOffsetRotated(other, axis, offset);
        }
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst(axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond(axis);
        if (OrientatedBoundingBox.getMax(other, one) > this.getMinTranslated(one) && OrientatedBoundingBox.getMin(other, one) < this.getMaxTranslated(one) && OrientatedBoundingBox.getMax(other, two) > this.getMinTranslated(two) && OrientatedBoundingBox.getMin(other, two) < this.getMaxTranslated(two)) {
            double d0;
            if (offset > 0.0 && OrientatedBoundingBox.getMax(other, axis) <= this.getMinTranslated(axis)) {
                double d1 = this.getMinTranslated(axis) - OrientatedBoundingBox.getMax(other, axis);
                if (d1 < offset) {
                    offset = d1;
                }
            } else if (offset < 0.0 && OrientatedBoundingBox.getMin(other, axis) >= this.getMaxTranslated(axis) && (d0 = this.getMaxTranslated(axis) - OrientatedBoundingBox.getMin(other, axis)) > offset) {
                offset = d0;
            }
            return offset;
        }
        return offset;
    }

    public double func_72316_a(AxisAlignedBB other, double offsetX) {
        return this.calculateOffset(other, EnumFacing.Axis.X, offsetX);
    }

    public double func_72323_b(AxisAlignedBB other, double offsetY) {
        return this.calculateOffset(other, EnumFacing.Axis.Y, offsetY);
    }

    public double func_72322_c(AxisAlignedBB other, double offsetZ) {
        return this.calculateOffset(other, EnumFacing.Axis.Z, offsetZ);
    }

    public boolean func_72326_a(AxisAlignedBB other) {
        if (other instanceof OrientatedBoundingBox) {
            if (((OrientatedBoundingBox)other).origin == this.origin) {
                return this.field_72340_a < other.field_72336_d && this.field_72336_d > other.field_72340_a && this.field_72338_b < other.field_72337_e && this.field_72337_e > other.field_72338_b && this.field_72339_c < other.field_72334_f && this.field_72334_f > other.field_72339_c;
            }
            OrientatedBoundingBox converted = ((OrientatedBoundingBox)other).origin.getOrientatedBox(this.origin.getAxisAlignedBox(this));
            return converted.field_72340_a < other.field_72336_d && converted.field_72336_d > other.field_72340_a && converted.field_72338_b < other.field_72337_e && converted.field_72337_e > other.field_72338_b && converted.field_72339_c < other.field_72334_f && converted.field_72334_f > other.field_72339_c;
        }
        return this.func_186668_a(other.field_72340_a, other.field_72338_b, other.field_72339_c, other.field_72336_d, other.field_72337_e, other.field_72334_f);
    }

    public boolean func_186668_a(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        AxisAlignedBB box = this.origin.getAxisAlignedBox(this);
        return box.field_72340_a < maxX && box.field_72336_d > minX && box.field_72338_b < maxY && box.field_72337_e > minY && box.field_72339_c < maxZ && box.field_72334_f > minZ;
    }

    public String toString() {
        return "box[" + this.field_72340_a + ", " + this.field_72338_b + ", " + this.field_72339_c + " -> " + this.field_72336_d + ", " + this.field_72337_e + ", " + this.field_72334_f + "]";
    }

    public Vector3d getCenter3d() {
        return new Vector3d(this.field_72340_a + (this.field_72336_d - this.field_72340_a) * 0.5, this.field_72338_b + (this.field_72337_e - this.field_72338_b) * 0.5, this.field_72339_c + (this.field_72334_f - this.field_72339_c) * 0.5);
    }

    public double getPushOutScale(double minScale, OrientatedBoundingBox fakeBox, AxisAlignedBB originalBox, Vector3d pushVec, Vector3d pushVecInv, @Nullable BoxPlane xPlane, @Nullable BoxPlane yPlane, @Nullable BoxPlane zPlane) {
        boolean pushZ;
        double scale = Double.MAX_VALUE;
        boolean pushX = pushVec.x != 0.0;
        boolean pushY = pushVec.y != 0.0;
        boolean bl = pushZ = pushVec.z != 0.0;
        if (pushX) {
            scale = pushVec.x > 0.0 ? Math.min(scale, (this.field_72336_d - fakeBox.field_72340_a) / pushVec.x) : Math.min(scale, (this.field_72340_a - fakeBox.field_72336_d) / pushVec.x);
        }
        if (pushY) {
            scale = pushVec.y > 0.0 ? Math.min(scale, (this.field_72337_e - fakeBox.field_72338_b) / pushVec.y) : Math.min(scale, (this.field_72338_b - fakeBox.field_72337_e) / pushVec.y);
        }
        if (pushZ) {
            scale = pushVec.z > 0.0 ? Math.min(scale, (this.field_72334_f - fakeBox.field_72339_c) / pushVec.z) : Math.min(scale, (this.field_72339_c - fakeBox.field_72334_f) / pushVec.z);
        }
        if (scale <= minScale) {
            return minScale;
        }
        return scale;
    }
}

