/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.box;

import com.creativemd.creativecore.common.utils.math.box.BoxUtils;
import javax.annotation.Nullable;
import javax.vecmath.Vector3d;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class CreativeAxisAlignedBB
extends AxisAlignedBB {
    public CreativeAxisAlignedBB(double x1, double y1, double z1, double x2, double y2, double z2) {
        super(x1, y1, z1, x2, y2, z2);
    }

    public CreativeAxisAlignedBB(BlockPos pos) {
        super(pos);
    }

    public CreativeAxisAlignedBB(BlockPos pos1, BlockPos pos2) {
        super(pos1, pos2);
    }

    public boolean contains(Vector3d vec) {
        if (vec.x > this.field_72340_a && vec.x < this.field_72336_d) {
            if (vec.y > this.field_72338_b && vec.y < this.field_72337_e) {
                return vec.z > this.field_72339_c && vec.z < this.field_72334_f;
            }
            return false;
        }
        return false;
    }

    public double calculateYOffsetStepUp(AxisAlignedBB other, AxisAlignedBB otherY, double offset) {
        return this.func_72323_b(other, offset);
    }

    protected double getValueOfFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return this.field_72336_d;
            }
            case WEST: {
                return this.field_72340_a;
            }
            case UP: {
                return this.field_72337_e;
            }
            case DOWN: {
                return this.field_72338_b;
            }
            case SOUTH: {
                return this.field_72334_f;
            }
            case NORTH: {
                return this.field_72339_c;
            }
        }
        return 0.0;
    }

    public Vec3d getCorner(BoxUtils.BoxCorner corner) {
        return new Vec3d(this.getCornerX(corner), this.getCornerY(corner), this.getCornerZ(corner));
    }

    public Vector3d getCornerVector3d(BoxUtils.BoxCorner corner) {
        return new Vector3d(this.getCornerX(corner), this.getCornerY(corner), this.getCornerZ(corner));
    }

    public double getCornerValue(BoxUtils.BoxCorner corner, EnumFacing.Axis axis) {
        return this.getValueOfFacing(corner.getFacing(axis));
    }

    public double getCornerX(BoxUtils.BoxCorner corner) {
        return this.getValueOfFacing(corner.x);
    }

    public double getCornerY(BoxUtils.BoxCorner corner) {
        return this.getValueOfFacing(corner.y);
    }

    public double getCornerZ(BoxUtils.BoxCorner corner) {
        return this.getValueOfFacing(corner.z);
    }

    public Vec3d getSize() {
        return new Vec3d(this.field_72336_d - this.field_72340_a, this.field_72337_e - this.field_72338_b, this.field_72334_f - this.field_72339_c);
    }

    public Vector3d getSize3d() {
        return new Vector3d(this.field_72336_d - this.field_72340_a, this.field_72337_e - this.field_72338_b, this.field_72334_f - this.field_72339_c);
    }

    public double getVolume() {
        return (this.field_72336_d - this.field_72340_a) * (this.field_72337_e - this.field_72338_b) * (this.field_72334_f - this.field_72339_c);
    }

    public double getIntersectionVolume(AxisAlignedBB other) {
        double d0 = Math.max(this.field_72340_a, other.field_72340_a);
        double d1 = Math.max(this.field_72338_b, other.field_72338_b);
        double d2 = Math.max(this.field_72339_c, other.field_72339_c);
        double d3 = Math.min(this.field_72336_d, other.field_72336_d);
        double d4 = Math.min(this.field_72337_e, other.field_72337_e);
        double d5 = Math.min(this.field_72334_f, other.field_72334_f);
        if (d0 < d3 && d1 < d4 && d2 < d5) {
            return (d3 - d0) * (d4 - d1) * (d5 - d2);
        }
        return 0.0;
    }

    public double getSize(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.field_72336_d - this.field_72340_a;
            }
            case Y: {
                return this.field_72337_e - this.field_72338_b;
            }
            case Z: {
                return this.field_72334_f - this.field_72339_c;
            }
        }
        return 0.0;
    }

    public double getMin(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.field_72340_a;
            }
            case Y: {
                return this.field_72338_b;
            }
            case Z: {
                return this.field_72339_c;
            }
        }
        return 0.0;
    }

    public double getMax(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.field_72336_d;
            }
            case Y: {
                return this.field_72337_e;
            }
            case Z: {
                return this.field_72334_f;
            }
        }
        return 0.0;
    }

    public static double getValueOfFacing(AxisAlignedBB bb, EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return bb.field_72336_d;
            }
            case WEST: {
                return bb.field_72340_a;
            }
            case UP: {
                return bb.field_72337_e;
            }
            case DOWN: {
                return bb.field_72338_b;
            }
            case SOUTH: {
                return bb.field_72334_f;
            }
            case NORTH: {
                return bb.field_72339_c;
            }
        }
        return 0.0;
    }

    public static double getMin(AxisAlignedBB bb, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return bb.field_72340_a;
            }
            case Y: {
                return bb.field_72338_b;
            }
            case Z: {
                return bb.field_72339_c;
            }
        }
        return 0.0;
    }

    public static double getMax(AxisAlignedBB bb, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return bb.field_72336_d;
            }
            case Y: {
                return bb.field_72337_e;
            }
            case Z: {
                return bb.field_72334_f;
            }
        }
        return 0.0;
    }

    public static Vec3d getCorner(AxisAlignedBB bb, BoxUtils.BoxCorner corner) {
        return new Vec3d(CreativeAxisAlignedBB.getCornerX(bb, corner), CreativeAxisAlignedBB.getCornerY(bb, corner), CreativeAxisAlignedBB.getCornerZ(bb, corner));
    }

    public static double getCornerValue(AxisAlignedBB bb, BoxUtils.BoxCorner corner, EnumFacing.Axis axis) {
        return CreativeAxisAlignedBB.getValueOfFacing(bb, corner.getFacing(axis));
    }

    public static double getCornerX(AxisAlignedBB bb, BoxUtils.BoxCorner corner) {
        return CreativeAxisAlignedBB.getValueOfFacing(bb, corner.x);
    }

    public static double getCornerY(AxisAlignedBB bb, BoxUtils.BoxCorner corner) {
        return CreativeAxisAlignedBB.getValueOfFacing(bb, corner.y);
    }

    public static double getCornerZ(AxisAlignedBB bb, BoxUtils.BoxCorner corner) {
        return CreativeAxisAlignedBB.getValueOfFacing(bb, corner.z);
    }

    public static boolean isClosest(Vec3d p_186661_1_, @Nullable Vec3d p_186661_2_, Vec3d p_186661_3_) {
        return p_186661_2_ == null || p_186661_1_.func_72436_e(p_186661_3_) < p_186661_1_.func_72436_e(p_186661_2_);
    }
}

