/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.box;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.CreativeAxisAlignedBB;
import com.creativemd.creativecore.common.utils.math.vec.IVecOrigin;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class BoxUtils {
    public static boolean equals(double a, double b, double deviation) {
        return a == b ? true : Math.abs(a - b) < deviation;
    }

    public static boolean greaterEquals(double a, double b, double deviation) {
        return a >= (b > 0.0 ? b - deviation : b + deviation);
    }

    public static Vector3d[] getCorners(AxisAlignedBB box) {
        Vector3d[] corners = new Vector3d[BoxCorner.values().length];
        for (int i = 0; i < corners.length; ++i) {
            corners[i] = BoxCorner.values()[i].getVector(box);
        }
        return corners;
    }

    private static double lengthIgnoreAxis(Vector3d vec, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return Math.sqrt(vec.y * vec.y + vec.z * vec.z);
            }
            case Y: {
                return Math.sqrt(vec.x * vec.x + vec.z * vec.z);
            }
            case Z: {
                return Math.sqrt(vec.x * vec.x + vec.y * vec.y);
            }
        }
        return 0.0;
    }

    private static void includeMaxRotationInBox(Box box, Vector3d vec, EnumFacing.Axis axis, Matrix3d matrix, double rotation, Vector3d additionalTranslation) {
        if (matrix == null) {
            return;
        }
        Double length = null;
        RotationUtils.BooleanRotation state = RotationUtils.BooleanRotation.getRotationState(axis, vec);
        if (rotation > 0.0) {
            EnumFacing facing;
            double skipRotation;
            for (skipRotation = 90.0; skipRotation < rotation && skipRotation < 360.0; skipRotation += 90.0) {
                facing = state.clockwiseMaxFacing();
                if (length == null) {
                    length = BoxUtils.lengthIgnoreAxis(vec, axis);
                }
                box.include(facing, length);
                if (additionalTranslation != null) {
                    box.include(facing, length + RotationUtils.get(facing.func_176740_k(), (Tuple3d)additionalTranslation));
                }
                state = state.clockwise();
            }
            matrix.transform((Tuple3d)vec);
            if (skipRotation < 360.0 && !state.is(vec)) {
                facing = state.clockwiseMaxFacing();
                if (length == null) {
                    length = BoxUtils.lengthIgnoreAxis(vec, axis);
                }
                box.include(facing, length);
                if (additionalTranslation != null) {
                    box.include(facing, length + RotationUtils.get(facing.func_176740_k(), (Tuple3d)additionalTranslation));
                }
            }
        } else {
            EnumFacing facing;
            double skipRotation;
            for (skipRotation = -90.0; skipRotation > rotation && skipRotation > -360.0; skipRotation -= 90.0) {
                facing = state.counterMaxClockwiseFacing();
                if (length == null) {
                    length = BoxUtils.lengthIgnoreAxis(vec, axis);
                }
                box.include(facing, length);
                if (additionalTranslation != null) {
                    box.include(facing, length + RotationUtils.get(facing.func_176740_k(), (Tuple3d)additionalTranslation));
                }
                state = state.counterClockwise();
            }
            matrix.transform((Tuple3d)vec);
            if (skipRotation > -360.0 && !state.is(vec)) {
                facing = state.counterMaxClockwiseFacing();
                if (length == null) {
                    length = BoxUtils.lengthIgnoreAxis(vec, axis);
                }
                box.include(facing, length);
                if (additionalTranslation != null) {
                    box.include(facing, length + RotationUtils.get(facing.func_176740_k(), (Tuple3d)additionalTranslation));
                }
            }
        }
    }

    public static AxisAlignedBB getRotatedSurrounding(AxisAlignedBB box, IVecOrigin origin, Matrix3d addRotX, double rotX, Matrix3d addRotY, double rotY, Matrix3d addRotZ, double rotZ, Vector3d additionalTranslation) {
        Vector3d[] corners = BoxUtils.getCorners(box);
        Box bb = new Box();
        for (int i = 0; i < corners.length; ++i) {
            Vector3d vec = corners[i];
            origin.transformPointToWorld(vec);
            vec.sub((Tuple3d)origin.translation());
            vec.sub((Tuple3d)origin.center());
            bb.include(vec);
            BoxUtils.includeMaxRotationInBox(bb, vec, EnumFacing.Axis.X, addRotX, rotX, additionalTranslation);
            BoxUtils.includeMaxRotationInBox(bb, vec, EnumFacing.Axis.Y, addRotY, rotY, additionalTranslation);
            BoxUtils.includeMaxRotationInBox(bb, vec, EnumFacing.Axis.Z, addRotZ, rotZ, additionalTranslation);
            if (additionalTranslation != null) {
                vec.add((Tuple3d)additionalTranslation);
            }
            bb.include(vec);
        }
        bb.translate(origin.center());
        bb.translate(origin.translation());
        return bb.getAxisBB();
    }

    public static Vector3d[] getRotatedCorners(AxisAlignedBB box, IVecOrigin origin) {
        Vector3d[] corners = BoxUtils.getCorners(box);
        for (int i = 0; i < corners.length; ++i) {
            Vector3d vec = corners[i];
            origin.transformPointToWorld(vec);
        }
        return corners;
    }

    public static Vector3d[] getOuterCorner(EnumFacing facing, IVecOrigin origin, AxisAlignedBB box) {
        Vector3d[] corners = BoxUtils.getCorners(box);
        boolean positive = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
        double value = 0.0;
        Enum selected = null;
        EnumFacing.Axis axis = facing.func_176740_k();
        for (int i = 0; i < corners.length; ++i) {
            Vector3d vec = corners[i];
            origin.transformPointToWorld(vec);
            double vectorValue = RotationUtils.get(axis, (Tuple3d)vec);
            if (selected != null && !(positive ? vectorValue > value : vectorValue < value)) continue;
            selected = BoxCorner.values()[i];
            value = vectorValue;
        }
        return new Vector3d[]{corners[selected.ordinal()], corners[((BoxCorner)selected).neighborOne.ordinal()], corners[((BoxCorner)selected).neighborTwo.ordinal()], corners[((BoxCorner)selected).neighborThree.ordinal()]};
    }

    static {
        BoxCorner.initCorners();
    }

    public static enum BoxFace {
        EAST(EnumFacing.EAST, new BoxCorner[]{BoxCorner.EUS, BoxCorner.EDS, BoxCorner.EDN, BoxCorner.EUN}),
        WEST(EnumFacing.WEST, new BoxCorner[]{BoxCorner.WUN, BoxCorner.WDN, BoxCorner.WDS, BoxCorner.WUS}),
        UP(EnumFacing.UP, new BoxCorner[]{BoxCorner.WUN, BoxCorner.WUS, BoxCorner.EUS, BoxCorner.EUN}),
        DOWN(EnumFacing.DOWN, new BoxCorner[]{BoxCorner.WDS, BoxCorner.WDN, BoxCorner.EDN, BoxCorner.EDS}),
        SOUTH(EnumFacing.SOUTH, new BoxCorner[]{BoxCorner.WUS, BoxCorner.WDS, BoxCorner.EDS, BoxCorner.EUS}),
        NORTH(EnumFacing.NORTH, new BoxCorner[]{BoxCorner.EUN, BoxCorner.EDN, BoxCorner.WDN, BoxCorner.WUN});

        public final EnumFacing facing;
        public final BoxCorner[] corners;

        private BoxFace(EnumFacing facing, BoxCorner[] corners) {
            this.facing = facing;
            this.corners = corners;
        }

        public Vector3d first(Vector3d[] corners) {
            return corners[this.corners[0].ordinal()];
        }

        public Vector3d normal(Vector3d[] corners) {
            Vector3d origin = this.first(corners);
            Vector3d first = new Vector3d(corners[this.corners[1].ordinal()]);
            Vector3d second = new Vector3d(corners[this.corners[2].ordinal()]);
            first.sub((Tuple3d)origin);
            second.sub((Tuple3d)origin);
            return new Vector3d(first.y * second.z - first.z * second.y, first.z * second.x - first.x * second.z, first.x * second.y - first.y * second.x);
        }

        public static BoxFace getFace(EnumFacing facing) {
            switch (facing) {
                case EAST: {
                    return EAST;
                }
                case WEST: {
                    return WEST;
                }
                case UP: {
                    return UP;
                }
                case DOWN: {
                    return DOWN;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case NORTH: {
                    return NORTH;
                }
            }
            return null;
        }

        public static BoxFace getFace(EnumFacing.Axis axis, boolean direction) {
            switch (axis) {
                case X: {
                    return direction ? EAST : WEST;
                }
                case Y: {
                    return direction ? UP : DOWN;
                }
                case Z: {
                    return direction ? SOUTH : NORTH;
                }
            }
            return null;
        }
    }

    public static enum BoxCorner {
        EUN(EnumFacing.EAST, EnumFacing.UP, EnumFacing.NORTH),
        EUS(EnumFacing.EAST, EnumFacing.UP, EnumFacing.SOUTH),
        EDN(EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.NORTH),
        EDS(EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.SOUTH),
        WUN(EnumFacing.WEST, EnumFacing.UP, EnumFacing.NORTH),
        WUS(EnumFacing.WEST, EnumFacing.UP, EnumFacing.SOUTH),
        WDN(EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.NORTH),
        WDS(EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.SOUTH);

        public final EnumFacing x;
        public final EnumFacing y;
        public final EnumFacing z;
        public BoxCorner neighborOne;
        public BoxCorner neighborTwo;
        public BoxCorner neighborThree;

        private BoxCorner(EnumFacing x, EnumFacing y, EnumFacing z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        private void initCorner() {
            this.neighborOne = BoxCorner.getCorner(this.x.func_176734_d(), this.y, this.z);
            this.neighborTwo = BoxCorner.getCorner(this.x, this.y.func_176734_d(), this.z);
            this.neighborThree = BoxCorner.getCorner(this.x, this.y, this.z.func_176734_d());
        }

        public Vector3d getVector(AxisAlignedBB box) {
            return new Vector3d(CreativeAxisAlignedBB.getCornerX(box, this), CreativeAxisAlignedBB.getCornerY(box, this), CreativeAxisAlignedBB.getCornerZ(box, this));
        }

        public boolean isFacingPositive(EnumFacing.Axis axis) {
            return this.getFacing(axis).func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
        }

        public EnumFacing getFacing(EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return this.x;
                }
                case Y: {
                    return this.y;
                }
                case Z: {
                    return this.z;
                }
            }
            return null;
        }

        public BoxCorner flip(EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return BoxCorner.getCorner(this.x.func_176734_d(), this.y, this.z);
                }
                case Y: {
                    return BoxCorner.getCorner(this.x, this.y.func_176734_d(), this.z);
                }
                case Z: {
                    return BoxCorner.getCorner(this.x, this.y, this.z.func_176734_d());
                }
            }
            return null;
        }

        public BoxCorner rotate(Rotation rotation) {
            int normalX = this.x.func_176743_c().func_179524_a();
            int normalY = this.y.func_176743_c().func_179524_a();
            int normalZ = this.z.func_176743_c().func_179524_a();
            return BoxCorner.getCorner(EnumFacing.func_181076_a((EnumFacing.AxisDirection)(rotation.getMatrix().getX(normalX, normalY, normalZ) > 0 ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)EnumFacing.Axis.X), EnumFacing.func_181076_a((EnumFacing.AxisDirection)(rotation.getMatrix().getY(normalX, normalY, normalZ) > 0 ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)EnumFacing.Axis.Y), EnumFacing.func_181076_a((EnumFacing.AxisDirection)(rotation.getMatrix().getZ(normalX, normalY, normalZ) > 0 ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)EnumFacing.Axis.Z));
        }

        public static BoxCorner getCornerUnsorted(EnumFacing facing) {
            switch (facing.func_176740_k()) {
                case X: {
                    return BoxCorner.getCorner(facing, EnumFacing.UP, EnumFacing.SOUTH);
                }
                case Y: {
                    return BoxCorner.getCorner(EnumFacing.EAST, facing, EnumFacing.SOUTH);
                }
                case Z: {
                    return BoxCorner.getCorner(EnumFacing.EAST, EnumFacing.UP, facing);
                }
            }
            return null;
        }

        public static BoxCorner getCornerUnsorted(EnumFacing facing, EnumFacing facing2, EnumFacing facing3) {
            return BoxCorner.getCorner(facing.func_176740_k() != EnumFacing.Axis.X ? (facing2.func_176740_k() != EnumFacing.Axis.X ? facing3 : facing2) : facing, facing.func_176740_k() != EnumFacing.Axis.Y ? (facing2.func_176740_k() != EnumFacing.Axis.Y ? facing3 : facing2) : facing, facing.func_176740_k() != EnumFacing.Axis.Z ? (facing2.func_176740_k() != EnumFacing.Axis.Z ? facing3 : facing2) : facing);
        }

        public static BoxCorner getCorner(EnumFacing x, EnumFacing y, EnumFacing z) {
            for (BoxCorner corner : BoxCorner.values()) {
                if (corner.x != x || corner.y != y || corner.z != z) continue;
                return corner;
            }
            return null;
        }

        private static void initCorners() {
            for (BoxCorner corner : BoxCorner.values()) {
                corner.initCorner();
            }
        }
    }

    private static class Box {
        public double minX = Double.MAX_VALUE;
        public double minY = Double.MAX_VALUE;
        public double minZ = Double.MAX_VALUE;
        public double maxX = -1.7976931348623157E308;
        public double maxY = -1.7976931348623157E308;
        public double maxZ = -1.7976931348623157E308;

        public void include(Vector3d vec) {
            this.minX = Math.min(this.minX, vec.x);
            this.minY = Math.min(this.minY, vec.y);
            this.minZ = Math.min(this.minZ, vec.z);
            this.maxX = Math.max(this.maxX, vec.x);
            this.maxY = Math.max(this.maxY, vec.y);
            this.maxZ = Math.max(this.maxZ, vec.z);
        }

        public void include(EnumFacing facing, double value) {
            switch (facing) {
                case EAST: {
                    this.maxX = Math.max(this.maxX, value);
                    break;
                }
                case WEST: {
                    this.minX = Math.min(this.minX, value);
                    break;
                }
                case UP: {
                    this.maxY = Math.max(this.maxY, value);
                    break;
                }
                case DOWN: {
                    this.minY = Math.min(this.minY, value);
                    break;
                }
                case SOUTH: {
                    this.maxZ = Math.max(this.maxZ, value);
                    break;
                }
                case NORTH: {
                    this.minZ = Math.min(this.minZ, value);
                }
            }
        }

        public void translate(Vector3d translation) {
            this.minX += translation.x;
            this.minY += translation.y;
            this.minZ += translation.z;
            this.maxX += translation.x;
            this.maxY += translation.y;
            this.maxZ += translation.z;
        }

        public AxisAlignedBB getAxisBB() {
            return new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
    }
}

