/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.CreativeMessageHandler;
import com.creativemd.creativecore.common.packet.CreativeSplittedMessageHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketReciever
implements IMessageHandler<CreativeMessageHandler, IMessage> {
    public static HashMap<PacketKey, PacketValue> splittedPackets = new HashMap();
    public static ArrayList<CreativeSplittedMessageHandler> packetsToSend = new ArrayList();
    @SideOnly(value=Side.CLIENT)
    public static HashMap<PacketKey, PacketValue> clientSplittedPackets;
    @SideOnly(value=Side.CLIENT)
    public static ArrayList<CreativeSplittedMessageHandler> clientPacketsToSend;

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        clientSplittedPackets = new HashMap();
        clientPacketsToSend = new ArrayList();
    }

    public static void refreshQueue(boolean isServer) {
        if (!isServer) {
            PacketReciever.refreshQueueClient();
        } else {
            if (splittedPackets.isEmpty()) {
                return;
            }
            Iterator<Map.Entry<PacketKey, PacketValue>> iterator = splittedPackets.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<PacketKey, PacketValue> entry = iterator.next();
                if (!entry.getValue().isExpired()) continue;
                System.out.println("Packet parts expired " + (entry.getValue().received + 1) + "/" + entry.getValue().amount);
                iterator.remove();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void refreshQueueClient() {
        if (clientSplittedPackets.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<PacketKey, PacketValue>> iterator = clientSplittedPackets.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PacketKey, PacketValue> entry = iterator.next();
            if (!entry.getValue().isExpired()) continue;
            System.out.println("Packet parts expired " + (entry.getValue().received + 1) + "/" + entry.getValue().amount);
            iterator.remove();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void executeClient(final IMessage message) {
        if (message instanceof CreativeMessageHandler) {
            CreativeMessageHandler cm = (CreativeMessageHandler)message;
            if (!cm.isLast) {
                PacketKey key = new PacketKey(CreativeCorePacket.getIDByClass(cm.packet), cm.uuid);
                if (clientSplittedPackets.containsKey(key)) {
                    System.out.println("Something went wrong! Received another packet of the same type with the same uuid id! " + key);
                } else {
                    clientSplittedPackets.put(key, new PacketValue(cm.content, cm.uuid, cm.packet, cm.amount));
                }
            } else if (cm.packet != null) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        ((CreativeMessageHandler)message).packet.executeClient((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                    }
                });
            }
        }
    }

    public CreativeMessageHandler onMessage(final CreativeMessageHandler message, final MessageContext ctx) {
        if (ctx.side.isClient()) {
            this.executeClient(message);
        } else if (message instanceof CreativeMessageHandler) {
            CreativeMessageHandler cm = message;
            if (!cm.isLast) {
                PacketKey key = new PacketKey(CreativeCorePacket.getIDByClass(cm.packet), cm.uuid);
                if (splittedPackets.containsKey(key)) {
                    System.out.println("Something went wrong! Received another packet of the same type with the same uuid id! " + key);
                } else {
                    splittedPackets.put(key, new PacketValue(cm.content, cm.uuid, cm.packet, cm.amount));
                }
            } else if (cm.packet != null) {
                ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        message.packet.executeServer((EntityPlayer)ctx.getServerHandler().field_147369_b);
                    }
                });
            }
        }
        return null;
    }

    static {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            PacketReciever.initClient();
        }
    }

    public static class PacketValue {
        public static long timeToWait = 60000L;
        public final ByteBuf buf;
        public final UUID uuid;
        public final CreativeCorePacket packet;
        public final int amount;
        public int received;
        public long lastReceivedPart = System.currentTimeMillis();

        public PacketValue(ByteBuf buf, UUID uuid, CreativeCorePacket packet, int amount) {
            this.buf = buf;
            this.packet = packet;
            this.amount = amount;
            this.uuid = uuid;
        }

        public boolean isComplete() {
            return this.received == this.amount - 1;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.lastReceivedPart > timeToWait;
        }

        public void receivePacket(ByteBuf toRead, int index, int length) throws IllegalAccessException {
            ++this.received;
            if (this.received >= this.amount) {
                throw new IllegalAccessException("This packet received more parts than it should! packetID=" + CreativeCorePacket.getIDByClass(this.packet) + ", uuid=" + this.uuid);
            }
            this.buf.writeBytes(toRead, index, length);
            this.lastReceivedPart = System.nanoTime();
        }
    }

    public static class PacketKey {
        public final String packetID;
        public final UUID uuid;

        public PacketKey(String packetID, UUID uuid) {
            this.packetID = packetID;
            this.uuid = uuid;
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof PacketKey) {
                return ((PacketKey)object).packetID.equals(this.packetID) && ((PacketKey)object).uuid.equals(this.uuid);
            }
            return false;
        }

        public String toString() {
            return "[id=" + this.packetID + ",uuid=" + this.uuid + "]";
        }
    }
}

