/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.client.rendering.model;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.creativecore.common.block.TileEntityState;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class CreativeBakedModel
implements IBakedModel {
    public static Minecraft mc = Minecraft.func_71410_x();
    public static ItemColors itemColores = null;
    public static TextureAtlasSprite woodenTexture;
    private static ItemStack lastItemStack;
    public static ItemOverrideList customOverride;
    private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms;
    private static TRSRTransformation baseState;
    private static final TRSRTransformation flipX;

    public static void lateInit() {
        itemColores = mc.getItemColors();
    }

    public static void setLastItemStack(ItemStack stack) {
        lastItemStack = stack;
    }

    public static TextureAtlasSprite getWoodenTexture() {
        if (woodenTexture == null) {
            woodenTexture = mc.func_147117_R().func_110572_b("minecraft:blocks/planks_oak");
        }
        return woodenTexture;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return CreativeBakedModel.getBlockQuads(state, side, rand, false);
    }

    public static List<BakedQuad> getBlockQuads(List<? extends RenderCubeObject> cubes, List<BakedQuad> baked, ICreativeRendered renderer, EnumFacing side, IBlockState state, BlockRenderLayer layer, Block renderBlock, TileEntity te, long rand, ItemStack stack, boolean threaded) {
        for (int i = 0; i < cubes.size(); ++i) {
            IBlockState newState;
            RenderCubeObject cube;
            block11: {
                cube = cubes.get(i);
                if (!cube.shouldSideBeRendered(side)) continue;
                Block block = renderBlock;
                if (cube.block != null) {
                    block = cube.block;
                }
                newState = cube.getBlockState(block);
                if (state != null && te != null) {
                    newState = newState.func_185899_b((IBlockAccess)te.func_145831_w(), te.func_174877_v());
                }
                try {
                    if (layer != null && renderBlock != null && !renderBlock.canRenderInLayer(state, layer)) {
                    }
                    break block11;
                }
                catch (Exception e) {
                    try {
                        if (block.func_180664_k() != layer) {
                            continue;
                        }
                        break block11;
                    }
                    catch (Exception e2) {
                        if (layer == BlockRenderLayer.SOLID) break block11;
                    }
                }
                continue;
            }
            IBakedModel blockModel = mc.func_175602_ab().func_184389_a(newState);
            int defaultColor = -1;
            if (te == null && stack != null) {
                defaultColor = itemColores.func_186728_a(new ItemStack(newState.func_177230_c(), 1, newState.func_177230_c().func_176201_c(newState)), -1);
            }
            baked.addAll(cube.getBakedQuad((IBlockAccess)(te != null ? te.func_145831_w() : null), te != null ? te.func_174877_v() : null, cube.getOffset(), newState, blockModel, side, layer, rand, true, defaultColor));
        }
        if (baked.size() > 0 && renderer != null) {
            renderer.saveCachedModel(side, layer, baked, state, te, stack, threaded);
        }
        return baked;
    }

    public static List<BakedQuad> getBakedQuad(IBlockAccess world, RenderCubeObject cube, @Nullable BlockPos pos, BlockPos offset, IBlockState state, IBakedModel blockModel, BlockRenderLayer layer, EnumFacing side, long rand, boolean overrideTint) {
        return cube.getBakedQuad(world, pos, offset, state, blockModel, side, layer, rand, overrideTint, -1);
    }

    public static List<BakedQuad> getBlockQuads(IBlockState state, EnumFacing side, long rand, boolean threaded) {
        ArrayList<BakedQuad> baked = new ArrayList<BakedQuad>();
        Block renderBlock = null;
        if (state == null && lastItemStack != null) {
            renderBlock = Block.func_149634_a((Item)lastItemStack.func_77973_b());
        } else if (state != null) {
            renderBlock = state.func_177230_c();
        }
        TileEntity te = state instanceof TileEntityState ? ((TileEntityState)state).te : null;
        ItemStack stack = state != null ? null : lastItemStack;
        List<? extends RenderCubeObject> cubes = null;
        ICreativeRendered renderer = null;
        if (renderBlock instanceof ICreativeRendered) {
            renderer = (ICreativeRendered)renderBlock;
        } else if (lastItemStack != null && lastItemStack.func_77973_b() instanceof ICreativeRendered) {
            renderer = (ICreativeRendered)lastItemStack.func_77973_b();
        }
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (side == null) {
            return baked;
        }
        if (renderer != null) {
            List<BakedQuad> cached = renderer.getCachedModel(side, layer, state, te, stack, threaded);
            if (cached != null) {
                return cached;
            }
            cubes = renderer.getRenderingCubes(state, te, stack);
        }
        if (cubes != null) {
            return CreativeBakedModel.getBlockQuads(cubes, baked, renderer, side, state, layer, renderBlock, te, rand, stack, threaded);
        }
        return baked;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return CreativeBakedModel.getWoodenTexture();
    }

    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null));
    }

    private static TRSRTransformation leftify(TRSRTransformation transform) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)flipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(flipX));
    }

    public static final void loadTransformation() {
        TRSRTransformation thirdperson = CreativeBakedModel.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)CreativeBakedModel.get(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
        builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)CreativeBakedModel.get(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)CreativeBakedModel.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdperson);
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)CreativeBakedModel.leftify(thirdperson));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)CreativeBakedModel.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)CreativeBakedModel.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f));
        SimpleModelState perState = new SimpleModelState(ImmutableMap.copyOf((Map)builder.build()));
        baseState = perState.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        cameraTransforms = ImmutableMap.copyOf((Map)builder.build());
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        if (cameraTransforms == null) {
            CreativeBakedModel.loadTransformation();
        }
        if (lastItemStack != null) {
            ICreativeRendered renderer = null;
            Block block = Block.func_149634_a((Item)lastItemStack.func_77973_b());
            if (block instanceof ICreativeRendered) {
                renderer = (ICreativeRendered)block;
            } else if (lastItemStack != null && lastItemStack.func_77973_b() instanceof ICreativeRendered) {
                renderer = (ICreativeRendered)lastItemStack.func_77973_b();
            }
            if (renderer != null) {
                renderer.applyCustomOpenGLHackery(lastItemStack, cameraTransformType);
            }
        }
        TRSRTransformation tr = (TRSRTransformation)cameraTransforms.get((Object)cameraTransformType);
        Matrix4f mat = null;
        if (tr != null && !tr.equals((Object)TRSRTransformation.identity())) {
            mat = TRSRTransformation.blockCornerToCenter((TRSRTransformation)tr).getMatrix();
        }
        return Pair.of((Object)this, mat);
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return customOverride;
    }

    static {
        lastItemStack = null;
        customOverride = new ItemOverrideList(new ArrayList()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                lastItemStack = stack;
                return super.handleItemState(originalModel, stack, world, entity);
            }
        };
        flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
    }
}

