/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.util;

import gollorum.signpost.management.ClientConfigStorage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.Paintable;
import gollorum.signpost.util.math.tracking.DDDVector;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class Sign
implements Paintable {
    public BaseInfo base;
    public int rotation;
    public boolean flip;
    public OverlayType overlay;
    public boolean point;
    public ResourceLocation paint;

    public Sign(ResourceLocation texture) {
        this.base = null;
        this.rotation = 0;
        this.flip = false;
        this.overlay = null;
        this.point = false;
        this.paint = texture;
    }

    public Sign(BaseInfo base, int rotation, boolean flip, OverlayType overlay, boolean point, ResourceLocation paint) {
        this.base = base;
        this.rotation = rotation;
        this.flip = flip;
        this.overlay = overlay;
        this.point = point;
        this.paint = paint;
    }

    public final double calcRot(int x, int z) {
        if (this.point && this.base != null && this.base.pos != null && !ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
            int dx = x - this.base.blockPos.x;
            int dz = z - this.base.blockPos.z;
            return DDDVector.genAngle(dx, dz) + Math.toRadians(-90 + (this.flip ? 0 : 180) + (dx < 0 && dz > 0 ? 180 : 0));
        }
        return Math.toRadians(this.rotation);
    }

    public boolean isValid() {
        return this.base != null && this.base.hasName();
    }

    public void rot(int i, int x, int z) {
        if (this.point) {
            this.rotation = (int)Math.round(Math.toDegrees(this.calcRot(x, z)) / 15.0) * 15;
            this.point = false;
        }
        this.rotation = (this.rotation + i) % 360;
    }

    public String toString() {
        return "" + this.base;
    }

    @Override
    public ResourceLocation getTexture() {
        return this.paint;
    }

    @Override
    public void setTexture(ResourceLocation texture) {
        this.paint = texture;
    }

    public static enum OverlayType {
        GRAS("grass", Items.field_151014_N),
        VINE("vine", Item.func_150898_a((Block)Blocks.field_150395_bd)),
        SNOW("snow", Items.field_151126_ay);

        public String texture;
        public Item item;

        private OverlayType(String texture, Item item) {
            this.texture = texture;
            this.item = item;
        }

        public static OverlayType get(String arg) {
            try {
                return OverlayType.valueOf(arg);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

