/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blocks.tiles;

import gollorum.signpost.SPEventHandler;
import gollorum.signpost.blocks.PostPost;
import gollorum.signpost.blocks.tiles.SuperPostPostTile;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.SendAllPostBasesMessage;
import gollorum.signpost.network.messages.SendPostBasesMessage;
import gollorum.signpost.util.BoolRun;
import gollorum.signpost.util.DoubleBaseInfo;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.Paintable;
import gollorum.signpost.util.Sign;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PostPostTile
extends SuperPostPostTile {
    public PostPost.PostType type = null;
    @Deprecated
    public DoubleBaseInfo bases = null;

    public PostPostTile() {
        SPEventHandler.scheduleTask(new BoolRun(){

            @Override
            public boolean run() {
                if (PostPostTile.this.func_145838_q() == null) {
                    return false;
                }
                if (PostPostTile.this.func_145838_q() instanceof PostPost) {
                    PostPostTile.this.type = ((PostPost)PostPostTile.this.func_145838_q()).type;
                }
                return true;
            }
        });
    }

    public PostPostTile(PostPost.PostType type) {
        this.type = type;
    }

    public DoubleBaseInfo getBases() {
        DoubleBaseInfo bases = PostHandler.getPosts().get(this.toPos());
        if (bases == null) {
            bases = this.type == null ? new DoubleBaseInfo(PostPost.PostType.OAK.texture, PostPost.PostType.OAK.resLocMain) : new DoubleBaseInfo(this.type.texture, this.type.resLocMain);
            PostHandler.getPosts().put(this.toPos(), bases);
        }
        this.bases = bases;
        return this.bases;
    }

    @Override
    public void onBlockDestroy(MyBlockPos pos) {
        EntityItem item;
        super.onBlockDestroy(pos);
        this.isCanceled = true;
        DoubleBaseInfo bases = this.getBases();
        if (bases.sign1.overlay != null) {
            item = new EntityItem(this.field_145850_b, (double)pos.x, (double)pos.y, (double)pos.z, new ItemStack(bases.sign1.overlay.item, 1));
            this.field_145850_b.func_72838_d((Entity)item);
        }
        if (bases.sign2.overlay != null) {
            item = new EntityItem(this.field_145850_b, (double)pos.x, (double)pos.y, (double)pos.z, new ItemStack(bases.sign2.overlay.item, 1));
            this.field_145850_b.func_72838_d((Entity)item);
        }
        if (PostHandler.getPosts().remove(pos) != null) {
            NetworkHandler.netWrap.sendToAll((IMessage)new SendAllPostBasesMessage());
        }
    }

    @Override
    public void save(NBTTagCompound tagCompound) {
        DoubleBaseInfo bases = this.getBases();
        tagCompound.func_74778_a("base1", "" + bases.sign1.base);
        tagCompound.func_74778_a("base2", "" + bases.sign2.base);
        tagCompound.func_74768_a("rot1", bases.sign1.rotation);
        tagCompound.func_74768_a("rot2", bases.sign2.rotation);
        tagCompound.func_74757_a("flip1", bases.sign1.flip);
        tagCompound.func_74757_a("flip2", bases.sign2.flip);
        tagCompound.func_74778_a("overlay1", "" + (Object)((Object)bases.sign1.overlay));
        tagCompound.func_74778_a("overlay2", "" + (Object)((Object)bases.sign2.overlay));
        tagCompound.func_74757_a("point1", bases.sign1.point);
        tagCompound.func_74757_a("point2", bases.sign2.point);
        tagCompound.func_74778_a("paint1", SuperPostPostTile.locToString(bases.sign1.paint));
        tagCompound.func_74778_a("paint2", SuperPostPostTile.locToString(bases.sign2.paint));
        tagCompound.func_74778_a("postPaint", SuperPostPostTile.locToString(bases.postPaint));
        if (bases.equals(bases.paintObject)) {
            tagCompound.func_74774_a("paintObjectIndex", (byte)1);
        } else if (bases.sign1.equals(bases.paintObject)) {
            tagCompound.func_74774_a("paintObjectIndex", (byte)2);
        } else if (bases.sign2.equals(bases.paintObject)) {
            tagCompound.func_74774_a("paintObjectIndex", (byte)3);
        } else {
            tagCompound.func_74774_a("paintObjectIndex", (byte)0);
        }
    }

    @Override
    public void load(NBTTagCompound tagCompound) {
        final String base1 = tagCompound.func_74779_i("base1");
        final String base2 = tagCompound.func_74779_i("base2");
        final int rotation1 = tagCompound.func_74762_e("rot1");
        final int rotation2 = tagCompound.func_74762_e("rot2");
        final boolean flip1 = tagCompound.func_74767_n("flip1");
        final boolean flip2 = tagCompound.func_74767_n("flip2");
        final Sign.OverlayType overlay1 = Sign.OverlayType.get(tagCompound.func_74779_i("overlay1"));
        final Sign.OverlayType overlay2 = Sign.OverlayType.get(tagCompound.func_74779_i("overlay2"));
        final boolean point1 = tagCompound.func_74767_n("point1");
        final boolean point2 = tagCompound.func_74767_n("point2");
        final String paint1 = tagCompound.func_74779_i("paint1");
        final String paint2 = tagCompound.func_74779_i("paint2");
        final String postPaint = tagCompound.func_74779_i("postPaint");
        final PostPostTile self = this;
        final byte paintObjectIndex = tagCompound.func_74771_c("paintObjectIndex");
        SPEventHandler.scheduleTask(new BoolRun(){

            @Override
            public boolean run() {
                if (PostPostTile.this.field_145850_b == null || PostPostTile.this.type == null) {
                    return false;
                }
                if (((PostPostTile)PostPostTile.this).field_145850_b.field_72995_K) {
                    return true;
                }
                DoubleBaseInfo bases = PostPostTile.this.getBases();
                bases.sign1.base = PostHandler.getForceWSbyName(base1);
                bases.sign2.base = PostHandler.getForceWSbyName(base2);
                bases.sign1.rotation = rotation1;
                bases.sign2.rotation = rotation2;
                bases.sign1.flip = flip1;
                bases.sign2.flip = flip2;
                bases.sign1.overlay = overlay1;
                bases.sign2.overlay = overlay2;
                bases.sign1.point = point1;
                bases.sign2.point = point2;
                bases.sign1.paint = SuperPostPostTile.stringToLoc(paint1);
                bases.sign2.paint = SuperPostPostTile.stringToLoc(paint2);
                bases.postPaint = postPaint == null || postPaint.equals("") || postPaint.equals("null") || postPaint.equals("minecraft:") ? PostPostTile.this.type.resLocMain : SuperPostPostTile.stringToLoc(postPaint);
                switch (paintObjectIndex) {
                    case 1: {
                        bases.paintObject = bases;
                        bases.awaitingPaint = true;
                        break;
                    }
                    case 2: {
                        bases.paintObject = bases.sign1;
                        bases.awaitingPaint = true;
                        break;
                    }
                    case 3: {
                        bases.paintObject = bases.sign2;
                        bases.awaitingPaint = true;
                        break;
                    }
                    default: {
                        bases.paintObject = null;
                        bases.awaitingPaint = false;
                    }
                }
                NetworkHandler.netWrap.sendToAll((IMessage)new SendPostBasesMessage(self, bases));
                return true;
            }
        });
    }

    @Override
    public Sign getSign(EntityPlayer player) {
        DoubleBaseInfo bases = this.getBases();
        PostPost.Hit hit = (PostPost.Hit)((PostPost)this.func_145838_q()).getHitTarget(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), player);
        if (hit.target.equals((Object)PostPost.HitTarget.BASE1)) {
            return bases.sign1;
        }
        if (hit.target.equals((Object)PostPost.HitTarget.BASE2)) {
            return bases.sign2;
        }
        return null;
    }

    @Override
    public Paintable getPaintable(EntityPlayer player) {
        DoubleBaseInfo bases = this.getBases();
        PostPost.Hit hit = (PostPost.Hit)((PostPost)this.func_145838_q()).getHitTarget(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), player);
        if (hit.target.equals((Object)PostPost.HitTarget.BASE1)) {
            return bases.sign1;
        }
        if (hit.target.equals((Object)PostPost.HitTarget.BASE2)) {
            return bases.sign2;
        }
        return bases;
    }

    @Override
    public ResourceLocation getPostPaint() {
        return this.getBases().postPaint;
    }

    @Override
    public void setPostPaint(ResourceLocation loc) {
        this.getBases().postPaint = loc;
    }

    @Override
    public boolean isAwaitingPaint() {
        return this.getBases().awaitingPaint;
    }

    @Override
    public Paintable getPaintObject() {
        return this.getBases().paintObject;
    }

    @Override
    public void setAwaitingPaint(boolean awaitingPaint) {
        this.getBases().awaitingPaint = awaitingPaint;
    }

    @Override
    public void setPaintObject(Paintable paintObject) {
        this.getBases().paintObject = paintObject;
    }

    public String toString() {
        return this.getBases() + " at " + this.toPos();
    }
}

