/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blocks.tiles;

import gollorum.signpost.SPEventHandler;
import gollorum.signpost.blocks.WaystoneContainer;
import gollorum.signpost.event.UpdateWaystoneEvent;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.BaseUpdateClientMessage;
import gollorum.signpost.network.messages.BaseUpdateServerMessage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.BoolRun;
import gollorum.signpost.util.MyBlockPos;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BasePostTile
extends TileEntity
implements WaystoneContainer {
    public boolean isCanceled = false;

    public BasePostTile setup() {
        SPEventHandler.scheduleTask(new BoolRun(){

            @Override
            public boolean run() {
                if (BasePostTile.this.isCanceled) {
                    return true;
                }
                if (BasePostTile.this.field_145850_b == null) {
                    return false;
                }
                BasePostTile.this.init();
                return true;
            }
        });
        return this;
    }

    @Override
    public BaseInfo getBaseInfo() {
        return PostHandler.allWaystones.getByPos(this.toPos());
    }

    public void init() {
        boolean found = false;
        if (this.getBaseInfo() != null) {
            return;
        }
    }

    public MyBlockPos toPos() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return new MyBlockPos("", this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.dim());
        }
        return new MyBlockPos(this.field_145850_b.func_72912_H().func_76065_j(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.dim());
    }

    public int dim() {
        if (this.field_145850_b == null || this.field_145850_b.field_73011_w == null) {
            return Integer.MIN_VALUE;
        }
        return this.field_145850_b.field_73011_w.getDimension();
    }

    public void onBlockDestroy(MyBlockPos pos) {
        this.isCanceled = true;
        BaseInfo base = this.getBaseInfo();
        if (PostHandler.allWaystones.removeByPos(pos)) {
            MinecraftForge.EVENT_BUS.post((Event)new UpdateWaystoneEvent(UpdateWaystoneEvent.WaystoneEventType.DESTROYED, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), base == null ? "" : base.name));
            NetworkHandler.netWrap.sendToAll((IMessage)new BaseUpdateClientMessage());
        }
    }

    @Override
    public void setName(String name) {
        BaseInfo ws = this.getBaseInfo();
        ws.name = name;
        NetworkHandler.netWrap.sendToServer((IMessage)new BaseUpdateServerMessage(ws, false));
    }

    @Override
    public String getName() {
        BaseInfo ws = this.getBaseInfo();
        return ws == null ? "null" : this.getBaseInfo().toString();
    }

    public String toString() {
        return this.getName();
    }
}

