/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.BlockHandler;
import gollorum.signpost.ItemHandler;
import gollorum.signpost.SPEventHandler;
import gollorum.signpost.blocks.tiles.BasePostTile;
import gollorum.signpost.blocks.tiles.BigPostPostTile;
import gollorum.signpost.blocks.tiles.PostPostTile;
import gollorum.signpost.management.PlayerStorage;
import gollorum.signpost.management.PlayerStore;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CommonProxy {
    public BlockHandler blockHandler = BlockHandler.INSTANCE;

    void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)BlockHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ItemHandler.INSTANCE);
    }

    void init() {
        CommonProxy commonProxy = this;
        commonProxy.blockHandler.init();
        this.blockHandler.register();
        ItemHandler.init();
        ItemHandler.register();
        this.registerCapabilities();
        this.registerTiles();
        NetworkHandler.register();
        SPEventHandler handler = SPEventHandler.INSTANCE;
        MinecraftForge.EVENT_BUS.register((Object)handler);
        MinecraftForge.EVENT_BUS.register((Object)this.blockHandler);
        MinecraftForge.EVENT_BUS.register((Object)ItemHandler.INSTANCE);
    }

    protected void registerTiles() {
        GameRegistry.registerTileEntity(BasePostTile.class, (String)"SignpostBaseTile");
        GameRegistry.registerTileEntity(PostPostTile.class, (String)"SignpostPostTile");
        GameRegistry.registerTileEntity(BigPostPostTile.class, (String)"SignpostBigPostTile");
    }

    protected void registerCapabilities() {
        CapabilityManager.INSTANCE.register(PlayerStore.class, (Capability.IStorage)new PlayerStorage(), PlayerStore.class);
    }

    public World getWorld(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b.field_70170_p;
    }

    public World getWorld(String worldName, int dim) {
        return PostHandler.getWorldByName(worldName, dim);
    }
}

