/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.render.fakemodels;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public class SRMBakedQuadRetextured
extends BakedQuad {
    public SRMBakedQuadRetextured(BakedQuad modelQuad, BakedQuad textureQuad, @Nullable EnumFacing side) {
        super(Arrays.copyOf(textureQuad.func_178209_a(), textureQuad.func_178209_a().length), textureQuad.func_178211_c(), textureQuad.func_178210_d(), textureQuad.func_187508_a(), textureQuad.shouldApplyDiffuseLighting(), textureQuad.getFormat());
        int i;
        EnumFacing face = FaceBakery.func_178410_a((int[])this.func_178209_a());
        int[] aint = Arrays.copyOf(modelQuad.func_178209_a(), modelQuad.func_178209_a().length);
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        float maxZ = Float.MIN_VALUE;
        for (int i2 = 0; i2 < 4; ++i2) {
            int pos = aint.length / 4 * i2;
            float x = Float.intBitsToFloat(aint[pos + 0]);
            float y = Float.intBitsToFloat(aint[pos + 1]);
            float z = Float.intBitsToFloat(aint[pos + 2]);
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            minZ = Math.min(minZ, z);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
            maxZ = Math.max(maxZ, z);
        }
        float rangeX = maxX - minX;
        float rangeY = maxY - minY;
        float rangeZ = maxZ - minZ;
        int[] newAint = Arrays.copyOf(textureQuad.func_178209_a(), textureQuad.func_178209_a().length);
        int[] aint_m = Arrays.copyOf(newAint, newAint.length);
        float minX_m = Float.MAX_VALUE;
        float minY_m = Float.MAX_VALUE;
        float minZ_m = Float.MAX_VALUE;
        float maxX_m = Float.MIN_VALUE;
        float maxY_m = Float.MIN_VALUE;
        float maxZ_m = Float.MIN_VALUE;
        for (int i3 = 0; i3 < 4; ++i3) {
            int pos = aint_m.length / 4 * i3;
            float x = Float.intBitsToFloat(aint_m[pos + 0]);
            float y = Float.intBitsToFloat(aint_m[pos + 1]);
            float z = Float.intBitsToFloat(aint_m[pos + 2]);
            minX_m = Math.min(minX_m, x);
            minY_m = Math.min(minY_m, y);
            minZ_m = Math.min(minZ_m, z);
            maxX_m = Math.max(maxX_m, x);
            maxY_m = Math.max(maxY_m, y);
            maxZ_m = Math.max(maxZ_m, z);
        }
        float rangeX_m = maxX_m - minX_m;
        float rangeY_m = maxY_m - minY_m;
        float rangeZ_m = maxZ_m - minZ_m;
        int uvIndex = textureQuad.getFormat().func_177344_b(0) / 4;
        TextureAtlasSprite sprite = textureQuad.func_187508_a();
        float texMinU = sprite.func_188537_a(Float.intBitsToFloat(newAint[0 * textureQuad.getFormat().func_181719_f() + uvIndex]));
        float texMinV = sprite.func_188536_b(Float.intBitsToFloat(newAint[0 * textureQuad.getFormat().func_181719_f() + uvIndex + 1]));
        float texRangeU = Math.abs(sprite.func_188537_a(Float.intBitsToFloat(newAint[2 * textureQuad.getFormat().func_181719_f() + uvIndex])) - texMinU);
        float texRangeV = Math.abs(sprite.func_188536_b(Float.intBitsToFloat(newAint[2 * textureQuad.getFormat().func_181719_f() + uvIndex + 1])) - texMinV);
        boolean postQuad = false;
        for (int i4 = 0; i4 < 4; ++i4) {
            float offsetBaseV;
            float offsetBaseU;
            int pos = aint.length / 4 * i4;
            float textureX = Float.intBitsToFloat(newAint[pos + 0]);
            float textureY = Float.intBitsToFloat(newAint[pos + 1]);
            float textureZ = Float.intBitsToFloat(newAint[pos + 2]);
            boolean inRangeX = this.isWithinRange(textureX, minX, maxX);
            boolean inRangeY = this.isWithinRange(textureY, minY, maxY);
            boolean inRangeZ = this.isWithinRange(textureZ, minZ, maxZ);
            if (inRangeX && inRangeY && inRangeZ || side == null) {
                postQuad = true;
            }
            float rangeBaseU = 16.0f;
            float rangeBaseV = 16.0f;
            if (face.func_176740_k() == EnumFacing.Axis.X) {
                rangeBaseU /= this.getStretchValue(rangeZ, rangeZ_m);
                rangeBaseV /= this.getStretchValue(rangeY, rangeY_m);
                offsetBaseU = 1.0f - rangeZ - rangeZ_m;
                offsetBaseV = 1.0f - rangeY - rangeY_m;
            } else if (face.func_176740_k() == EnumFacing.Axis.Y) {
                rangeBaseU /= this.getStretchValue(rangeX, rangeX_m);
                rangeBaseV /= this.getStretchValue(rangeZ, rangeZ_m);
                offsetBaseU = 1.0f - rangeX - rangeX_m;
                offsetBaseV = 1.0f - rangeZ - rangeZ_m;
            } else {
                rangeBaseU /= this.getStretchValue(rangeX, rangeX_m);
                rangeBaseV /= this.getStretchValue(rangeY, rangeY_m);
                offsetBaseU = 1.0f - rangeX - rangeX_m;
                offsetBaseV = 1.0f - rangeY - rangeY_m;
            }
            float newTexMinU = texMinU + Math.max(offsetBaseU * 8.0f, 0.0f);
            float newTexMinV = texMinV + Math.max(offsetBaseV * 8.0f, 0.0f);
            float newMaxU = rangeBaseU / 16.0f * texRangeU + newTexMinU;
            float newMaxV = rangeBaseV / 16.0f * texRangeV + newTexMinV;
            BlockFaceUV faceUV = new BlockFaceUV(new float[]{newTexMinU, newTexMinV, newMaxU, newMaxV}, 0);
            newAint[pos + 0] = Float.floatToRawIntBits(Float.intBitsToFloat(newAint[pos + 0]) * rangeX + minX);
            newAint[pos + 1] = Float.floatToRawIntBits(Float.intBitsToFloat(newAint[pos + 1]) * rangeY + minY);
            newAint[pos + 2] = Float.floatToRawIntBits(Float.intBitsToFloat(newAint[pos + 2]) * rangeZ + minZ);
            newAint[pos + 4] = Float.floatToRawIntBits(sprite.func_94214_a((double)faceUV.func_178348_a(i4)));
            newAint[pos + 5] = Float.floatToRawIntBits(sprite.func_94207_b((double)faceUV.func_178346_b(i4)));
            if (this.stretchSide(side, EnumFacing.Axis.X, rangeX)) {
                newAint[pos + 0] = aint[pos + 0];
            }
            if (this.stretchSide(side, EnumFacing.Axis.Y, rangeY)) {
                newAint[pos + 1] = aint[pos + 1];
            }
            if (!this.stretchSide(side, EnumFacing.Axis.Z, rangeZ)) continue;
            newAint[pos + 2] = aint[pos + 2];
        }
        int[] vertexAint = this.func_178209_a();
        if (!postQuad) {
            for (i = 0; i < vertexAint.length; ++i) {
                vertexAint[i] = 0;
            }
        } else {
            for (i = 0; i < vertexAint.length; ++i) {
                vertexAint[i] = newAint[i];
            }
        }
    }

    public boolean stretchSide(EnumFacing facing, EnumFacing.Axis axis, float axisRange) {
        return axisRange != 1.0f;
    }

    private boolean isWithinRange(float num, float min, float max) {
        return MathHelper.func_76131_a((float)((float)Math.round(num * 10.0f) / 10.0f), (float)((float)Math.round(min * 10.0f) / 10.0f), (float)((float)Math.round(max * 10.0f) / 10.0f)) == (float)Math.round(num * 10.0f) / 10.0f;
    }

    private float getStretchValue(float range, float range_m) {
        return range_m <= range ? 1.0f : 1.0f / (range / range_m);
    }
}

