/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.handler;

import com.wynprice.secretroomsmod.SecretConfig;
import com.wynprice.secretroomsmod.SecretItems;
import com.wynprice.secretroomsmod.SecretRooms5;
import com.wynprice.secretroomsmod.base.interfaces.ISecretBlock;
import com.wynprice.secretroomsmod.items.CamouflagePaste;
import com.wynprice.secretroomsmod.network.SecretNetwork;
import com.wynprice.secretroomsmod.network.packets.MessagePacketSwingArm;
import com.wynprice.secretroomsmod.network.packets.MessagePacketSyncEnergizedPaste;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="secretroomsmod")
public class EnergizedPasteHandler {
    private static HashMap<Integer, HashMap<BlockPos, Pair<IBlockState, IBlockState>>> energized_map = new HashMap();
    private static ArrayList<Location> previousServerTickMap = new ArrayList();

    public static void putState(World world, BlockPos pos, IBlockState state) {
        EnergizedPasteHandler.putState(world.field_73011_w.getDimension(), pos, state, world.func_180495_p(pos));
    }

    public static void putState(int dim, BlockPos pos, IBlockState state, IBlockState replaceState) {
        pos = new BlockPos((Vec3i)pos);
        HashMap<BlockPos, Pair> innerMap = energized_map.get(dim) == null || energized_map.get(dim).keySet() == null || energized_map.get(dim).keySet().isEmpty() ? new HashMap<BlockPos, Pair>() : energized_map.get(dim);
        innerMap.put(pos, Pair.of((Object)state, (Object)replaceState));
        energized_map.put(dim, innerMap);
    }

    public static void removeReplacedState(int dim, BlockPos pos) {
        pos = new BlockPos((Vec3i)pos);
        HashMap innerMap = energized_map.get(dim) == null || energized_map.get(dim).keySet() == null || energized_map.get(dim).keySet().isEmpty() ? new HashMap() : energized_map.get(dim);
        try {
            if (innerMap.containsKey(pos)) {
                innerMap.remove(pos);
            }
        }
        catch (ConcurrentModificationException e) {
            e.printStackTrace();
            return;
        }
        energized_map.put(dim, innerMap);
    }

    public static boolean hasReplacedState(World world, BlockPos pos) {
        pos = new BlockPos((Vec3i)pos);
        if (energized_map.get(world.field_73011_w.getDimension()) == null) {
            return false;
        }
        HashMap<BlockPos, Pair<IBlockState, IBlockState>> innerMap = energized_map.get(world.field_73011_w.getDimension());
        if (innerMap.containsKey(pos)) {
            return EnergizedPasteHandler.canBlockBeMirrored(world.func_180495_p(pos).func_177230_c(), world, world.func_180495_p(pos), pos);
        }
        return false;
    }

    public static IBlockState getReplacedState(World world, BlockPos pos) {
        if (!EnergizedPasteHandler.hasReplacedState(world, pos = new BlockPos((Vec3i)pos))) {
            return Blocks.field_150348_b.func_176223_P();
        }
        try {
            for (BlockPos blockpos : energized_map.get(world.field_73011_w.getDimension()).keySet()) {
                if (!blockpos.equals((Object)pos)) continue;
                return (IBlockState)energized_map.get(world.field_73011_w.getDimension()).get(blockpos).getLeft();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static IBlockState getSetBlockState(World world, BlockPos pos) {
        if (!EnergizedPasteHandler.hasReplacedState(world, pos = new BlockPos((Vec3i)pos))) {
            return Blocks.field_150348_b.func_176223_P();
        }
        for (BlockPos blockpos : energized_map.get(world.field_73011_w.getDimension()).keySet()) {
            if (!blockpos.equals((Object)pos)) continue;
            return (IBlockState)energized_map.get(world.field_73011_w.getDimension()).get(blockpos).getRight();
        }
        return Blocks.field_150348_b.func_176223_P();
    }

    @Deprecated
    public static boolean canBlockBeMirrored(Block block, World world, IBlockState state, BlockPos pos) {
        if (block.func_149716_u() || block.hasTileEntity(state)) {
            return EnergizedPasteHandler.tileEntityOptIn(block, world, state, pos);
        }
        if (block instanceof ISecretBlock) {
            return false;
        }
        boolean directFromClass = false;
        try {
            directFromClass = (Boolean)block.getClass().getMethod("SRMcanBlockBeMirrored", World.class, IBlockState.class, BlockPos.class).invoke((Object)block, world, state, pos);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return directFromClass || !Arrays.asList(SecretConfig.ENERGIZED_PASTE.blacklistMirror).contains(block.getRegistryName().toString());
    }

    @Deprecated
    public static boolean tileEntityOptIn(Block block, World world, IBlockState state, BlockPos pos) {
        boolean directFromClass = false;
        try {
            directFromClass = (Boolean)block.getClass().getMethod("SRMdoesTileEntityOptIn", World.class, IBlockState.class, BlockPos.class).invoke((Object)block, world, state, pos);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean starred = false;
        for (String te : SecretConfig.ENERGIZED_PASTE.tileEntityWhitelist) {
            ResourceLocation location = new ResourceLocation(te);
            if (!location.func_110623_a().equals("*") || !location.func_110624_b().equals(block.getRegistryName().func_110624_b())) continue;
            starred = true;
        }
        return directFromClass || Arrays.asList(SecretConfig.ENERGIZED_PASTE.tileEntityWhitelist).contains(block.getRegistryName().toString()) || starred;
    }

    @Deprecated
    public static boolean canBlockBeReplaced(Block block, World world, IBlockState state, BlockPos pos) {
        if (block instanceof ISecretBlock) {
            return false;
        }
        boolean directFromClass = false;
        try {
            directFromClass = (Boolean)block.getClass().getMethod("SRMcanBlockBeReplaced", World.class, IBlockState.class, BlockPos.class).invoke((Object)block, world, state, pos);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return directFromClass || !Arrays.asList(SecretConfig.ENERGIZED_PASTE.replacementBlacklist).contains(block.getRegistryName().toString());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onBlockBoundingBoxDrawn(DrawBlockHighlightEvent event) {
        if (event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK && EnergizedPasteHandler.hasReplacedState((World)Minecraft.func_71410_x().field_71441_e, event.getTarget().func_178782_a())) {
            event.setCanceled(true);
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            BlockPos blockpos = event.getTarget().func_178782_a();
            IBlockState iblockstate = EnergizedPasteHandler.getReplacedState((World)Minecraft.func_71410_x().field_71441_e, blockpos);
            if (iblockstate.func_185904_a() != Material.field_151579_a && Minecraft.func_71410_x().field_71441_e.func_175723_af().func_177746_a(blockpos)) {
                double d3 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
                double d4 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
                double d5 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
                event.getContext();
                RenderGlobal.func_189697_a((AxisAlignedBB)iblockstate.func_185918_c((World)Minecraft.func_71410_x().field_71441_e, blockpos).func_186662_g((double)0.002f).func_72317_d(-d3, -d4, -d5), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }

    @SubscribeEvent
    public static void onMouseRightClick(PlayerInteractEvent.RightClickBlock event) {
        Location location = new Location(event.getPos(), event.getWorld());
        if (EnergizedPasteHandler.hasReplacedState(event.getWorld(), event.getPos()) && event.getEntityPlayer().func_184614_ca().func_190926_b() && event.getEntityPlayer().func_70093_af() || previousServerTickMap.contains(location)) {
            if (!event.getWorld().field_72995_K) {
                if (previousServerTickMap.contains(location)) {
                    previousServerTickMap.remove(location);
                } else {
                    previousServerTickMap.add(location);
                    IBlockState state = EnergizedPasteHandler.getReplacedState(event.getWorld(), event.getPos());
                    EnergizedPasteHandler.removeReplacedState(event.getWorld().field_73011_w.getDimension(), event.getPos());
                    SecretNetwork.sendToAll(new MessagePacketSyncEnergizedPaste(event.getWorld().field_73011_w.getDimension(), event.getPos(), null, false));
                    if (((EntityPlayerMP)event.getEntityPlayer()).field_71134_c.func_73081_b() == GameType.SURVIVAL) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        nbt.func_74778_a("hit_block", state.func_177230_c().getRegistryName().toString());
                        nbt.func_74768_a("hit_meta", state.func_177230_c().func_176201_c(state));
                        nbt.func_74768_a("hit_color", state.func_185909_g((IBlockAccess)event.getWorld(), (BlockPos)event.getPos()).field_76291_p);
                        ItemStack stack = new ItemStack(SecretItems.CAMOUFLAGE_PASTE, 1, 1);
                        stack.func_77982_d(nbt);
                        boolean flag = event.getEntityPlayer().field_71071_by.func_70441_a(stack);
                        if (flag) {
                            event.getEntityPlayer().field_70170_p.func_184148_a((EntityPlayer)null, event.getEntityPlayer().field_70165_t, event.getEntityPlayer().field_70163_u, event.getEntityPlayer().field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((event.getEntityPlayer().func_70681_au().nextFloat() - event.getEntityPlayer().func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                            event.getEntityPlayer().field_71069_bz.func_75142_b();
                        } else {
                            EntityItem entityitem = new EntityItem(event.getWorld(), (double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o() + 1.0, (double)event.getPos().func_177952_p() + 0.5, stack);
                            entityitem.func_174868_q();
                            entityitem.func_145797_a(event.getEntityPlayer().func_70005_c_());
                            event.getWorld().func_72838_d((Entity)entityitem);
                        }
                    }
                }
            }
            event.setCanceled(true);
        } else if (event.getEntityPlayer().func_184614_ca().func_77973_b() == SecretItems.CAMOUFLAGE_PASTE && event.getEntityPlayer().func_184614_ca().func_77960_j() == 1) {
            Block block;
            IBlockState state;
            ItemStack stack;
            if (event.getEntityPlayer().func_70093_af() && EnergizedPasteHandler.canBlockBeMirrored(event.getWorld().func_180495_p(event.getPos()).func_177230_c(), event.getWorld(), event.getWorld().func_180495_p(event.getPos()), event.getPos())) {
                if (!event.getEntityPlayer().func_184614_ca().func_77942_o()) {
                    event.getEntityPlayer().func_184614_ca().func_77982_d(new NBTTagCompound());
                }
                event.getEntityPlayer().func_184614_ca().func_77978_p().func_74778_a("hit_block", event.getWorld().func_180495_p(event.getPos()).func_177230_c().getRegistryName().toString());
                event.getEntityPlayer().func_184614_ca().func_77978_p().func_74768_a("hit_meta", event.getWorld().func_180495_p(event.getPos()).func_177230_c().func_176201_c(event.getWorld().func_180495_p(event.getPos())));
                event.getEntityPlayer().func_184614_ca().func_77978_p().func_74768_a("hit_color", event.getWorld().func_180495_p((BlockPos)event.getPos()).func_185909_g((IBlockAccess)event.getWorld(), (BlockPos)event.getPos()).field_76291_p);
                event.getEntityPlayer().func_184609_a(EnumHand.MAIN_HAND);
                SoundEvent soundEvent = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(SecretConfig.ENERGIZED_PASTE.soundSetName));
                if (soundEvent == null) {
                    soundEvent = SoundEvents.field_187753_eE;
                }
                event.getWorld().func_184133_a(event.getEntityPlayer(), event.getPos(), soundEvent, SoundCategory.BLOCKS, (float)SecretConfig.ENERGIZED_PASTE.soundSetVolume, (float)SecretConfig.ENERGIZED_PASTE.soundSetPitch);
            } else if (!EnergizedPasteHandler.hasReplacedState(event.getWorld(), event.getPos()) && (stack = event.getEntityPlayer().func_184614_ca()).func_77942_o() && stack.func_77978_p().func_150297_b("hit_block", 8) && stack.func_77978_p().func_150297_b("hit_meta", 99) && (state = (block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(stack.func_77978_p().func_74779_i("hit_block")))).func_176203_a(stack.func_77978_p().func_74762_e("hit_meta"))).func_185904_a() != Material.field_151579_a && EnergizedPasteHandler.canBlockBeMirrored(block, event.getWorld(), state, event.getPos()) && EnergizedPasteHandler.canBlockBeReplaced(event.getWorld().func_180495_p(event.getPos()).func_177230_c(), event.getWorld(), event.getWorld().func_180495_p(event.getPos()), event.getPos())) {
                if (!event.getWorld().field_72995_K) {
                    EnergizedPasteHandler.putState(event.getWorld(), event.getPos(), state);
                    SecretNetwork.sendToAll(new MessagePacketSyncEnergizedPaste(event.getWorld().field_73011_w.getDimension(), event.getPos(), state, true));
                    if (((EntityPlayerMP)event.getEntityPlayer()).field_71134_c.func_73081_b() == GameType.SURVIVAL) {
                        if (!previousServerTickMap.contains(location)) {
                            event.getEntityPlayer().func_184614_ca().func_190918_g(1);
                            previousServerTickMap.add(location);
                        } else {
                            previousServerTickMap.remove(location);
                        }
                    }
                    event.getEntityPlayer().func_184609_a(EnumHand.MAIN_HAND);
                    SecretNetwork.sendToPlayer(event.getEntityPlayer(), new MessagePacketSwingArm(EnumHand.MAIN_HAND));
                } else {
                    SoundEvent soundEvent = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(SecretConfig.ENERGIZED_PASTE.soundUseName));
                    if (soundEvent == null) {
                        soundEvent = SoundEvents.field_187872_fl;
                    }
                    event.getWorld().func_184133_a(event.getEntityPlayer(), event.getPos(), soundEvent, SoundCategory.BLOCKS, (float)SecretConfig.ENERGIZED_PASTE.soundUseVolume, (float)SecretConfig.ENERGIZED_PASTE.soundUsePitch);
                }
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWorldSaved(WorldEvent.Save event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)EnergizedPasteHandler.saveToNBT(), (OutputStream)new FileOutputStream(new File(FMLCommonHandler.instance().getSavesDirectory(), FMLCommonHandler.instance().getMinecraftServerInstance().func_71270_I() + "/" + "secretroomsmod" + "_data.dat")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onEntityTick(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        for (Entity entity : new ArrayList(event.world.field_72996_f)) {
            NBTTagCompound compound;
            EntityItem ei;
            if (!(entity instanceof EntityItem) || !((ei = (EntityItem)entity).func_92059_d().func_77973_b() instanceof CamouflagePaste)) continue;
            if (ei.func_70027_ad() || ei.field_70170_p.func_180495_p(ei.func_180425_c()).func_177230_c() == Blocks.field_150480_ab) {
                compound = new NBTTagCompound();
                ei.func_70014_b(compound);
                compound.func_74777_a("Health", (short)100);
                ei.func_70037_a(compound);
                if (ei.func_92059_d().func_77958_k() != 0 || ei.field_70128_L || ei.func_92059_d().func_190916_E() < 5) continue;
                EntityItem newItem = new EntityItem(ei.field_70170_p, ei.field_70165_t, ei.field_70163_u, ei.field_70161_v, new ItemStack(SecretItems.CAMOUFLAGE_PASTE, Math.floorDiv(ei.func_92059_d().func_190916_E(), 5), 1));
                newItem.field_70159_w = ei.field_70159_w;
                newItem.field_70181_x = ei.field_70181_x;
                newItem.field_70179_y = ei.field_70179_y;
                newItem.field_70290_d = ei.field_70290_d;
                newItem.field_70177_z = ei.field_70177_z;
                if (ei.func_92059_d().func_190916_E() % 5 == 0) {
                    ei.func_70106_y();
                } else {
                    ei.func_92059_d().func_190920_e(ei.func_92059_d().func_190916_E() % 5);
                }
                event.world.func_72838_d((Entity)newItem);
                continue;
            }
            compound = new NBTTagCompound();
            ei.func_70014_b(compound);
            if (compound.func_74765_d("Health") <= 5) continue;
            compound.func_74777_a("Health", (short)5);
            ei.func_70037_a(compound);
        }
    }

    @SubscribeEvent
    public static void onWorldLoaded(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(new File(FMLCommonHandler.instance().getSavesDirectory(), FMLCommonHandler.instance().getMinecraftServerInstance().func_71270_I() + "/" + "secretroomsmod" + "_data.dat")));
            if (nbt != null) {
                EnergizedPasteHandler.readFromNBT(nbt);
            }
        }
        catch (FileNotFoundException e) {
            SecretRooms5.LOGGER.info("Secret Rooms Mod file cannot be found. Assuming world creation");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public static NBTTagCompound saveToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound nbt_info = new NBTTagCompound();
        NBTTagCompound nbt_worlds = new NBTTagCompound();
        HashMap<Integer, HashMap<BlockPos, Pair<IBlockState, IBlockState>>> energized_map = EnergizedPasteHandler.energized_map;
        int[] dimensions = new int[energized_map.size()];
        for (int i = 0; i < dimensions.length; ++i) {
            dimensions[i] = (Integer)energized_map.keySet().toArray()[i];
        }
        nbt_info.func_74783_a("dimensions", dimensions);
        ArrayList<Integer> list = new ArrayList<Integer>(energized_map.keySet());
        for (int i : list) {
            if (energized_map.get(i) == null) continue;
            NBTTagCompound nbt_world = new NBTTagCompound();
            int[] blockPositions = new int[energized_map.get(i).size() * 3];
            int index = 0;
            ArrayList<BlockPos> list1 = new ArrayList<BlockPos>(energized_map.get(i).keySet());
            for (BlockPos pos : list1) {
                NBTTagCompound nbt_blockstate = new NBTTagCompound();
                blockPositions[index++] = pos.func_177958_n();
                blockPositions[index++] = pos.func_177956_o();
                blockPositions[index++] = pos.func_177952_p();
                nbt_blockstate.func_74778_a("block", ((IBlockState)energized_map.get(i).get(pos).getLeft()).func_177230_c().getRegistryName().toString());
                nbt_blockstate.func_74768_a("meta", ((IBlockState)energized_map.get(i).get(pos).getLeft()).func_177230_c().func_176201_c((IBlockState)energized_map.get(i).get(pos).getLeft()));
                nbt_blockstate.func_74778_a("replace_block", ((IBlockState)energized_map.get(i).get(pos).getRight()).func_177230_c().getRegistryName().toString());
                nbt_blockstate.func_74768_a("replace_meta", ((IBlockState)energized_map.get(i).get(pos).getRight()).func_177230_c().func_176201_c((IBlockState)energized_map.get(i).get(pos).getRight()));
                nbt_world.func_74782_a(String.valueOf(pos.func_177958_n()) + " " + String.valueOf(pos.func_177956_o()) + " " + String.valueOf(pos.func_177952_p()), (NBTBase)nbt_blockstate);
            }
            nbt_world.func_74783_a("blockpos", blockPositions);
            nbt_worlds.func_74782_a("dimension_" + String.valueOf(i), (NBTBase)nbt_world);
        }
        nbt.func_74782_a("worlds", (NBTBase)nbt_worlds);
        nbt.func_74782_a("info", (NBTBase)nbt_info);
        return nbt;
    }

    public static void readFromNBT(NBTTagCompound nbt) {
        energized_map.clear();
        NBTTagCompound world_info = nbt.func_74775_l("info");
        for (int dimension : world_info.func_74759_k("dimensions")) {
            NBTTagCompound nbt_world = nbt.func_74775_l("worlds").func_74775_l("dimension_" + String.valueOf(dimension));
            int[] blockpos = nbt_world.func_74759_k("blockpos");
            for (int i = 0; i < blockpos.length; i += 3) {
                NBTTagCompound nbt_blockstate = nbt_world.func_74775_l(String.valueOf(blockpos[i]) + " " + String.valueOf(blockpos[i + 1]) + " " + String.valueOf(blockpos[i + 2]));
                EnergizedPasteHandler.putState(dimension, new BlockPos(blockpos[i], blockpos[i + 1], blockpos[i + 2]), ((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt_blockstate.func_74779_i("block")))).func_176203_a(nbt_blockstate.func_74762_e("meta")), ((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt_blockstate.func_74779_i("replace_block")))).func_176203_a(nbt_blockstate.func_74762_e("replace_meta")));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        SecretNetwork.sendToPlayer(event.player, new MessagePacketSyncEnergizedPaste(EnergizedPasteHandler.saveToNBT(), null));
    }

    public static HashMap<Integer, HashMap<BlockPos, Pair<IBlockState, IBlockState>>> getEnergized_map() {
        return energized_map;
    }

    private static class Location {
        private final BlockPos pos;
        private final World world;

        public Location(BlockPos pos, World world) {
            this.pos = pos;
            this.world = world;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public World getWorld() {
            return this.world;
        }

        public boolean equals(Object obj) {
            return obj instanceof Location && ((Location)obj).pos.equals((Object)this.pos) && ((Location)obj).world.field_73011_w.getDimension() == this.world.field_73011_w.getDimension();
        }
    }
}

