/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TorchLever
extends BlockTorch {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"active");

    public TorchLever() {
        this.setRegistryName("torch_lever");
        this.func_149663_c("torch_lever");
        this.func_149711_c(0.0f);
    }

    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) * ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 2 : 1);
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta / 2).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta % 2 == 1));
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 15;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED, field_176596_a});
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return TorchLever.canAttachTo(worldIn, pos, side);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!TorchLever.canAttachTo(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canAttachTo(World worldIn, BlockPos p_181090_1_, EnumFacing p_181090_2_) {
        return TorchLever.canPlaceBlock(worldIn, p_181090_1_, p_181090_2_);
    }

    protected static boolean canPlaceBlock(World worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        boolean flag = iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, direction) == BlockFaceShape.SOLID;
        Block block = iblockstate.func_177230_c();
        if (direction == EnumFacing.UP) {
            return iblockstate.func_185896_q() || !TorchLever.func_193384_b((Block)block) && flag;
        }
        return !TorchLever.func_193382_c((Block)block) && flag;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        if (TorchLever.canAttachTo(worldIn, pos, facing) && facing != EnumFacing.DOWN) {
            return iblockstate.func_177226_a((IProperty)field_176596_a, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (enumfacing == facing || !TorchLever.canAttachTo(worldIn, pos, enumfacing)) continue;
            return iblockstate.func_177226_a((IProperty)field_176596_a, (Comparable)enumfacing);
        }
        if (worldIn.func_180495_p(pos.func_177977_b()).func_185896_q()) {
            return iblockstate.func_177226_a((IProperty)field_176596_a, (Comparable)EnumFacing.UP);
        }
        return iblockstate;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.checkCanSurvive(worldIn, pos, state) && !TorchLever.canAttachTo(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)field_176596_a))) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    private boolean checkCanSurvive(World worldIn, BlockPos pos, IBlockState state) {
        if (this.func_176196_c(worldIn, pos)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        state = state.func_177231_a((IProperty)POWERED);
        worldIn.func_180501_a(pos, state, 3);
        float f = (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 0.6f : 0.5f;
        worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, f);
        worldIn.func_175685_c(pos, (Block)this, false);
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_176596_a);
        worldIn.func_175685_c(pos.func_177972_a(enumfacing.func_176734_d()), (Block)this, false);
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            worldIn.func_175685_c(pos, (Block)this, false);
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_176596_a);
            worldIn.func_175685_c(pos.func_177972_a(enumfacing.func_176734_d()), (Block)this, false);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 0;
        }
        return blockState.func_177229_b((IProperty)field_176596_a) == side ? 15 : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }
}

