/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.utils.math.geometry;

import com.austinv11.collectiveframework.utils.ArrayUtils;
import com.austinv11.collectiveframework.utils.math.MathUtils;
import com.austinv11.collectiveframework.utils.math.TwoDimensionalVector;
import com.austinv11.collectiveframework.utils.math.geometry.IncompatibleDimensionsException;
import com.austinv11.collectiveframework.utils.math.geometry.Line;
import java.util.ArrayList;
import java.util.Arrays;

public class Variable2DShape {
    private Line[] sides;

    public Variable2DShape(TwoDimensionalVector ... vectors) throws IncompatibleDimensionsException {
        if (vectors.length < 3) {
            throw new IncompatibleDimensionsException("Not enough vectors!");
        }
        Arrays.sort(vectors);
        Line[] lines = new Line[vectors.length];
        for (int i = 0; i < vectors.length; ++i) {
            lines[i] = new Line(vectors[i], ArrayUtils.wrappedRetrieve(vectors, i + 1));
        }
        this.sides = lines;
        this.init();
    }

    public Variable2DShape(Line ... lines) throws IncompatibleDimensionsException {
        if (lines.length < 3) {
            throw new IncompatibleDimensionsException("Not enough sides!");
        }
        this.sides = lines;
        this.init();
    }

    private void init() throws IncompatibleDimensionsException {
        int numOfSides = this.getNumberOfSides();
        TwoDimensionalVector[] nonRepeatingVectors = this.getVertices();
        if (nonRepeatingVectors.length != numOfSides) {
            throw new IncompatibleDimensionsException("The dimensions do not connect to form a polygon!");
        }
    }

    public int getNumberOfSides() {
        return this.sides.length;
    }

    public TwoDimensionalVector[] getVertices() {
        ArrayList<TwoDimensionalVector> vectors = new ArrayList<TwoDimensionalVector>();
        for (Line line : this.sides) {
            vectors.add(line.get2DStart());
            vectors.add(line.get2DEnd());
        }
        TwoDimensionalVector[] vectorArray = vectors.toArray(new TwoDimensionalVector[vectors.size()]);
        return ArrayUtils.removeRepeats(vectorArray);
    }

    public double getPerimeter() {
        double perimeter = 0.0;
        for (Line line : this.sides) {
            perimeter += line.getLength();
        }
        return perimeter;
    }

    public double getArea() {
        double area = 0.0;
        TwoDimensionalVector[] vertices = this.getVertices();
        for (int i = 0; i < vertices.length; ++i) {
            TwoDimensionalVector vertex1 = ArrayUtils.wrappedRetrieve(vertices, i);
            TwoDimensionalVector vertex2 = ArrayUtils.wrappedRetrieve(vertices, i + 1);
            area += vertex1.getX() * vertex2.getY() - vertex1.getY() * vertex2.getX();
        }
        area = Math.abs(area / 2.0);
        return area;
    }

    public Line[] findSidesWithPoint(TwoDimensionalVector coord) {
        ArrayList<Line> lines = new ArrayList<Line>();
        for (Line line : this.sides) {
            if (!line.isPointValid(coord)) continue;
            lines.add(line);
        }
        return lines.toArray(new Line[lines.size()]);
    }

    public float getAngleForVertex(TwoDimensionalVector vertex) throws IncompatibleDimensionsException {
        Line[] sides = this.findSidesWithPoint(vertex);
        if (sides.length != 2) {
            throw new IncompatibleDimensionsException(vertex.toString() + " is not a valid vertex!");
        }
        double slope1 = Double.isNaN(sides[0].get2DSlope()) ? Double.MAX_VALUE : sides[0].get2DSlope();
        double slope2 = Double.isNaN(sides[1].get2DSlope()) ? Double.MAX_VALUE : sides[1].get2DSlope();
        return (float)Math.atan(Math.abs((slope1 - slope2) / (1.0 + slope1 * slope2)));
    }

    public Line[] getSides() {
        return this.sides;
    }

    public TwoDimensionalVector getCentroid() {
        TwoDimensionalVector[] vertices = this.getVertices();
        double centerX = 0.0;
        double centerY = 0.0;
        for (TwoDimensionalVector vertex : vertices) {
            centerX += vertex.getX();
            centerY += vertex.getY();
        }
        return new TwoDimensionalVector(centerX /= (double)this.getNumberOfSides(), centerY /= (double)this.getNumberOfSides());
    }

    public Variable2DShape setCentroid(TwoDimensionalVector centroid) {
        TwoDimensionalVector oldCentroid = this.getCentroid();
        double xDiff = centroid.getX() - oldCentroid.getX();
        double yDiff = centroid.getY() - oldCentroid.getY();
        TwoDimensionalVector toAdd = new TwoDimensionalVector(xDiff, yDiff);
        TwoDimensionalVector[] vertices = this.getVertices();
        ArrayList<TwoDimensionalVector> newVertices = new ArrayList<TwoDimensionalVector>();
        for (TwoDimensionalVector vertex : vertices) {
            newVertices.add(vertex.add(toAdd));
        }
        try {
            return new Variable2DShape(newVertices.toArray(new TwoDimensionalVector[vertices.length]));
        }
        catch (IncompatibleDimensionsException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Variable2DShape rotate(TwoDimensionalVector point, double angle) {
        TwoDimensionalVector[] vertices = this.getVertices();
        ArrayList<TwoDimensionalVector> newVertices = new ArrayList<TwoDimensionalVector>();
        for (TwoDimensionalVector vertex : vertices) {
            newVertices.add(vertex.rotate(point, angle));
        }
        try {
            return new Variable2DShape(newVertices.toArray(new TwoDimensionalVector[vertices.length]));
        }
        catch (IncompatibleDimensionsException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Variable2DShape rotate(double angle) {
        return this.rotate(this.getCentroid(), angle);
    }

    public boolean isPointOnPerimeter(TwoDimensionalVector coord) {
        for (Line l : this.sides) {
            if (!l.isPointValid(coord)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean isPointValid(TwoDimensionalVector coord) {
        if (this.isPointOnPerimeter(coord)) {
            return true;
        }
        TwoDimensionalVector[] vertices = this.getVertices();
        double[] xVals = new double[vertices.length];
        double[] yVals = new double[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            xVals[i] = vertices[i].getX();
            yVals[i] = vertices[i].getY();
        }
        double minX = MathUtils.getMin(xVals);
        double maxX = MathUtils.getMax(xVals);
        double minY = MathUtils.getMin(yVals);
        double maxY = MathUtils.getMax(yVals);
        return MathUtils.isBetween(minX, maxX, coord.getX(), true) && MathUtils.isBetween(minY, maxY, coord.getY(), true);
    }

    @Deprecated
    public TwoDimensionalVector[] getAllPoints() {
        ArrayList<TwoDimensionalVector> points = new ArrayList<TwoDimensionalVector>();
        TwoDimensionalVector[] vertices = this.getVertices();
        double[] xVals = new double[vertices.length];
        double[] yVals = new double[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            xVals[i] = vertices[i].getX();
            yVals[i] = vertices[i].getY();
        }
        double minX = MathUtils.getMin(xVals);
        double maxX = MathUtils.getMax(xVals);
        double minY = MathUtils.getMin(yVals);
        double maxY = MathUtils.getMax(yVals);
        int x = (int)minX;
        while ((double)x <= maxX) {
            int y = (int)minY;
            while ((double)y <= maxY) {
                if (this.isPointValid(new TwoDimensionalVector(x, y))) {
                    points.add(new TwoDimensionalVector(x, y));
                }
                ++y;
            }
            ++x;
        }
        return points.toArray(new TwoDimensionalVector[points.size()]);
    }

    public boolean equals(Object other) {
        if (other instanceof Variable2DShape) {
            return ((Variable2DShape)other).getNumberOfSides() == this.getNumberOfSides() && ((Variable2DShape)other).getArea() == this.getArea() && ((Variable2DShape)other).getPerimeter() == this.getPerimeter();
        }
        return false;
    }

    public String toString() {
        return "Variable2DShape(Sides:" + this.getNumberOfSides() + ")";
    }
}

