/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.utils;

import com.austinv11.collectiveframework.minecraft.utils.Location;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class WorldUtils {
    public static EntityPlayer getPlayerForWorld(String playerName, World world) {
        return world.func_72924_a(playerName);
    }

    public static World getWorldFromDimensionId(int id) {
        return DimensionManager.getWorld((int)id);
    }

    public static Entity getNearestEntityToLocation(Location location, double maxRange) {
        World world = location.getWorld();
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        Vec3d desired = new Vec3d(x, y, z);
        double lowestDistance = maxRange;
        Entity closest = null;
        for (Entity ent : world.field_72996_f) {
            Vec3d toCompare = new Vec3d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
            double distance = desired.func_72438_d(toCompare);
            if (!(distance <= maxRange) || !(distance < lowestDistance)) continue;
            lowestDistance = distance;
            closest = ent;
        }
        return closest;
    }

    public static Entity getNearestEntityToLocation(Location location) {
        return WorldUtils.getNearestEntityToLocation(location, Double.MAX_VALUE);
    }

    public static EntityItem spawnItemInWorld(Location location, ItemStack stack) {
        EntityItem item = new EntityItem(location.getWorld(), location.getX(), location.getY(), location.getZ(), stack);
        location.getWorld().func_72838_d((Entity)item);
        return item;
    }

    public static boolean doesSpecifiedBlockExists(Location location, Class blockClass) {
        int z;
        int y;
        int x;
        if (!Block.class.isAssignableFrom(blockClass)) {
            return false;
        }
        World world = location.getWorld();
        return !world.func_175623_d(new BlockPos(x = location.getRoundedX(), y = location.getRoundedY(), z = location.getRoundedZ())) && blockClass.isAssignableFrom(world.func_180495_p(new BlockPos(x, y, z)).func_177230_c().getClass());
    }
}

