/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureManager {
    private static List<TextureRegistrar> textureRegistrars = new ArrayList<TextureRegistrar>();

    @SubscribeEvent
    public void onPreTextureStitch(TextureStitchEvent.Pre event) {
        this.registerTextures(event.getMap());
    }

    public static void register(TextureRegistrar textureRegistrar) {
        textureRegistrars.add(textureRegistrar);
    }

    private void registerTextures(TextureMap map) {
        for (TextureRegistrar textureNeeded : textureRegistrars) {
            textureNeeded.registerTextures(map);
        }
    }

    public static interface TextureRegistrar {
        public void registerTextures(TextureMap var1);
    }
}

