/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.utils;

import com.austinv11.collectiveframework.language.TranslationManager;
import com.austinv11.collectiveframework.language.translation.TranslationException;
import com.austinv11.collectiveframework.minecraft.reference.Config;
import java.io.IOException;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MinecraftTranslator {
    public static String translate(String text, String toLang) throws IOException, TranslationException {
        if (I18n.func_188566_a((String)text)) {
            return I18n.func_135052_a((String)text, (Object[])new Object[0]);
        }
        String toTranslate = I18n.func_135052_a((String)text, (Object[])new Object[0]);
        return TranslationManager.translate(toTranslate, toLang);
    }

    public static String translate(String text, String fromLang, String toLang) throws TranslationException, IOException {
        if (I18n.func_188566_a((String)text)) {
            return I18n.func_135052_a((String)text, (Object[])new Object[0]);
        }
        String toTranslate = I18n.func_135052_a((String)text, (Object[])new Object[0]);
        return TranslationManager.translate(toTranslate, fromLang, toLang);
    }

    public static String translateToLocal(String text, String fromLang) throws TranslationException, IOException {
        return MinecraftTranslator.translate(text, fromLang, MinecraftTranslator.langToUsable());
    }

    public static String translateToLocal(String text) throws TranslationException, IOException {
        return MinecraftTranslator.translate(text, MinecraftTranslator.langToUsable());
    }

    public static String langToUsable() {
        return MinecraftTranslator.mcLangCodesToUsable(Minecraft.func_71410_x().field_71474_y.field_74363_ab);
    }

    public static String mcLangCodesToUsable(String code) {
        String[] langInfo = code.split("_");
        Locale loc = new Locale(langInfo[0], langInfo[1]);
        return loc.getLanguage();
    }

    @SubscribeEvent
    public void onTooltipEvent(ItemTooltipEvent event) {
        if (Config.translateItems) {
            try {
                if (I18n.func_135052_a((String)event.getItemStack().func_77977_a(), (Object[])new Object[0]).equals(event.getItemStack().func_82833_r())) {
                    String toTranslate = event.getItemStack().func_82833_r();
                    event.getItemStack().func_151001_c(MinecraftTranslator.translateToLocal(toTranslate, "en"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onChatEvent(ClientChatReceivedEvent event) {
        if (Config.translateChat && !event.isCanceled()) {
            try {
                StringBuilder message = new StringBuilder();
                for (String part : event.getMessage().func_150260_c().split(" ")) {
                    message.append(I18n.func_135052_a((String)part, (Object[])new Object[0])).append(" ");
                }
                event.setMessage((ITextComponent)new TextComponentString(MinecraftTranslator.translateToLocal(message.toString(), "en")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

