/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.network;

import com.austinv11.collectiveframework.minecraft.utils.WorldUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class TileEntityServerUpdatePacket
implements IMessage {
    public World world;
    public int x;
    public int y;
    public int z;
    public NBTTagCompound updateData;

    public TileEntityServerUpdatePacket() {
    }

    public TileEntityServerUpdatePacket(World world, int x, int y, int z, NBTTagCompound updateData) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.updateData = updateData;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.world = WorldUtils.getWorldFromDimensionId(tag.func_74762_e("dim"));
        this.x = tag.func_74762_e("x");
        this.y = tag.func_74762_e("y");
        this.z = tag.func_74762_e("z");
        this.updateData = tag.func_74775_l("tag");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("dim", this.world.field_73011_w.getDimension());
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("y", this.y);
        tag.func_74768_a("z", this.z);
        tag.func_74782_a("tag", (NBTBase)this.updateData);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class TileEntityServerUpdatePacketHandler
    implements IMessageHandler<TileEntityServerUpdatePacket, IMessage> {
        public IMessage onMessage(TileEntityServerUpdatePacket message, MessageContext ctx) {
            TileEntity tileEntity = message.world.func_175625_s(new BlockPos(message.x, message.y, message.z));
            if (tileEntity != null) {
                tileEntity.func_145839_a(message.updateData);
            }
            return null;
        }
    }
}

