/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.books.api;

import com.austinv11.collectiveframework.minecraft.books.api.Page;
import com.austinv11.collectiveframework.minecraft.books.core.GuiBook;
import com.austinv11.collectiveframework.minecraft.books.core.ItemBook;
import com.austinv11.collectiveframework.minecraft.books.core.LocalBookData;
import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.collectiveframework.minecraft.utils.client.GuiUtils;
import com.austinv11.collectiveframework.multithreading.SimpleRunnable;
import java.io.File;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Book {
    public boolean drawDebugLines = false;
    private static final String GLOBAL_DIR = "./CFBookData/";
    private static volatile NBTTagCompound globalData;
    private int currentPage = 0;
    protected ItemBook bookItem;
    protected ItemStack bookStack;
    public EntityPlayer player;
    @SideOnly(value=Side.CLIENT)
    private GuiBook bookGui;

    public Book(ItemBook bookItem, ItemStack bookStack) {
        this.bookItem = bookItem;
        this.bookStack = bookStack;
    }

    public abstract DataStorageType getDataStorageType();

    public NBTTagCompound getData(ItemStack stack) {
        if (this.getDataStorageType() == DataStorageType.GLOBAL) {
            if (globalData == null) {
                File storage = new File(GLOBAL_DIR + this.bookItem.getModId() + "/" + this.bookItem.func_77658_a() + ".dat");
                if (!storage.exists()) {
                    return new NBTTagCompound();
                }
                try {
                    globalData = CompressedStreamTools.func_74797_a((File)storage);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return globalData.func_74737_b();
        }
        if (this.getDataStorageType() == DataStorageType.LOCAL) {
            String key = this.bookItem.getModId() + ":" + this.bookItem.func_77658_a();
            NBTTagCompound retrieved = LocalBookData.retrieveLocalData(key);
            if (retrieved == null) {
                return new NBTTagCompound();
            }
            return (NBTTagCompound)retrieved.func_74737_b();
        }
        return NBTHelper.getCompoundTag(stack, "CFBookData");
    }

    public void setData(final NBTTagCompound data, ItemStack stack) {
        final NBTTagCompound tag = this.getData(stack);
        if (this.getDataStorageType() == DataStorageType.GLOBAL) {
            globalData = data;
            new SimpleRunnable(){

                @Override
                public void run() {
                    tag.func_74782_a(Book.this.player.func_146103_bH().getId().toString(), (NBTBase)data);
                    File storage = new File(Book.GLOBAL_DIR + Book.this.bookItem.getModId() + "/" + Book.this.bookItem.func_77658_a() + ".dat");
                    try {
                        CompressedStreamTools.func_74795_b((NBTTagCompound)tag, (File)storage);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.disable(true);
                }

                @Override
                public String getName() {
                    return "Book Data Serializer";
                }
            }.start();
        } else if (this.getDataStorageType() == DataStorageType.LOCAL) {
            String key = this.bookItem.getModId() + ":" + this.bookItem.func_77658_a();
            tag.func_74782_a(this.player.func_146103_bH().getId().toString(), (NBTBase)data);
            LocalBookData.putLocalData(key, tag);
        } else {
            tag.func_74782_a(this.player.func_146103_bH().getId().toString(), (NBTBase)data);
            NBTHelper.setTag(stack, "CFBookData", (NBTBase)tag);
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setPage(int newPage) {
        if (newPage >= this.getPages().length) {
            newPage = 0;
        } else if (newPage < 0) {
            newPage = this.getPages().length;
        }
        if (this.onPageFlip(this.currentPage, newPage)) {
            this.currentPage = newPage;
            NBTTagCompound data = this.getData(this.bookStack);
            data.func_74768_a("page", this.currentPage);
            this.setData(data, this.bookStack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void handoffGui(GuiBook gui) {
        this.bookGui = gui;
    }

    public void onOpen(EntityPlayer player) {
        this.player = player;
        NBTTagCompound data = this.getData(this.bookStack);
        if (data.func_74764_b("page")) {
            this.setPage(data.func_74762_e("page"));
        }
    }

    public void onClose() {
    }

    @SideOnly(value=Side.CLIENT)
    public void closeBook() {
        GuiUtils.closeCurrentGui(GuiBook.class);
    }

    public abstract boolean doesPauseGame();

    public abstract Page[] getPages();

    public abstract ResourceLocation getBackground();

    @SideOnly(value=Side.CLIENT)
    public abstract void onRender(int var1);

    public abstract boolean onPageFlip(int var1, int var2);

    public static enum DataStorageType {
        GLOBAL,
        LOCAL,
        INSTANCE;

    }
}

