/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft;

import com.austinv11.collectiveframework.minecraft.client.gui.GuiHandler;
import com.austinv11.collectiveframework.minecraft.compat.modules.Modules;
import com.austinv11.collectiveframework.minecraft.config.ConfigException;
import com.austinv11.collectiveframework.minecraft.config.ConfigRegistry;
import com.austinv11.collectiveframework.minecraft.network.ConfigPacket;
import com.austinv11.collectiveframework.minecraft.network.TileEntityClientUpdatePacket;
import com.austinv11.collectiveframework.minecraft.network.TileEntityServerUpdatePacket;
import com.austinv11.collectiveframework.minecraft.network.TimeUpdatePacket;
import com.austinv11.collectiveframework.minecraft.proxy.CommonProxy;
import com.austinv11.collectiveframework.minecraft.reference.Config;
import com.austinv11.collectiveframework.multithreading.SimpleRunnable;
import com.austinv11.collectiveframework.utils.TimeProfiler;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="theframework", name="The Framework", version="1.12.2-1.0.1-build-T23", acceptableRemoteVersions="*", guiFactory="com.austinv11.collectiveframework.minecraft.client.gui.GuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class CollectiveFramework {
    public static SimpleNetworkWrapper NETWORK;
    public static Logger LOGGER;
    @Mod.Instance(value="theframework")
    public static CollectiveFramework instance;
    @SidedProxy(clientSide="com.austinv11.collectiveframework.minecraft.proxy.ClientProxy", serverSide="com.austinv11.collectiveframework.minecraft.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        TimeProfiler profiler = new TimeProfiler();
        try {
            ConfigRegistry.registerConfig(Config.INSTANCE);
        }
        catch (ConfigException e) {
            e.printStackTrace();
        }
        ConfigRegistry.init();
        proxy.registerEvents();
        Modules.init();
        SimpleRunnable.RESTRICT_THREAD_USAGE = Config.restrictThreadUsage;
        NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("austinv11CF");
        Modules.propagate((FMLStateEvent)event);
        LOGGER.info("Pre-Init took " + profiler.getTime() + "ms");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        TimeProfiler profiler = new TimeProfiler();
        ConfigRegistry.init();
        proxy.prepareClient();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        Modules.propagate((FMLStateEvent)event);
        LOGGER.info("Init took " + profiler.getTime() + "ms");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        TimeProfiler profiler = new TimeProfiler();
        ConfigRegistry.init();
        NETWORK.registerMessage(TileEntityServerUpdatePacket.TileEntityServerUpdatePacketHandler.class, TileEntityServerUpdatePacket.class, 0, Side.SERVER);
        NETWORK.registerMessage(TileEntityClientUpdatePacket.TileEntityClientUpdatePacketHandler.class, TileEntityClientUpdatePacket.class, 1, Side.CLIENT);
        NETWORK.registerMessage(ConfigPacket.ConfigPacketHandler.class, ConfigPacket.class, 2, Side.CLIENT);
        NETWORK.registerMessage(TimeUpdatePacket.TimeUpdatePacketHandler.class, TimeUpdatePacket.class, 3, Side.SERVER);
        Modules.propagate((FMLStateEvent)event);
        LOGGER.info("Post-Init took " + profiler.getTime() + "ms");
    }

    @SubscribeEvent
    public void onServerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        this.sendProxySyncToClient((EntityPlayerMP)event.player, false);
    }

    @SubscribeEvent
    public void onClientDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        this.sendProxySyncToClient((EntityPlayerMP)event.player, true);
    }

    private void sendProxySyncToClient(@Nullable EntityPlayerMP player, boolean isRevert) {
        if (FMLCommonHandler.instance().getSide() == Side.SERVER || FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            for (ConfigRegistry.ConfigProxy proxy : ConfigRegistry.configs) {
                String proxyString;
                if (!proxy.doesSync || proxy.fileName == null || !(proxy.config != null & player != null) || (proxyString = proxy.handler.convertToString(proxy.config)) == null) continue;
                try {
                    NETWORK.sendTo((IMessage)new ConfigPacket(proxy.fileName, proxyString, isRevert), player);
                }
                catch (Exception e) {
                    LOGGER.throwing((Throwable)e);
                }
            }
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)"theframework");
    }
}

