/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.EnderCore;
import com.enderio.core.common.util.EnderFileUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.IResourcePack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.io.FileUtils;

public class ResourcePackAssembler {
    private List<CustomFile> files = new ArrayList<CustomFile>();
    private static List<IResourcePack> defaultResourcePacks;
    private static final String MC_META_BASE = "{\"pack\":{\"pack_format\":1,\"description\":\"%s\"}}";
    private File dir;
    private File zip;
    private String name;
    private String mcmeta;
    private String modid;
    private String assetsPath;
    private boolean hasPackPng = false;
    private Class<?> jarClass;

    public ResourcePackAssembler(File directory, String packName, String modid) {
        this.dir = directory;
        this.zip = new File(this.dir.getAbsolutePath() + ".zip");
        this.name = packName;
        this.modid = modid.toLowerCase(Locale.US);
        this.mcmeta = String.format(MC_META_BASE, this.name);
        this.assetsPath = "/assets/" + modid + "/";
    }

    public ResourcePackAssembler setHasPackPng(Class<?> jarClass) {
        this.jarClass = jarClass;
        this.hasPackPng = true;
        return this;
    }

    public void addIcon(File icon) {
        this.files.add(new CustomFile(this.assetsPath + "textures/items/", icon));
        this.files.add(new CustomFile(this.assetsPath + "textures/blocks/", icon));
    }

    public void addLang(File lang) {
        this.files.add(new CustomFile(this.assetsPath + "lang/", lang));
    }

    public void addModel(File model, ModelType type) {
        String path = this.assetsPath + type.getPath() + "/";
        this.files.add(new CustomFile(path, model));
    }

    public void addCustomFile(String path, File file) {
        this.files.add(new CustomFile(path, file));
    }

    public void addCustomFile(File file) {
        this.addCustomFile(null, file);
    }

    public ResourcePackAssembler assemble() {
        EnderFileUtils.safeDeleteDirectory(this.dir);
        this.dir.mkdirs();
        String pathToDir = this.dir.getAbsolutePath();
        File metaFile = new File(pathToDir + "/pack.mcmeta");
        try {
            ResourcePackAssembler.writeNewFile(metaFile, this.mcmeta);
            if (this.hasPackPng) {
                EnderFileUtils.copyFromJar(this.jarClass, this.modid + "/pack.png", new File(this.dir.getAbsolutePath() + "/pack.png"));
            }
            for (CustomFile custom : this.files) {
                File directory = new File(pathToDir + (custom.ext != null ? "/" + custom.ext : ""));
                directory.mkdirs();
                FileUtils.copyFile((File)custom.file, (File)new File(directory.getAbsolutePath() + "/" + custom.file.getName()));
            }
            EnderFileUtils.zipFolderContents(this.dir, this.zip);
            EnderFileUtils.safeDeleteDirectory(this.dir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public void inject() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            try {
                if (defaultResourcePacks == null) {
                    defaultResourcePacks = (List)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"defaultResourcePacks", "field_110449_ao", "ap"});
                }
                File dest = new File(this.dir.getParent() + "/resourcepack/" + this.zip.getName());
                EnderFileUtils.safeDelete(dest);
                FileUtils.copyFile((File)this.zip, (File)dest);
                EnderFileUtils.safeDelete(this.zip);
                ResourcePackAssembler.writeNewFile(new File(dest.getParent() + "/readme.txt"), EnderCore.lang.localize("resourcepack.readme") + "\n\n" + EnderCore.lang.localize("resourcepack.readme2"));
                try (FileResourcePack frp = new FileResourcePack(dest);){
                    defaultResourcePacks.add((IResourcePack)frp);
                }
            }
            catch (Exception e) {
                EnderCore.logger.error("Failed to inject resource pack for mod {}", (Object)this.modid, (Object)e);
            }
        } else {
            EnderCore.logger.info("Skipping resource pack, we are on a dedicated server.");
        }
    }

    private static void writeNewFile(File file, String defaultText) throws IOException {
        EnderFileUtils.safeDelete(file);
        file.delete();
        file.getParentFile().mkdirs();
        file.createNewFile();
        FileWriter fw = new FileWriter(file);
        fw.write(defaultText);
        fw.flush();
        fw.close();
    }

    public static enum ModelType {
        BLOCK("models/block"),
        ITEM("models/item"),
        BLOCKSTATE("blockstates");

        private final String path;

        private ModelType(String path) {
            this.path = path;
        }

        String getPath() {
            return this.path;
        }
    }

    private class CustomFile {
        String ext;
        File file;

        CustomFile(String ext, File file) {
            this.ext = ext;
            this.file = file;
        }
    }
}

